/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.MBlock;
import techguns.world.structures.WorldgenStructure;

public class Tent
extends WorldgenStructure {
    int type;
    MBlock roofBlock = new MBlock(TGBlocks.CAMONET_TOP, 0);
    MBlock wallBlock = new MBlock(TGBlocks.CAMONET, 0);
    MBlock groundBlock = new MBlock(Blocks.field_150351_n, 0);
    IBlockState roofState = this.roofBlock.getState();
    IBlockState wallState = this.wallBlock.getState();
    IBlockState groundState = this.groundBlock.getState();

    public Tent(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int type) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.type = type;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        if (this.type == 0) {
            ++posX;
            ++posZ;
            sizeX -= 2;
            sizeZ -= 2;
        }
        switch (colorType) {
            case DESERT: {
                int camoMeta = 2;
                break;
            }
            case SNOW: {
                int camoMeta = 1;
                break;
            }
            default: {
                int camoMeta = 0;
            }
        }
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    p.func_181079_c(posX + i, posY + k, posZ + j);
                    if (k == 0) {
                        world.func_180501_a((BlockPos)p, this.groundState, 2);
                        continue;
                    }
                    if (k < sizeY - 1) {
                        if (j != 0 && j != sizeZ - 1 && i != 0 && i != sizeX - 1) continue;
                        world.func_180501_a((BlockPos)p, this.wallState, 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)p, this.roofState, 2);
                }
            }
        }
        if (this.type == 0 || this.type == 1) {
            switch (direction) {
                case 0: {
                    world.func_175698_g((BlockPos)p.func_181079_c(posX, posY + 1, posZ + sizeZ / 2));
                    world.func_175698_g((BlockPos)p.func_181079_c(posX, posY + 2, posZ + sizeZ / 2));
                    if (this.type != 0) break;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX - 1, posY, posZ + sizeZ / 2), this.groundState, 2);
                    break;
                }
                case 1: {
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX / 2, posY + 1, posZ));
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX / 2, posY + 2, posZ));
                    if (this.type != 0) break;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + sizeX / 2, posY, posZ - 1), this.groundState, 2);
                    break;
                }
                case 2: {
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX - 1, posY + 1, posZ + sizeZ / 2));
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX - 1, posY + 2, posZ + sizeZ / 2));
                    if (this.type != 0) break;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + sizeX, posY, posZ + sizeZ / 2), this.groundState, 2);
                    break;
                }
                case 3: {
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX / 2, posY + 1, posZ + sizeZ - 1));
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + sizeX / 2, posY + 2, posZ + sizeZ - 1));
                    if (this.type != 0) break;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + sizeX / 2, posY, posZ + sizeZ), this.groundState, 2);
                }
            }
        }
        if (this.type == 2) {
            for (int y = 1; y < sizeY - 1; ++y) {
                if (direction == 0 || direction == 2) {
                    for (int z = 1; z < sizeZ - 1; ++z) {
                        if (z % 3 == 0) continue;
                        int x = direction == 0 ? 0 : sizeX - 1;
                        world.func_175698_g((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z));
                    }
                    continue;
                }
                for (int x = 1; x < sizeX - 1; ++x) {
                    if (x % 3 == 1) continue;
                    int z = direction == 1 ? 0 : sizeZ - 1;
                    world.func_175698_g((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z));
                }
            }
        }
    }
}

