/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.EnumCamoNetType;
import techguns.blocks.EnumLampType;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.EnumLootType;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class CampProps
extends WorldgenStructure {
    MBlock groundBlock = new MBlock(Blocks.field_150351_n, 0);
    IBlockState groundstate = this.groundBlock.getState();
    MBlock[] crateBlocks = MBlockRegister.crates;
    MBlock sandbags = new MBlock(TGBlocks.SANDBAGS, 0);
    IBlockState sandbagsState = this.sandbags.getState();
    IBlockState lampstate;
    int variant;

    public CampProps(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.lampstate = TGBlocks.LAMP_0.func_176223_P().func_177226_a(TGBlocks.LAMP_0.LAMP_TYPE, (Comparable)((Object)EnumLampType.YELLOW_LANTERN));
        this.variant = -1;
        this.lootTier = EnumLootType.TIER1;
    }

    public CampProps(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int variant) {
        this(minX, minY, minZ, maxX, maxY, maxZ);
        this.variant = variant;
        this.lootTier = EnumLootType.TIER1;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        EnumCamoNetType camoMeta;
        switch (colorType) {
            case DESERT: {
                camoMeta = EnumCamoNetType.DESERT;
                break;
            }
            case SNOW: {
                camoMeta = EnumCamoNetType.SNOW;
                break;
            }
            default: {
                camoMeta = EnumCamoNetType.WOOD;
            }
        }
        if (this.variant == -1) {
            this.variant = world.field_73012_v.nextInt(2);
        }
        switch (this.variant) {
            default: {
                this.setCrateBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, rnd);
                break;
            }
            case 1: {
                this.setRoofBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, camoMeta);
                this.setCrateBlocks(world, posX + 1, posY, posZ + 1, sizeX - 2, sizeY - 2, sizeZ - 2, rnd);
                break;
            }
            case 2: {
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 3: {
                this.setRoofBlocks(world, posX, posY + 1, posZ, sizeX, sizeY - 1, sizeZ, camoMeta);
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 4: {
                this.setSandbagRow(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 5: {
                this.setRoofBlocks(world, posX, posY + 1, posZ, sizeX, sizeY - 1, sizeZ, camoMeta);
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                this.setCrateBlocks(world, posX + 1, posY, posZ + 1, sizeX - 2, sizeY - 2, sizeZ - 2, rnd);
            }
        }
    }

    private void setSandbagRow(World world, int px, int py, int pz, int sizeX, int sizeY, int sizeZ, int direction) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int x = 0;
        int z = 0;
        int i = 1;
        for (int y = 1; y < sizeY; ++y) {
            if (sizeX > sizeZ) {
                z = sizeZ / 2;
                for (x = i; x < sizeX - i; ++x) {
                    world.func_180501_a((BlockPos)pos.func_181079_c(px + x, py + y, pz + z), this.sandbagsState, 2);
                }
            } else {
                x = sizeX / 2;
                for (z = i; z < sizeZ - i; ++z) {
                    world.func_180501_a((BlockPos)pos.func_181079_c(px + x, py + y, pz + z), this.sandbagsState, 2);
                }
            }
            ++i;
        }
    }

    private void setSandbagBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction) {
        int zoffset;
        int xoffset;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                if (x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + 1, posZ + z), this.sandbagsState, 2);
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 2;
                break;
            }
            case 1: {
                xoffset = sizeX / 2;
                zoffset = 0;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 2;
                break;
            }
            default: {
                xoffset = sizeX / 2;
                zoffset = sizeZ - 1;
            }
        }
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 1, posZ + zoffset));
    }

    private void setRoofBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, EnumCamoNetType camo) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockUtils.fillBlocks(world, p.func_181079_c(posX, posY + 1, posZ), 1, sizeY - 2, 1, Blocks.field_180407_aO.func_176223_P());
        BlockUtils.fillBlocks(world, p.func_181079_c(posX + sizeX - 1, posY + 1, posZ), 1, sizeY - 2, 1, Blocks.field_180407_aO.func_176223_P());
        BlockUtils.fillBlocks(world, p.func_181079_c(posX, posY + 1, posZ + sizeZ - 1), 1, sizeY - 2, 1, Blocks.field_180407_aO.func_176223_P());
        BlockUtils.fillBlocks(world, p.func_181079_c(posX + sizeX - 1, posY + 1, posZ + sizeZ - 1), 1, sizeY - 2, 1, Blocks.field_180407_aO.func_176223_P());
        BlockUtils.fillBlocks(world, p.func_181079_c(posX, posY + sizeY - 1, posZ), sizeX, 1, sizeZ, TGBlocks.CAMONET_TOP.func_176223_P().func_177226_a((IProperty)TGBlocks.CAMONET_TOP.TYPE, (Comparable)((Object)camo)));
    }

    public void setCrateBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, Random rnd) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY, posZ + z), this.groundstate, 2);
                float chestroll = rnd.nextFloat();
                Object chest = null;
                if (chest != null) continue;
                for (int y = 1; y < sizeY; ++y) {
                    if (this.isFreeSpace(world, posX + x, posY + y - 1, posZ + z) || !(rnd.nextFloat() > 0.5f)) continue;
                    int index = rnd.nextInt(this.crateBlocks.length);
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.crateBlocks[index].getState(), 2);
                }
            }
        }
        if ((float)(sizeX + sizeZ) / 2.0f / 6.0f > rnd.nextFloat()) {
            for (int y = sizeY; y > 1; --y) {
                for (int t = 0; t < 3; ++t) {
                    int z;
                    int x = rnd.nextInt(sizeX);
                    if (!world.func_175623_d((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + (z = rnd.nextInt(sizeZ)))) || this.isFreeSpace(world, posX + x, posY + y - 1, posZ + z)) continue;
                    world.func_180501_a((BlockPos)p, this.lampstate, 2);
                    return;
                }
            }
        }
    }

    public boolean isFreeSpace(World world, int x, int y, int z) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        return world.func_175623_d((BlockPos)p.func_181079_c(x, y, z)) || world.func_180495_p((BlockPos)p).func_177230_c() == Blocks.field_150431_aC || world.func_180495_p((BlockPos)p).func_177230_c() == TGBlocks.LAMP_0;
    }
}

