/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.dungeon.presets;

import java.util.ArrayList;
import java.util.Random;
import techguns.entities.npcs.StormTrooper;
import techguns.tileentities.TGSpawnerTileEnt;
import techguns.world.dungeon.DungeonSegment;
import techguns.world.dungeon.DungeonTemplate;
import techguns.world.dungeon.IDungeonPath;
import techguns.world.dungeon.MazeDungeonPath;
import techguns.world.dungeon.TemplateSegment;
import techguns.world.dungeon.presets.IDungeonPreset;

public class PresetTechFortress
implements IDungeonPreset {
    int sizeXZ = 0;
    int sizeY = 0;
    ArrayList<DungeonTemplate> mainTemplates = new ArrayList();
    ArrayList<DungeonTemplate> topTemplates = new ArrayList();

    public PresetTechFortress() {
        this.mainTemplates.add(DungeonTemplate.dungeonTemplates.get("tfmain"));
        this.topTemplates.add(DungeonTemplate.dungeonTemplates.get("tfupper"));
    }

    @Override
    public DungeonSegment getSegment(TemplateSegment.SegmentType type, int y, int yMin, int yMax, boolean isSegmentAbove, boolean isSegmentBelow, int seed) {
        Random rand = new Random(seed);
        if (!isSegmentAbove && y > 0) {
            return this.topTemplates.get((int)rand.nextInt((int)this.topTemplates.size())).segments.get((Object)type);
        }
        return this.mainTemplates.get((int)rand.nextInt((int)this.topTemplates.size())).segments.get((Object)type);
    }

    @Override
    public int getSizeXZ() {
        if (this.sizeXZ == 0) {
            this.sizeXZ = this.mainTemplates.get((int)0).sizeXZ;
        }
        return this.sizeXZ;
    }

    @Override
    public int getSizeY() {
        if (this.sizeY == 0) {
            this.sizeY = this.mainTemplates.get((int)0).sizeY;
        }
        return this.sizeY;
    }

    @Override
    public void initDungeonPath(IDungeonPath d_path) {
        MazeDungeonPath path = (MazeDungeonPath)d_path;
        path.startHeightLevel = 1;
        path.chanceStraight = 0.8f;
        path.chanceRamp = 0.5f;
        path.chanceRoom = 0.25f;
        path.chanceFork = 0.4f;
        path.chanceUp = 0.65f;
        path.useFoundations = true;
        path.usePillars = true;
        path.useRoof = true;
    }

    @Override
    public void initSpawner(TGSpawnerTileEnt spawner) {
        spawner.setParams(2, 2, 200, 2);
        spawner.addMobType(StormTrooper.class, 1);
    }
}

