/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import techguns.util.MathUtil;
import techguns.world.BlockData;
import techguns.world.BlockRotator;
import techguns.world.EnumLootType;
import techguns.world.structures.WorldgenStructure;

public class MBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    public transient Block block;
    public int meta;
    protected transient IBlockState state;
    protected transient boolean hasTileEntity = false;
    protected transient int layer = 0;
    protected static final HashMap<BlockMeta, MBlock> replacementTable = new HashMap();

    public MBlock(MBlock other) {
        this.block = other.block;
        this.meta = other.meta;
        this.state = other.state;
        this.hasTileEntity = other.hasTileEntity;
        this.layer = other.layer;
    }

    public MBlock(IBlockState state) {
        this(state, false);
    }

    public MBlock(IBlockState state, boolean hasTileEnt) {
        this.block = state.func_177230_c();
        this.meta = this.block.func_176201_c(state);
        this.state = state;
        this.hasTileEntity = hasTileEnt;
        this.layer = BlockData.getBlockLayer(this);
    }

    public MBlock(Block block, int meta) {
        this(block, meta, false);
    }

    public MBlock(String registryname, int meta) {
        this((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(registryname)), meta, false);
    }

    public MBlock(Block block, int meta, boolean hasTileEnt) {
        this.block = block;
        this.meta = meta;
        this.state = block.func_176203_a(meta);
        this.hasTileEntity = hasTileEnt;
        this.layer = BlockData.getBlockLayer(this);
    }

    public IBlockState getState() {
        return this.state;
    }

    public int getPass() {
        return MathUtil.clamp(this.layer - 1, 0, 1);
    }

    public boolean equals(Object other) {
        return other instanceof MBlock && ((MBlock)other).block == this.block && ((MBlock)other).meta == this.meta;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ResourceLocation name = this.block.getRegistryName();
        out.writeUTF(name.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.getRegistryName().hashCode());
        result = 31 * result + this.meta;
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String name = in.readUTF();
        this.block = Block.func_149684_b((String)name);
        if (this.block != null) {
            this.state = this.block.func_176203_a(this.meta);
        } else {
            MBlock replacement = replacementTable.get(new BlockMeta(name, this.meta));
            if (replacement != null) {
                this.block = replacement.block;
                this.state = replacement.getState();
            } else {
                this.block = Blocks.field_150347_e;
                this.state = Blocks.field_150347_e.func_176223_P();
            }
        }
    }

    public void tileEntityPostPlacementAction(World w, IBlockState state, BlockPos p, int rotation) {
    }

    public boolean hasTileEntity() {
        return this.hasTileEntity;
    }

    protected int getPlacementFlags() {
        return 2;
    }

    public void setBlock(World w, BlockPos.MutableBlockPos pos, int rotation) {
        this.setBlock(w, pos, rotation, null, WorldgenStructure.BiomeColorType.WOODLAND);
    }

    public void setBlock(World w, BlockPos.MutableBlockPos pos, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        if (pos.func_177956_o() >= 1) {
            IBlockState targetState = BlockRotator.getRotatedHorizontal(this.state, rotation);
            w.func_180501_a((BlockPos)pos, targetState, this.getPlacementFlags());
            if (this.hasTileEntity) {
                this.tileEntityPostPlacementAction(w, targetState, (BlockPos)pos, rotation);
            }
        }
    }

    public void setBlockReplaceableOnly(World w, BlockPos.MutableBlockPos pos, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        IBlockState bs = w.func_180495_p((BlockPos)pos);
        if (bs.func_177230_c().func_176200_f((IBlockAccess)w, (BlockPos)pos)) {
            this.setBlock(w, pos, rotation, loottype, biome);
        }
    }

    static {
        replacementTable.put(new BlockMeta("chisel:netherbrick", 13), new MBlock(Blocks.field_150385_bj, 0));
    }

    private static class BlockMeta {
        String blockname;
        int blockid;

        public BlockMeta(@Nonnull String blockname, int blockid) {
            this.blockname = blockname;
            this.blockid = blockid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.blockid;
            result = 31 * result + (this.blockname == null ? 0 : this.blockname.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockMeta) {
                BlockMeta other = (BlockMeta)obj;
                return this.blockid == other.blockid && this.blockname.equals(other.blockname);
            }
            return false;
        }
    }
}

