/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import techguns.capabilities.TGExtendedPlayer;

public enum EntityCondition {
    NONE(0),
    CHARGING_WEAPON(1),
    ENTITY_ALIVE(2);

    public byte id = 0;

    private EntityCondition(int id) {
        this.id = (byte)id;
    }

    public static EntityCondition fromByte(byte id) {
        for (EntityCondition e : EntityCondition.values()) {
            if (e.id != id) continue;
            return e;
        }
        return NONE;
    }

    public boolean evaluate(Entity entity) {
        switch (this) {
            case CHARGING_WEAPON: {
                if (entity instanceof EntityPlayer) {
                    TGExtendedPlayer txp = TGExtendedPlayer.get((EntityPlayer)entity);
                    return txp.isChargingWeapon();
                }
                return false;
            }
            case ENTITY_ALIVE: {
                return entity.func_70089_S();
            }
        }
        return true;
    }
}

