/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import techguns.items.guns.GenericGunMeleeCharge;
import techguns.util.MBlock;
import techguns.util.MathUtil;
import techguns.util.MultiMMBlockIndexRoll;
import techguns.world.EnumLootType;
import techguns.world.structures.WorldgenStructure;

public class BlockUtils {
    private static final String FILEPATH = "/assets/techguns/structures/";
    public static final float[][] FILTER_GAUSSIAN_3x3 = new float[][]{{0.0625f, 0.125f, 0.0625f}, {0.125f, 0.25f, 0.125f}, {0.0625f, 0.125f, 0.0625f}};
    public static final float[][] FILTER_GAUSSIAN_5x5 = new float[][]{{0.00325f, 0.01375f, 0.0235f, 0.01375f, 0.00325f}, {0.01375f, 0.059f, 0.097f, 0.059f, 0.01375f}, {0.0235f, 0.097f, 0.159f, 0.097f, 0.0235f}, {0.01375f, 0.059f, 0.097f, 0.059f, 0.01375f}, {0.00325f, 0.01375f, 0.0235f, 0.01375f, 0.00325f}};
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        @Nullable
        public String apply(@Nullable Map.Entry<IProperty<?>, Comparable<?>> p_apply_1_) {
            if (p_apply_1_ == null) {
                return "<NULL>";
            }
            IProperty<?> iproperty = p_apply_1_.getKey();
            return iproperty.func_177701_a() + "=" + this.getPropertyName(iproperty, p_apply_1_.getValue());
        }

        private <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
            return property.func_177702_a(entry);
        }
    };

    public static String getBlockStateVariantString(IBlockState state) {
        StringBuilder sb = new StringBuilder();
        COMMA_JOINER.appendTo(sb, Iterables.transform((Iterable)state.func_177228_b().entrySet(), MAP_ENTRY_TO_STRING));
        return sb.toString();
    }

    public static BlockPos rotateAroundY(BlockPos pos, BlockPos axis, int steps) {
        int offsetX = pos.func_177958_n() - axis.func_177958_n();
        int offsetZ = pos.func_177952_p() - axis.func_177952_p();
        int newOffsetX = offsetX;
        int newOffsetZ = offsetZ;
        for (int i = steps; i > 0; --i) {
            int tmp = newOffsetX;
            newOffsetX = newOffsetZ;
            newOffsetZ = -tmp;
        }
        return new BlockPos(axis.func_177958_n() + newOffsetX, pos.func_177956_o(), axis.func_177952_p() + newOffsetZ);
    }

    public static BlockPos rotateAroundY(BlockPos.MutableBlockPos pos, BlockPos axis, int steps) {
        int offsetX = pos.func_177958_n() - axis.func_177958_n();
        int offsetZ = pos.func_177952_p() - axis.func_177952_p();
        int newOffsetX = offsetX;
        int newOffsetZ = offsetZ;
        for (int i = steps; i > 0; --i) {
            int tmp = newOffsetX;
            newOffsetX = newOffsetZ;
            newOffsetZ = -tmp;
        }
        pos.func_181079_c(axis.func_177958_n() + newOffsetX, pos.func_177956_o(), axis.func_177952_p() + newOffsetZ);
        return pos;
    }

    public static BlockPos rotateAroundY(BlockPos pos, Vec3d axis, int steps) {
        Vec3d v_pos = new Vec3d((double)pos.func_177958_n() + 0.5, 0.0, (double)pos.func_177952_p() + 0.5);
        double offsetX = v_pos.field_72450_a - axis.field_72450_a;
        double offsetZ = v_pos.field_72449_c - axis.field_72449_c;
        double newOffsetX = offsetX;
        double newOffsetZ = offsetZ;
        for (int i = steps; i > 0; --i) {
            double tmp = newOffsetX;
            newOffsetX = newOffsetZ;
            newOffsetZ = -tmp;
        }
        return new BlockPos(axis.field_72450_a + newOffsetX, (double)pos.func_177956_o(), axis.field_72449_c + newOffsetZ);
    }

    public static BlockPos.MutableBlockPos rotateAroundY(BlockPos.MutableBlockPos pos, Vec3d axis, int steps) {
        Vec3d v_pos = new Vec3d((double)pos.func_177958_n() + 0.5, 0.0, (double)pos.func_177952_p() + 0.5);
        double offsetX = v_pos.field_72450_a - axis.field_72450_a;
        double offsetZ = v_pos.field_72449_c - axis.field_72449_c;
        double newOffsetX = offsetX;
        double newOffsetZ = offsetZ;
        for (int i = steps; i > 0; --i) {
            double tmp = newOffsetX;
            newOffsetX = newOffsetZ;
            newOffsetZ = -tmp;
        }
        pos.func_189532_c(axis.field_72450_a + newOffsetX, (double)pos.func_177956_o(), axis.field_72449_c + newOffsetZ);
        return pos;
    }

    protected static boolean checkMiningLevels(World world, EntityPlayer ply, BlockPos b, GenericGunMeleeCharge miningtool, ItemStack stack) {
        IBlockState state = world.func_180495_p(b);
        String tool = state.func_177230_c().getHarvestTool(state);
        if (state.func_177230_c().func_176209_a(state, false) && state.func_177230_c().canHarvestBlock((IBlockAccess)world, b, ply)) {
            if (tool == null) {
                return true;
            }
            return state.func_177230_c().getHarvestLevel(state) <= miningtool.getHarvestLevel(stack, tool, ply, state);
        }
        return false;
    }

    public static List<BlockPos> getBlockPlaneAroundAxisForMining(World world, EntityPlayer ply, BlockPos center, EnumFacing.Axis axis, int radius, boolean includeCenter, @Nullable GenericGunMeleeCharge miningtool, ItemStack stack) {
        Iterable blocks;
        ArrayList<BlockPos> entries = new ArrayList<BlockPos>();
        switch (axis) {
            case X: {
                blocks = BlockPos.func_177980_a((BlockPos)center.func_177982_a(0, -radius, -radius), (BlockPos)center.func_177982_a(0, radius, radius));
                break;
            }
            case Y: {
                blocks = BlockPos.func_177980_a((BlockPos)center.func_177982_a(-radius, 0, -radius), (BlockPos)center.func_177982_a(radius, 0, radius));
                break;
            }
            default: {
                blocks = BlockPos.func_177980_a((BlockPos)center.func_177982_a(-radius, -radius, 0), (BlockPos)center.func_177982_a(radius, radius, 0));
            }
        }
        blocks.forEach(b -> {
            if ((includeCenter || !b.equals((Object)center)) && world.func_175625_s(b) == null && (miningtool == null || stack.func_190926_b() || BlockUtils.checkMiningLevels(world, ply, b, miningtool, stack))) {
                entries.add((BlockPos)b);
            }
        });
        return entries;
    }

    public static int getHeightValueLiquid(World w, int wx, int wz) {
        Chunk chunk = w.func_72964_e(wx >> 4, wz >> 4);
        int x = wx;
        int z = wz;
        wx &= 0xF;
        int y = 0;
        IBlockState block = null;
        wz &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            block = chunk.func_186032_a(wx, k, wz);
            if (block.func_185904_a() == Material.field_151579_a) continue;
            y = k + 1;
            break;
        }
        if (block != null && !block.func_185904_a().func_76224_d()) {
            return -1;
        }
        return y;
    }

    public static int getValidSpawnYWater(World world, int x, int z, int sizeX, int sizeZ, int heightDiffLimit) {
        int h0 = BlockUtils.getHeightValueLiquid(world, x, z);
        int h1 = BlockUtils.getHeightValueLiquid(world, x + sizeX, z);
        int h2 = BlockUtils.getHeightValueLiquid(world, x, z + sizeZ);
        int h3 = BlockUtils.getHeightValueLiquid(world, x + sizeX, z + sizeZ);
        if (h0 < 0 || h1 < 0 || h2 < 0 || h3 < 0) {
            return -1;
        }
        if (MathUtil.abs(h0 - h1) >= heightDiffLimit || MathUtil.abs(h0 - h2) >= heightDiffLimit || MathUtil.abs(h0 - h3) >= heightDiffLimit) {
            return -1;
        }
        return BlockUtils.getMedianHeight(h0, h1, h2, h3);
    }

    private static int getMedianHeight(int h0, int h1, int h2, int h3) {
        int[] height = new int[]{h0, h1, h2, h3};
        Arrays.sort(height);
        return (height[1] + height[2]) / 2;
    }

    public static int getHeightValueNoTreesIgnoreLiquid(World w, int x, int z) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(x, 0, z);
        int y = w.func_175672_r((BlockPos)p).func_177956_o();
        IBlockState bs = w.func_180495_p((BlockPos)p.func_181079_c(x, y, z));
        Block b = bs.func_177230_c();
        if (bs.func_185904_a().func_76224_d()) {
            return -1;
        }
        while (y > 0 && (b.isLeaves(bs, (IBlockAccess)w, (BlockPos)p) || b.isFoliage((IBlockAccess)w, (BlockPos)p))) {
            bs = w.func_180495_p((BlockPos)p.func_181079_c(x, --y, z));
            b = bs.func_177230_c();
        }
        return y;
    }

    public static int getValidSpawnYArea(World world, int x, int z, int sizeX, int sizeZ, int heightDiffLimit, int step) {
        int count = 0;
        int min = 255;
        int max = 0;
        int sum = 0;
        int ix = 0;
        while (ix <= sizeX) {
            int iz = 0;
            while (iz <= sizeZ) {
                int h = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x + ix, z + iz);
                if (h < 0) {
                    return -1;
                }
                if (h < min) {
                    min = h;
                }
                if (h > max) {
                    max = h;
                }
                sum += h;
                ++count;
                if (iz <= sizeZ + step) {
                    iz += step;
                    continue;
                }
                if (iz >= sizeZ || iz + step <= sizeZ) continue;
                iz = sizeZ;
            }
            if (ix <= sizeX + step) {
                ix += step;
                continue;
            }
            if (ix >= sizeX || ix + step <= sizeX) continue;
            ix = sizeX;
        }
        if (max - min > heightDiffLimit) {
            return -1;
        }
        return sum / count;
    }

    public static int getValidSpawnY(World world, int x, int z, int sizeX, int sizeZ, int heightDiffLimit) {
        int h0 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x, z);
        int h1 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x + sizeX, z);
        int h2 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x, z + sizeZ);
        int h3 = BlockUtils.getHeightValueNoTreesIgnoreLiquid(world, x + sizeX, z + sizeZ);
        if (h0 < 0 || h1 < 0 || h2 < 0 || h3 < 0) {
            return -1;
        }
        if (MathUtil.abs(h0 - h1) >= heightDiffLimit || MathUtil.abs(h0 - h2) >= heightDiffLimit || MathUtil.abs(h0 - h3) >= heightDiffLimit) {
            return -1;
        }
        return BlockUtils.getMedianHeight(h0, h1, h2, h3);
    }

    public static int getHeightValueUnderwater(World w, int x, int z) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int y = w.func_175672_r((BlockPos)p.func_181079_c(x, 0, z)).func_177956_o();
        IBlockState bs = w.func_180495_p((BlockPos)p.func_181079_c(x, y, z));
        Block b = bs.func_177230_c();
        while (y > 0 && (b.isLeaves(bs, (IBlockAccess)w, (BlockPos)p) || b.isFoliage((IBlockAccess)w, (BlockPos)p) || bs.func_185904_a().func_76224_d())) {
            bs = w.func_180495_p((BlockPos)p.func_181079_c(x, --y, z));
            b = bs.func_177230_c();
        }
        return y;
    }

    public static int getHeightValueNoTrees(World w, int x, int z) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int y = BlockUtils.getTopSolidOrLiquidBlock(w, x, z);
        IBlockState bs = w.func_180495_p((BlockPos)p.func_181079_c(x, y, z));
        Block b = bs.func_177230_c();
        while (y > 0 && (b.isLeaves(bs, (IBlockAccess)w, (BlockPos)p) || b.isWood((IBlockAccess)w, (BlockPos)p) || b.isFoliage((IBlockAccess)w, (BlockPos)p))) {
            bs = w.func_180495_p((BlockPos)p.func_181079_c(x, --y, z));
            b = bs.func_177230_c();
        }
        return y;
    }

    public static int getHeightValueTopBlockAll(World w, int xCoord, int zCoord) {
        Chunk chunk = w.func_72964_e(xCoord >> 4, zCoord >> 4);
        int x = xCoord;
        int z = zCoord;
        xCoord &= 0xF;
        zCoord &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            IBlockState block = chunk.func_186032_a(xCoord, k, zCoord);
            if (block.func_185904_a() == Material.field_151579_a) continue;
            return k + 1;
        }
        return -1;
    }

    private static int getTopSolidOrLiquidBlock(World w, int posx, int posz) {
        Chunk chunk = w.func_72964_e(posx >> 4, posz >> 4);
        int x = posx;
        int z = posz;
        posx &= 0xF;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        posz &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            IBlockState block = chunk.func_186032_a(posx, k, posz);
            Block b = block.func_177230_c();
            if ((!block.func_185904_a().func_76230_c() || block.func_185904_a() == Material.field_151584_j || b.isFoliage((IBlockAccess)w, (BlockPos)p.func_181079_c(x, k, z))) && !block.func_185904_a().func_76224_d()) continue;
            return k + 1;
        }
        return -1;
    }

    public static void removeJunkInArea(World world, int posX, int posZ, int sizeX, int sizeZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                boolean stop = false;
                for (int y = BlockUtils.getHeightValueTopBlockAll(world, posX + x, posZ + z); y > 0 && !stop; --y) {
                    IBlockState bs = world.func_180495_p((BlockPos)pos.func_181079_c(posX + x, y, posZ + z));
                    if (!BlockUtils.isGroundBlock(bs)) {
                        world.func_175698_g((BlockPos)pos);
                        continue;
                    }
                    stop = true;
                }
            }
        }
    }

    public static void fillBlocks(World world, BlockPos.MutableBlockPos start, int sizeX, int sizeY, int sizeZ, IBlockState block) {
        int x = start.func_177958_n();
        int y = start.func_177956_o();
        int z = start.func_177952_p();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    world.func_175656_a((BlockPos)start.func_181079_c(x + i, y + k, z + j), block);
                }
            }
        }
    }

    public static void fillBlocksHollow(World world, BlockPos.MutableBlockPos start, int sizeX, int sizeY, int sizeZ, IBlockState block) {
        int x = start.func_177958_n();
        int y = start.func_177956_o();
        int z = start.func_177952_p();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    if (j != 0 && j != sizeZ - 1 && i != 0 && i != sizeX - 1) continue;
                    world.func_175656_a((BlockPos)start.func_181079_c(x + i, y + k, z + j), block);
                }
            }
        }
    }

    public static WorldgenStructure.BiomeColorType getBiomeType(World world, int posX, int posZ) {
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(posX, 0, posZ));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return WorldgenStructure.BiomeColorType.DESERT;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return WorldgenStructure.BiomeColorType.SNOW;
        }
        return WorldgenStructure.BiomeColorType.WOODLAND;
    }

    private static boolean isGroundBlock(IBlockState b) {
        Material mat = b.func_185904_a();
        return mat == Material.field_151578_c || mat == Material.field_151577_b || mat == Material.field_151576_e || mat == Material.field_151595_p || mat == Material.field_151571_B;
    }

    public static int getValidSpawnYUnderwater(World world, int x, int z, int sizeX, int sizeZ, int heightDiffLimit) {
        int h0 = BlockUtils.getHeightValueUnderwater(world, x, z);
        int h1 = BlockUtils.getHeightValueUnderwater(world, x + sizeX, z);
        int h2 = BlockUtils.getHeightValueUnderwater(world, x, z + sizeZ);
        int h3 = BlockUtils.getHeightValueUnderwater(world, x + sizeX, z + sizeZ);
        if (h0 < 0 || h1 < 0 || h2 < 0 || h3 < 0) {
            return -1;
        }
        if (MathUtil.abs(h0 - h1) >= heightDiffLimit || MathUtil.abs(h0 - h2) >= heightDiffLimit || MathUtil.abs(h0 - h3) >= heightDiffLimit) {
            return -1;
        }
        return BlockUtils.getMedianHeight(h0, h1, h2, h3);
    }

    public static void flattenArea(World world, int posX, int posZ, int sizeX, int sizeZ, int maxHeightDiff) {
        int heightSum = 0;
        int count = sizeX * sizeZ;
        int min = -1;
        int max = 0;
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                heights.add(new Integer(y));
                heightSum += y;
                if (y > max) {
                    max = y;
                }
                if (y >= min && min != -1) continue;
                min = y;
            }
        }
        int span = max - min;
        float median = 0.0f;
        Collections.sort(heights);
        if (heights.size() > 2) {
            median = heights.size() % 2 == 0 ? (float)(((Integer)heights.get((int)Math.floor(heights.size() / 2) - 1) + (Integer)heights.get((int)Math.ceil(heights.size() / 2) - 1)) / 2) : (float)((Integer)heights.get(heights.size() / 2 - 1)).intValue();
        }
        float averageHeight = median;
        float f = averageHeight - (float)maxHeightDiff / 2.0f;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                int newY = span <= maxHeightDiff ? y : Math.round((float)(y - min) / (float)span * (float)maxHeightDiff + f);
                BlockUtils.adjustHeightAtPos(world, posX + x, posZ + z, y, p, newY);
            }
        }
    }

    private static void adjustHeightAtPos(World world, int x, int z, int y, BlockPos.MutableBlockPos p, int newY) {
        block4: {
            block3: {
                if (newY <= y) break block3;
                IBlockState b = world.func_180495_p((BlockPos)p.func_181079_c(x, y, z));
                if (!BlockUtils.isGroundBlock(b)) {
                    b = Blocks.field_150346_d.func_176223_P();
                }
                for (int i = y + 1; i <= newY; ++i) {
                    world.func_180501_a((BlockPos)p.func_181079_c(x, i, z), b, 2);
                }
                break block4;
            }
            if (newY >= y) break block4;
            for (int i = y; i > newY; --i) {
                world.func_175698_g((BlockPos)p.func_181079_c(x, i, z));
            }
        }
    }

    public static void apply2DHeightmapFilter(World world, int posX, int posZ, int sizeX, int sizeZ, float[][] filter) {
        int xoffset = -filter.length / 2;
        int zoffset = -filter[0].length / 2;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                int y = BlockUtils.getHeightValueNoTrees(world, posX + x, posZ + z) - 1;
                float newY = 0.0f;
                for (int i = 0; i < filter.length; ++i) {
                    for (int j = 0; j < filter[i].length; ++j) {
                        newY += ((float)BlockUtils.getHeightValueNoTrees(world, posX + x + xoffset + i, posZ + z + zoffset + j) - 1.0f) * filter[i][j];
                    }
                }
                BlockUtils.adjustHeightAtPos(world, posX + x, posZ + z, y, p, Math.round(newY));
            }
        }
    }

    public static short[][] loadStructureFromFile(String filename) {
        try {
            String line;
            String path = FILEPATH + filename;
            BufferedReader br = new BufferedReader(new InputStreamReader(WorldgenStructure.class.getResourceAsStream(path)));
            int count = Integer.parseInt(br.readLine());
            short[][] blocks = new short[count][4];
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] s = line.split(",");
                for (int j = 0; j < s.length; ++j) {
                    blocks[i][j] = Short.parseShort(s[j]);
                }
                ++i;
            }
            return blocks;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new short[0][0];
        }
    }

    public static void cleanUpwards(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, int range) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockPos axis = new BlockPos(posX + centerX, 1, posZ + centerZ);
        for (int i = 0; i < blocks.length; ++i) {
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            if (y != 0) continue;
            MBlock block = new MBlock(Blocks.field_150350_a.func_176223_P());
            for (int o = 1; o <= range; ++o) {
                BlockUtils.setMBlockRotated(world, block, p.func_181079_c(posX + x, posY + y + o, posZ + z), axis, rotation, null, WorldgenStructure.BiomeColorType.WOODLAND);
            }
        }
    }

    public static void placeScannedStructure(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, rotation, pass, loottype, biome, 0, null);
    }

    public static void placeScannedStructure(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, EnumLootType loottype, WorldgenStructure.BiomeColorType biome, int indexRoll, Random rnd) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockPos axis = new BlockPos(posX + centerX, 1, posZ + centerZ);
        for (int i = 0; i < blocks.length; ++i) {
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            MBlock block = blockList.get(blocks[i][3]);
            if (block.getPass() != pass) continue;
            if (block instanceof MultiMMBlockIndexRoll) {
                BlockUtils.setMBlockRotatedIndexRoll(world, (MultiMMBlockIndexRoll)block, p.func_181079_c(posX + x, posY + y, posZ + z), axis, rotation, loottype, biome, indexRoll, rnd);
                continue;
            }
            BlockUtils.setMBlockRotated(world, block, p.func_181079_c(posX + x, posY + y, posZ + z), axis, rotation, loottype, biome);
        }
    }

    public static void placeFoundation(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, int range) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockPos axis = new BlockPos(posX + centerX, 1, posZ + centerZ);
        for (int i = 0; i < blocks.length; ++i) {
            MBlock block;
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            if (y != 0 || (block = blockList.get(blocks[i][3])).getPass() != pass) continue;
            for (int o = 1; o <= range; ++o) {
                BlockUtils.setMBlockRotatedReplaceableOnly(world, block, p.func_181079_c(posX + x, posY + y - o, posZ + z), axis, rotation, null);
            }
        }
    }

    public static void placeFoundationNether(World world, short[][] blocks, ArrayList<MBlock> blockList, int posX, int posY, int posZ, int centerX, int centerZ, int rotation, int pass, int range) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockPos axis = new BlockPos(posX + centerX, 1, posZ + centerZ);
        block0: for (int i = 0; i < blocks.length; ++i) {
            MBlock block;
            short x = blocks[i][0];
            short y = blocks[i][1];
            short z = blocks[i][2];
            if (y != 0 || (block = blockList.get(blocks[i][3])).getPass() != pass) continue;
            int solidcount = 0;
            for (int o = 1; o <= range; ++o) {
                p.func_181079_c(posX + x, posY + y - o, posZ + z);
                if (BlockUtils.getIsBlockReplaceable(world, new BlockPos.MutableBlockPos((BlockPos)p), axis, rotation)) {
                    BlockUtils.setMBlockRotatedReplaceableOnly(world, block, p.func_181079_c(posX + x, posY + y - o, posZ + z), axis, rotation, null);
                    solidcount = 0;
                    continue;
                }
                if (++solidcount >= 2) continue block0;
            }
        }
    }

    public static void setMBlockRotated(World w, MBlock mblock, BlockPos.MutableBlockPos pos, BlockPos axis, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        BlockUtils.rotateAroundY(pos, axis, rotation);
        mblock.setBlock(w, pos, rotation, loottype, biome);
    }

    public static void setMBlockRotatedIndexRoll(World w, MultiMMBlockIndexRoll mblock, BlockPos.MutableBlockPos pos, BlockPos axis, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome, int indexRoll, Random rnd) {
        BlockUtils.rotateAroundY(pos, axis, rotation);
        mblock.setBlock(w, pos, rotation, loottype, biome, indexRoll, rnd);
    }

    public static void setMBlockRotatedReplaceableOnly(World w, MBlock mblock, BlockPos.MutableBlockPos pos, BlockPos axis, int rotation, EnumLootType loottype) {
        BlockUtils.rotateAroundY(pos, axis, rotation);
        mblock.setBlockReplaceableOnly(w, pos, rotation, loottype, WorldgenStructure.BiomeColorType.WOODLAND);
    }

    public static boolean getIsBlockReplaceable(World w, BlockPos.MutableBlockPos pos, BlockPos axis, int rotation) {
        BlockUtils.rotateAroundY(pos, axis, rotation);
        return w.func_180495_p((BlockPos)pos).func_177230_c().func_176200_f((IBlockAccess)w, (BlockPos)pos);
    }

    public static void fillSphere2(World world, int posX, int posY, int posZ, float radius, MBlock block1, MBlock block2) {
        BlockUtils.fillSphere2(world, posX, posY, posZ, radius, 1.0f, block1, block2);
    }

    public static void fillSphere2(World world, int posX, int posY, int posZ, float radius, float thickness, MBlock block1, MBlock block2) {
        Vec3d center = new Vec3d((double)posX, (double)posY, (double)posZ);
        float rsquared = (float)Math.pow(radius, 2.0);
        float rsquared2 = (float)Math.pow(radius - thickness, 2.0);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int r = (int)radius;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int x = posX + i;
                    int y = posY + j;
                    int z = posZ + k;
                    Vec3d v = new Vec3d((double)x, (double)y, (double)z);
                    float dsquared = (float)center.func_72436_e(v);
                    if (dsquared < rsquared2) {
                        block1.setBlock(world, p.func_181079_c(x, y, z), 0);
                        continue;
                    }
                    if (!(dsquared < rsquared)) continue;
                    block2.setBlock(world, p.func_181079_c(x, y, z), 0);
                }
            }
        }
    }

    public static void fillCylinder(World world, int x1, int y1, int z1, int x2, int y2, int z2, float radius, MBlock block1, MBlock block2) {
        Vec3d v1 = new Vec3d((double)x1, (double)y1, (double)z1);
        Vec3d v2 = new Vec3d((double)x2, (double)y2, (double)z2);
        Vec3d v2v1 = v1.func_178788_d(v2);
        double l = v2v1.func_72433_c();
        int tmp = 0;
        if (x1 > x2) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y1 > y2) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        if (z1 > z2) {
            tmp = z2;
            z2 = z1;
            z1 = tmp;
        }
        int r = (int)radius;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = x1 - r; x < x2 + r; ++x) {
            for (int y = y1 - r; y < y2 + r; ++y) {
                for (int z = z1 - r; z < z2 + r; ++z) {
                    Vec3d v0 = new Vec3d((double)x, (double)y, (double)z);
                    Vec3d v1v0 = v1.func_178788_d(v0);
                    Vec3d v_ = v2v1.func_72431_c(v1v0);
                    double distance = v_.func_72433_c() / l;
                    if (distance < (double)(radius - 1.0f)) {
                        block1.setBlock(world, p.func_181079_c(x, y, z), 0);
                        continue;
                    }
                    if (!(distance < (double)radius)) continue;
                    block2.setBlock(world, p.func_181079_c(x, y, z), 0);
                }
            }
        }
    }

    public static void drawLine(World world, int x1, int y1, int z1, int x2, int y2, int z2, MBlock block) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int signx = (int)Math.signum(dx);
        int signy = (int)Math.signum(dy);
        int signz = (int)Math.signum(dz);
        int x = x1;
        int y = y1;
        int z = z1;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (true) {
                block.setBlock(world, p.func_181079_c(x, y, z), 0);
                if (x == x2) {
                    return;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (true) {
                block.setBlock(world, p.func_181079_c(x, y, z), 0);
                if (y == y2) {
                    return;
                }
                if (deltax >= 0) {
                    block.setBlock(world, p.func_181079_c(x + signx, y, z), 0);
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    block.setBlock(world, p.func_181079_c(x, y, z + signz), 0);
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (true) {
                block.setBlock(world, p.func_181079_c(x, y, z), 0);
                if (z == z2) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
    }

    public static void fillSphere(World world, int posX, int posY, int posZ, float radius, MBlock block) {
        Vec3d center = new Vec3d((double)posX, (double)posY, (double)posZ);
        float rsquared = (float)Math.pow(radius, 2.0);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int r = (int)radius;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int x = posX + i;
                    int y = posY + j;
                    int z = posZ + k;
                    Vec3d v = new Vec3d((double)x, (double)y, (double)z);
                    float dsquared = (float)center.func_72436_e(v);
                    if (!(dsquared < rsquared)) continue;
                    block.setBlock(world, p.func_181079_c(x, y, z), 0);
                }
            }
        }
    }

    protected static int getAirHeight(World w, int x, int z, int minH, int maxH, int airH) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(x, minH, z);
        int countAir = 0;
        for (int y = maxH; y > minH; --y) {
            p.func_185336_p(y);
            IBlockState bs = w.func_180495_p((BlockPos)p);
            if (bs == Blocks.field_150350_a.func_176223_P()) {
                ++countAir;
                continue;
            }
            if (countAir >= airH) {
                return y;
            }
            countAir = 0;
        }
        return -1;
    }

    public static int getCaveHeight(World w, int cx, int cz, int heightDiff, int minY, int maxY) {
        int h1 = BlockUtils.getAirHeight(w, cx * 16, cz * 16, minY, maxY, heightDiff);
        int h2 = BlockUtils.getAirHeight(w, cx * 16 + 15, cz * 16, minY, maxY, heightDiff);
        int h3 = BlockUtils.getAirHeight(w, cx * 16, cz * 16 + 15, minY, maxY, heightDiff);
        int h4 = BlockUtils.getAirHeight(w, cx * 16 + 15, cz * 16 + 15, minY, maxY, heightDiff);
        if (MathUtil.allInRange(minY, maxY, h1, h2, h3, h4)) {
            int min = MathUtil.min(h1, h2, h3, h4);
            int max = MathUtil.max(h1, h2, h3, h4);
            if (max - min <= heightDiff) {
                return MathUtil.getAverageHeight(h1, h2, h3, h4);
            }
        }
        return -1;
    }

    public static int getGroundY(World world, int x, int z) {
        return world.func_189649_b(x, z) - 1;
    }

    public static void fillBlocksAir(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    world.func_180501_a((BlockPos)p.func_181079_c(x + i, y + k, z + j), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    public static EnumFacing rotationToFacing(int rot) {
        switch (rot) {
            case 0: {
                return EnumFacing.WEST;
            }
            case 1: {
                return EnumFacing.NORTH;
            }
            case 2: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.SOUTH;
    }
}

