/*
 * Decompiled with CFR 0.152.
 */
package techguns.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import techguns.items.GenericItemShared;
import techguns.items.guns.GenericGun;
import techguns.util.TGLogger;

public class ItemJsonCreator {
    private static final String prefix = "../src/main/resources/assets/techguns/";
    private static final String texpath = "items/";

    public static void writeItemJsonFileForPath(String path, String name, String texname) {
        File f = new File(prefix + path + name + ".json");
        if (!f.exists()) {
            TGLogger.logger_client.log(Level.INFO, "Creating Item JSON:" + f.getAbsolutePath());
            try {
                FileWriter writer = new FileWriter(f);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonObject parent = new JsonObject();
                parent.addProperty("parent", "item/generated");
                JsonObject model = new JsonObject();
                model.addProperty("layer0", "techguns:items/" + texname);
                parent.add("textures", (JsonElement)model);
                writer.write(gson.toJson((JsonElement)parent));
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeJsonFilesForGun(GenericGun item) {
        String path = "models/item/";
        if (item.isModelBase(new ItemStack((Item)item))) {
            ItemJsonCreator.writeItemJsonFileForPath(path, item.getRegistryName().func_110623_a(), "dummy");
        }
    }

    public static void writeJsonFilesForSharedItem(GenericItemShared item) {
        String path = "models/item/";
        for (GenericItemShared.SharedItemEntry s : item.getSharedItems()) {
            ItemJsonCreator.writeItemJsonFileForPath(path, s.getName(), s.getName());
        }
    }

    public static void writeJsonFilesForGenericItem(Item item) {
        String path = "models/item/";
        ItemJsonCreator.writeItemJsonFileForPath(path, item.getRegistryName().func_110623_a(), item.getRegistryName().func_110623_a());
    }
}

