/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import techguns.TGRadiationSystem;
import techguns.tileentities.ReactionChamberTileEntMaster;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.ReactionBeamFocus;
import techguns.tileentities.operation.ReactionChamberRecipe;

public class ReactionChamberOperation
extends MachineOperation {
    public static final byte RECIPE_TICKRATE = 60;
    protected ReactionChamberRecipe recipe;
    public byte completion;
    public byte required_intensity;
    public byte nextTick;
    Random rnd;

    public ReactionChamberOperation(NBTTagCompound tags, ReactionChamberTileEntMaster tile) {
        super(new ArrayList<ItemStack>(), new ArrayList<ItemStack>(), null, null, 1);
        this.readFromNBT(tags);
        this.rnd = new Random();
    }

    public ReactionChamberOperation(ReactionChamberRecipe r, ReactionChamberTileEntMaster tile) {
        super(new ArrayList<ItemStack>(), new ArrayList<ItemStack>(), null, null, 1);
        ItemStack input = tile.input.get().func_77946_l();
        input.func_190920_e(1);
        this.inputs.add(input);
        this.outputs.addAll(r.outputs);
        if (r.liquidConsumtion > 0) {
            this.fluid_inputs = new ArrayList();
            this.fluid_inputs.add(new FluidStack(r.liquidIn, r.liquidConsumtion));
        }
        this.recipe = r;
        this.completion = 0;
        this.nextTick = (byte)60;
        this.required_intensity = r.preferredIntensity;
        this.rnd = new Random();
    }

    @Override
    protected void writeSubclassDataToNBT(NBTTagCompound tags) {
        super.writeSubclassDataToNBT(tags);
        if (this.recipe != null) {
            tags.func_74778_a("ReactionID", this.recipe.ID);
        }
        tags.func_74774_a("completion", this.completion);
        tags.func_74774_a("required_intensity", this.required_intensity);
        tags.func_74774_a("nextTick", this.nextTick);
    }

    @Override
    protected void readSubClassDataFromNBT(NBTTagCompound tags) {
        super.readSubClassDataFromNBT(tags);
        String recID = tags.func_74779_i("ReactionID");
        this.recipe = ReactionChamberRecipe.getByKey(recID);
        if (this.recipe == null) {
            System.out.println("WARNING: RECIPE UNKNOWN:" + recID);
        }
        this.completion = tags.func_74771_c("completion");
        this.required_intensity = tags.func_74771_c("required_intensity");
        this.nextTick = tags.func_74771_c("nextTick");
    }

    public ReactionChamberRecipe getRecipe() {
        return this.recipe;
    }

    public boolean focusMatches(ItemStack item) {
        return this.recipe.beamFocus == ReactionBeamFocus.getBeamFocus(item);
    }

    public boolean tick(byte intensity, byte liquidLevel, boolean client, ReactionChamberTileEntMaster tile, int RFTick) {
        int progress = tile.progress;
        int totalTime = tile.totaltime;
        this.nextTick = (byte)(this.nextTick - 1);
        if (!client && this.nextTick == 0 && progress < totalTime) {
            boolean powered = tile.consumePower(RFTick);
            boolean focusMatch = this.focusMatches(tile.getInventory().getStackInSlot(1));
            if (powered && focusMatch && this.required_intensity == intensity && this.recipe.liquidLevel == liquidLevel) {
                this.completion = (byte)(this.completion + 1);
                this.doRadiation(tile, true);
            } else {
                this.doRadiation(tile, false);
            }
            if (!focusMatch) {
                tile.progress = tile.totaltime;
                this.completion = 0;
            } else if (this.recipe.instability > 0.0f && this.rnd.nextFloat() < this.recipe.instability) {
                int val = 1;
                if (this.recipe.intensityMargin > 1) {
                    val += this.rnd.nextInt(this.recipe.intensityMargin);
                }
                if (this.rnd.nextBoolean()) {
                    this.required_intensity = (byte)(this.required_intensity - val);
                    if (this.required_intensity < 0) {
                        this.required_intensity = 0;
                    }
                } else {
                    this.required_intensity = (byte)(this.required_intensity + val);
                    if (this.required_intensity > 10) {
                        this.required_intensity = (byte)10;
                    }
                }
            }
            this.nextTick = (byte)60;
            return true;
        }
        return this.isFinished(tile);
    }

    public void doRadiation(ReactionChamberTileEntMaster tile, boolean success) {
        ReactionBeamFocus focus;
        if (!tile.func_145831_w().field_72995_K && TGRadiationSystem.isEnabled() && (focus = ReactionBeamFocus.getBeamFocus(tile.getInventory().getStackInSlot(1))) != null) {
            int rad = 0;
            rad = success ? (int)Math.ceil(focus.radiationFactor_success * (float)tile.getIntensity()) : (int)Math.ceil(focus.radiationFactor_failure * (float)tile.getIntensity());
            if (rad > 0) {
                TGRadiationSystem.applyRadToEntities(tile, focus.rad_radius_outer, 62, rad - 1, focus.rad_radius_inner, 0);
            }
        }
    }

    public boolean isFinished(ReactionChamberTileEntMaster master) {
        return master.progress >= master.totaltime || this.completion >= this.getRecipe().requiredCompletion;
    }

    public boolean isSuccess() {
        return this.completion >= this.getRecipe().requiredCompletion;
    }

    public boolean isFailure(ReactionChamberTileEntMaster master) {
        return master.progress >= master.totaltime;
    }

    public int getCurrentPreferedIntensity() {
        return this.required_intensity;
    }
}

