/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import techguns.tileentities.operation.MachineOperation;

public class MachineOperationChance
extends MachineOperation {
    protected TileEntity tile;
    protected double[] itemChances;
    protected ArrayList<ItemStack> rolled_outputs;

    public MachineOperationChance(ArrayList<ItemStack> inputs, ArrayList<ItemStack> outputs, ArrayList<FluidStack> fluid_inputs, ArrayList<FluidStack> fluid_outputs, int stackMultiplier, double[] itemChances) {
        super(inputs, outputs, fluid_inputs, fluid_outputs, stackMultiplier);
        this.itemChances = itemChances;
        this.rolled_outputs = new ArrayList(outputs.size());
        outputs.forEach(o -> this.rolled_outputs.add(o.func_77946_l()));
    }

    public void setTile(TileEntity e) {
        this.tile = e;
    }

    protected void updateChanceRolls() {
        for (int i = 0; i < this.itemChances.length; ++i) {
            double amount = (double)((ItemStack)this.outputs.get(i)).func_190916_E() * this.itemChances[i] * (double)this.stackMultiplier;
            int fixed = 0;
            while (amount > 1.0) {
                amount -= 1.0;
                ++fixed;
            }
            if (this.tile.func_145831_w().field_73012_v.nextDouble() <= amount) {
                ++fixed;
            }
            this.rolled_outputs.get(i).func_190920_e(fixed);
        }
    }

    @Override
    public MachineOperation setStackMultiplier(int mult) {
        super.setStackMultiplier(mult);
        this.updateChanceRolls();
        return this;
    }

    @Override
    public ArrayList<ItemStack> getOutputs() {
        return this.rolled_outputs;
    }

    @Override
    public ArrayList<ItemStack> getOutputsWithMult() {
        return this.rolled_outputs;
    }
}

