/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerPlus
extends ItemStackHandler {
    public ItemStackHandlerPlus() {
    }

    public ItemStackHandlerPlus(int size) {
        super(size);
    }

    public ItemStackHandlerPlus(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.allowItemInSlot(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack insertItemNoCheck(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    public boolean canInsertAll(int startSlot, int endSlot, List<ItemStack> stacks) {
        if (endSlot < startSlot) {
            return false;
        }
        ItemStackHandlerPlus temp = new ItemStackHandlerPlus(endSlot - startSlot);
        for (int i = 0; i < endSlot - startSlot; ++i) {
            temp.setStackInSlot(i, this.getStackInSlot(i + startSlot).func_77946_l());
        }
        ArrayList<ItemStack> leftover = new ArrayList<ItemStack>(stacks.size());
        stacks.forEach(s -> leftover.add(s.func_77946_l()));
        for (int j = 0; j < leftover.size(); ++j) {
            int i;
            for (i = startSlot; i < endSlot; ++i) {
                if (temp.getStackInSlot(i - startSlot).func_190926_b()) continue;
                leftover.set(j, temp.insertItemNoCheck(i - startSlot, (ItemStack)leftover.get(j), false));
            }
            for (i = startSlot; i < endSlot; ++i) {
                if (!temp.getStackInSlot(i - startSlot).func_190926_b()) continue;
                leftover.set(j, temp.insertItemNoCheck(i - startSlot, (ItemStack)leftover.get(j), false));
            }
            if (((ItemStack)leftover.get(j)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> mergeAll(int startSlot, int endSlot, List<ItemStack> stacks) {
        if (endSlot < startSlot) {
            return stacks;
        }
        ArrayList<ItemStack> leftover = new ArrayList<ItemStack>(stacks.size());
        stacks.forEach(s -> leftover.add(s.func_77946_l()));
        for (int j = 0; j < leftover.size(); ++j) {
            int i;
            for (i = startSlot; i < endSlot; ++i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                leftover.set(j, this.insertItemNoCheck(i, leftover.get(j), false));
            }
            for (i = startSlot; i < endSlot; ++i) {
                if (!this.getStackInSlot(i).func_190926_b()) continue;
                leftover.set(j, this.insertItemNoCheck(i, leftover.get(j), false));
            }
        }
        return leftover;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowExtractFromSlot(slot, amount)) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    protected boolean allowItemInSlot(int slot, ItemStack stack) {
        return true;
    }

    protected boolean allowExtractFromSlot(int slot, int amount) {
        return true;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(this.getSlots());
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new ItemStack(itemTags));
        }
        this.onLoad();
    }

    public ItemStack extractWithoutCheck(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }
}

