/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import techguns.capabilities.TGSpawnerNPCData;
import techguns.entities.npcs.ITGSpawnerNPC;
import techguns.tileentities.BasicTGTileEntity;

public class TGSpawnerTileEnt
extends BasicTGTileEntity
implements ITickable {
    protected Random rand = new Random();
    protected int delay = 200;
    protected int spawndelay = 200;
    protected int mobsLeft = 5;
    protected int maxActive = 3;
    protected int spawnHeightOffset = 0;
    protected double spawnrange = 2.0;
    protected ArrayList<WeightedSpawnerEntity> mobtypes = new ArrayList();
    protected LinkedList<ITGSpawnerNPC> activeMobs = new LinkedList();
    protected ItemStack weaponOverride = ItemStack.field_190927_a;

    public TGSpawnerTileEnt() {
        super(false);
    }

    public <T extends EntityLiving> void addMobType(Class<T> clazz, int weight) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", EntityRegistry.getEntry(clazz).getRegistryName().toString());
        WeightedSpawnerEntity ent = new WeightedSpawnerEntity(weight, nbt);
        this.mobtypes.add(ent);
    }

    public void despawnedEntity(ITGSpawnerNPC ent) {
        this.activeMobs.remove(ent);
    }

    public void killedEntity(ITGSpawnerNPC ent) {
        if (this.activeMobs.remove(ent)) {
            --this.mobsLeft;
            this.func_70296_d();
        }
    }

    public void relinkNPC(ITGSpawnerNPC ent) {
        if (!this.activeMobs.contains(ent)) {
            this.activeMobs.add(ent);
        }
    }

    @Override
    public boolean canBeWrenchRotated() {
        return false;
    }

    @Override
    public boolean canBeWrenchDismantled() {
        return false;
    }

    public void setParams(int mobsleft, int maxactive, int spawndelay, int spawnrange) {
        this.mobsLeft = mobsleft;
        this.maxActive = maxactive;
        this.spawndelay = spawndelay;
        this.delay = spawndelay;
        this.spawnrange = spawnrange;
    }

    public TGSpawnerTileEnt setWeaponOverride(ItemStack weapon) {
        this.weaponOverride = weapon;
        return this;
    }

    public void setSpawnHeightOffset(int offset) {
        this.spawnHeightOffset = offset;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("mobsLeft", (byte)this.mobsLeft);
        compound.func_74777_a("delay", (short)this.delay);
        compound.func_74774_a("maxActive", (byte)this.maxActive);
        compound.func_74777_a("spawnDelay", (short)this.spawndelay);
        compound.func_74774_a("spawnRange", (byte)this.spawnrange);
        compound.func_74777_a("spawnHeightOffset", (short)this.spawnHeightOffset);
        NBTTagList nbttaglist = new NBTTagList();
        for (WeightedSpawnerEntity type : this.mobtypes) {
            nbttaglist.func_74742_a((NBTBase)type.func_185278_a());
        }
        compound.func_74782_a("mobtypes", (NBTBase)nbttaglist);
        if (!this.weaponOverride.func_190926_b()) {
            NBTTagCompound weapon = this.weaponOverride.func_77955_b(new NBTTagCompound());
            compound.func_74782_a("weapon", (NBTBase)weapon);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.mobsLeft = compound.func_74771_c("mobsLeft");
        this.delay = compound.func_74765_d("delay");
        this.spawndelay = compound.func_74765_d("spawnDelay");
        if (this.spawndelay < 1) {
            this.spawndelay = 200;
        }
        this.maxActive = compound.func_74765_d("maxActive");
        if (this.maxActive < 1) {
            this.maxActive = 1;
        }
        this.spawnrange = compound.func_74771_c("spawnRange");
        this.spawnHeightOffset = compound.func_74765_d("spawnHeightOffset");
        if (compound.func_150297_b("mobtypes", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("mobtypes", 10);
            this.mobtypes.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.mobtypes.add(new WeightedSpawnerEntity(nbttaglist.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("weapon", 10)) {
            NBTTagCompound weapon = compound.func_74775_l("weapon");
            this.weaponOverride = new ItemStack(weapon);
        }
        super.func_145839_a(compound);
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
    }

    protected boolean hasMobTypes() {
        return this.mobtypes.size() > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.delay;
        if (this.delay <= 0 && this.activeMobs.size() < Math.min(this.maxActive, this.mobsLeft) && this.hasMobTypes()) {
            if (this.field_145850_b.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                WeightedSpawnerEntity entdata = (WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.rand, this.mobtypes);
                BlockPos blockpos = this.func_174877_v();
                double d0 = (double)blockpos.func_177958_n() + (this.rand.nextDouble() - this.rand.nextDouble()) * this.spawnrange + 0.5;
                double d1 = blockpos.func_177956_o() + 1 + this.spawnHeightOffset;
                double d2 = (double)blockpos.func_177952_p() + (this.rand.nextDouble() - this.rand.nextDouble()) * this.spawnrange + 0.5;
                Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)entdata.func_185277_b(), (World)this.field_145850_b, (double)d0, (double)d1, (double)d2, (boolean)false);
                if (entity != null && entity instanceof ITGSpawnerNPC && entity instanceof EntityLiving) {
                    ITGSpawnerNPC npc = (ITGSpawnerNPC)entity;
                    EntityLiving elb = (EntityLiving)entity;
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)elb, (World)this.field_145850_b, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), null)) {
                        elb.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                        if (elb instanceof EntityCreature) {
                            ((EntityCreature)elb).func_175449_a(blockpos, 10);
                        }
                        AnvilChunkLoader.func_186052_a((Entity)entity, (World)this.field_145850_b);
                        this.field_145850_b.func_175718_b(2004, blockpos, 0);
                        if (!this.weaponOverride.func_190926_b() && elb instanceof EntityLiving) {
                            elb.func_184201_a(EntityEquipmentSlot.MAINHAND, this.weaponOverride.func_77946_l());
                        }
                        elb.func_70656_aK();
                        this.activeMobs.add(npc);
                        this.delay = this.spawndelay;
                        TGSpawnerNPCData dat = TGSpawnerNPCData.get(npc);
                        dat.setSpawnerPos(blockpos);
                    }
                } else {
                    this.delay = this.spawndelay;
                }
            } else {
                this.delay = this.spawndelay;
            }
        } else if (this.delay <= 0) {
            this.delay = this.spawndelay;
            Iterator it = this.activeMobs.iterator();
            while (it.hasNext()) {
                ITGSpawnerNPC npc = (ITGSpawnerNPC)it.next();
                if (npc instanceof EntityLivingBase) {
                    EntityLivingBase ent = (EntityLivingBase)npc;
                    if (ent.func_70089_S() && ent.field_70170_p.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension()) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
        }
        if (this.mobsLeft <= 0 && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }
}

