/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.TGBlocks;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.blocks.machines.BasicMachine;
import techguns.items.guns.GenericGun;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.GrinderRecipes;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineOperationChance;
import techguns.tileentities.operation.MachineSlotItem;

public class GrinderTileEnt
extends BasicMachineTileEnt {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_UPGRADE = 1;
    public static final int SLOT_OUTPUT0 = 2;
    public static final int SLOT_OUTPUT_LAST = 11;
    public MachineSlotItem input = new MachineSlotItem(this, 0);
    public static final int POWER_PER_TICK = 5;

    public GrinderTileEnt() {
        super(11, false, 20000);
        this.inventory = new ItemStackHandlerPlus(11){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                GrinderTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot >= 2 && slot <= 11;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.grinder", new Object[0]);
    }

    @Override
    protected BasicMachine getMachineBlockType() {
        return TGBlocks.SIMPLE_MACHINE2;
    }

    @Override
    protected int getNeededPower() {
        return 5;
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (TGItems.isMachineUpgrade(item)) {
            return 1;
        }
        if (GrinderRecipes.hasRecipeForInput(item)) {
            return 0;
        }
        return -1;
    }

    @Override
    protected void checkAndStartOperation() {
        this.setContentsChanged(false);
        MachineOperation op = GrinderRecipes.getOperationForInput(this.input.get(), this);
        if (op instanceof MachineOperationChance) {
            ((MachineOperationChance)op).setTile(this);
        }
        if (op != null && this.canOutput(op)) {
            int maxStack = this.getMaxMachineUpgradeMultiplier(1);
            int multiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                op.setStackMultiplier(i);
                if (!this.canConsume(op) || !this.canOutput(op)) continue;
                multiplier = i;
                break;
            }
            op.setStackMultiplier(multiplier);
            this.input.consume(op.getNeededAmountItem(0));
            this.currentOperation = op;
            this.progress = 0;
            this.totaltime = op.getTime();
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    protected boolean canOutput(MachineOperation output) {
        return this.inventory.canInsertAll(2, 11, output.getOutputsWithMult());
    }

    protected boolean canConsume(MachineOperation output) {
        int multi = output.getStackMultiplier();
        ItemStack in1 = output.getInputs().get(0);
        return this.input.canConsumeWithMultiplier(in1, multi);
    }

    @Override
    protected void finishedOperation() {
        ArrayList<ItemStack> list = this.currentOperation.getOutputsWithMult();
        List<ItemStack> leftover = this.inventory.mergeAll(2, 11, list);
        if (!this.field_145850_b.field_72995_K) {
            leftover.forEach(s -> {
                if (!s.func_190926_b()) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, s));
                }
            });
        }
    }

    @Override
    protected void playAmbientSound() {
        float prog = (float)this.progress / (float)this.totaltime;
        int sWork1 = Math.round((float)this.totaltime * 0.2f) + 1;
        int sWork2 = Math.round((float)this.totaltime * 0.6f) - 1;
        if (this.progress % 2 == 0) {
            ItemStack it = this.currentOperation.getItemInputI(0);
            float f = 0.1f;
            float f1 = 0.05f;
            if (it.func_77973_b() instanceof GenericGun) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, Math.random() * (double)f - (double)f1, Math.random() * (double)f + (double)f, Math.random() * (double)f - (double)f1, new int[]{Item.func_150891_b((Item)TGItems.PLATE_STEEL.func_77973_b()), TGItems.PLATE_STEEL.func_77952_i()});
            } else {
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, Math.random() * (double)f - (double)f1, Math.random() * (double)f + (double)f, Math.random() * (double)f - (double)f1, new int[]{Item.func_150891_b((Item)it.func_77973_b()), it.func_77952_i()});
            }
        }
        if (this.progress == 1) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.GRINDER_START, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        } else if (this.progress == sWork1 || this.progress == sWork2) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), TGSounds.GRINDER_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }
}

