/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGConfig;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.blocks.machines.BlockExplosiveCharge;
import techguns.packets.PacketSpawnParticle;
import techguns.tileentities.BasicOwnedTileEnt;

public class ExplosiveChargeTileEnt
extends BasicOwnedTileEnt
implements ITickable {
    protected short maxBlastradius = (short)3;
    protected short minBlastradius = (short)3;
    protected short minBlastLength = (short)2;
    protected short maxBlastLength = (short)5;
    protected short minFuseTime = (short)60;
    protected short maxFuseTime = (short)200;
    protected short blastradius = (short)3;
    protected short blastlength = (short)3;
    protected short fusetime = (short)100;
    protected boolean armed = false;

    public ExplosiveChargeTileEnt() {
        super(0, false);
    }

    public SoundEvent getSoundPlant() {
        return TGSounds.TNT_PLANT;
    }

    public SoundEvent getTickSound() {
        return TGSounds.TNT_TICK;
    }

    public SoundEvent getInitSound() {
        return TGSounds.TNT_INIT;
    }

    protected int getBlastRadiusForCuboid() {
        return this.blastradius / 2;
    }

    protected EnumFacing getOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
    }

    public void func_73660_a() {
        if (this.armed) {
            this.fusetime = (short)(this.fusetime - 1);
            if (!this.field_145850_b.field_72995_K && this.fusetime > 0 && this.fusetime % 20 == 0) {
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, this.getTickSound(), SoundCategory.BLOCKS, 4.0f, 1.0f);
            }
            if (this.fusetime <= 0) {
                this.explode();
            }
        }
    }

    protected void explode() {
        BlockPos pos = this.func_174877_v();
        if (!this.field_145850_b.field_72995_K) {
            EnumFacing side2;
            EnumFacing side1;
            this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            EnumFacing facing = this.getOrientation();
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                side1 = EnumFacing.NORTH;
                side2 = EnumFacing.UP;
            } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                side1 = EnumFacing.EAST;
                side2 = EnumFacing.UP;
            } else {
                side1 = EnumFacing.NORTH;
                side2 = EnumFacing.EAST;
            }
            this.field_145850_b.func_175698_g(pos);
            int rad = this.getBlastRadiusForCuboid();
            this.func_174877_v();
            BlockPos.func_177975_b((BlockPos)pos.func_177967_a(side1, rad).func_177967_a(side2, rad), (BlockPos)pos.func_177967_a(side1.func_176734_d(), rad).func_177967_a(side2.func_176734_d(), rad)).forEach(p -> this.explodeLine((BlockPos.MutableBlockPos)p, facing));
        }
    }

    protected void explodeLine(BlockPos.MutableBlockPos p, EnumFacing direction) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((BlockPos)p);
        boolean blocked = false;
        for (int i = 0; !blocked && i < this.blastlength; ++i) {
            pos.func_189536_c(direction);
            blocked = this.explodeBlock(pos);
        }
    }

    protected boolean explodeBlock(BlockPos.MutableBlockPos coords) {
        EntityPlayer ply;
        IBlockState bs = this.field_145850_b.func_180495_p((BlockPos)coords);
        Block block = bs.func_177230_c();
        if (this.canBreakBlockHardness(bs.func_185887_b(this.field_145850_b, (BlockPos)coords)) && (ply = this.field_145850_b.func_152378_a(this.getOwner())) != null) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.field_145850_b, (BlockPos)coords, bs, ply);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                block.func_176226_b(this.field_145850_b, (BlockPos)coords, bs, 0);
                this.field_145850_b.func_175698_g((BlockPos)coords);
                if (this.field_145850_b.field_73012_v.nextFloat() > 0.5f) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("MiningChargeBlockExplosion", (double)coords.func_177958_n() + 0.5, (double)coords.func_177956_o() + 0.5, (double)coords.func_177952_p() + 0.5), TGPackets.targetPointAroundBlockPos(this.field_145850_b.field_73011_w.getDimension(), (BlockPos)coords, 50.0));
                }
                return false;
            }
        }
        return true;
    }

    protected boolean canBreakBlockHardness(float hardness) {
        return hardness >= 0.0f && hardness < TGConfig.explosiveChargeMaxBlockHardness;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.blastradius = tags.func_74765_d("blastradius");
        this.blastlength = tags.func_74765_d("blastlength");
        this.fusetime = tags.func_74765_d("fusetime");
        boolean armedNew = tags.func_74767_n("armed");
        if (armedNew != this.armed && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        }
        this.armed = armedNew;
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74777_a("blastradius", this.blastradius);
        tags.func_74777_a("blastlength", this.blastlength);
        tags.func_74777_a("fusetime", this.fusetime);
        tags.func_74757_a("armed", this.armed);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("techguns.inventory.explosivecharge");
    }

    public short getBlastradius() {
        return this.blastradius;
    }

    public short getBlastlength() {
        return this.blastlength;
    }

    public short getFusetime() {
        return this.fusetime;
    }

    public boolean isArmed() {
        return this.armed;
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (!this.armed) {
            if (id == 0 && this.isUseableByPlayer(ply)) {
                this.armed = true;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.getInitSound(), SoundCategory.BLOCKS, 4.0f, 1.0f);
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                    IBlockState newState = state.func_177226_a((IProperty)BlockExplosiveCharge.ARMED, (Comparable)Boolean.valueOf(this.armed));
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, newState, 3);
                    this.func_70296_d();
                }
            } else if (id == 1) {
                if (this.blastradius < this.maxBlastradius) {
                    this.blastradius = (short)(this.blastradius + 1);
                    this.needUpdate();
                }
            } else if (id == 2) {
                if (this.blastradius > this.minBlastradius) {
                    this.blastradius = (short)(this.blastradius - 1);
                    this.needUpdate();
                }
            } else if (id == 3) {
                if (this.blastlength < this.maxBlastLength) {
                    this.blastlength = (short)(this.blastlength + 1);
                    this.needUpdate();
                }
            } else if (id == 4) {
                if (this.blastlength > this.minBlastLength) {
                    this.blastlength = (short)(this.blastlength - 1);
                    this.needUpdate();
                }
            } else if (id == 5) {
                if (this.fusetime < this.maxFuseTime) {
                    this.fusetime = (short)(this.fusetime + 20);
                    this.needUpdate();
                }
            } else if (id == 6 && this.fusetime > this.minFuseTime) {
                this.fusetime = (short)(this.fusetime - 20);
                this.needUpdate();
            }
        }
    }
}

