/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.TGItems;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.BlastFurnaceRecipes;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineSlotItem;

public class BlastFurnaceTileEnt
extends BasicMachineTileEnt {
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_UPGRADE = 3;
    public MachineSlotItem input1 = new MachineSlotItem(this, 0);
    public MachineSlotItem input2 = new MachineSlotItem(this, 1);

    public BlastFurnaceTileEnt() {
        super(4, false, 40000);
        this.inventory = new ItemStackHandlerPlus(4){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlastFurnaceTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: 
                    case 1: {
                        return BlastFurnaceTileEnt.this.isItemValidForSlot(slot, stack);
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 2;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.blast_furnace", new Object[0]);
    }

    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return BlastFurnaceRecipes.hasRecipeWithInputForSlot(stack, 0);
        }
        if (slot == 1) {
            return BlastFurnaceRecipes.hasRecipeWithInputForSlot(stack, 1);
        }
        return false;
    }

    public int getValidSlotForItemInMachine(ItemStack stack) {
        if (BlastFurnaceRecipes.hasRecipeWithInputForSlot(stack, 0)) {
            return 0;
        }
        if (BlastFurnaceRecipes.hasRecipeWithInputForSlot(stack, 1)) {
            return 1;
        }
        if (TGItems.isMachineUpgrade(stack)) {
            return 3;
        }
        return -1;
    }

    @Override
    protected int getNeededPower() {
        if (this.currentOperation != null) {
            return this.currentOperation.getPowerPerTick();
        }
        return 0;
    }

    @Override
    protected void checkAndStartOperation() {
        MachineOperation op = BlastFurnaceRecipes.getOutputFor(this);
        this.setContentsChanged(false);
        if (op != null && this.canOutput(op)) {
            int maxStack = this.getMaxMachineUpgradeMultiplier(3);
            int multiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                op.setStackMultiplier(i);
                if (!this.canOutput(op) || !this.canConsume(op)) continue;
                multiplier = i;
                break;
            }
            op.setStackMultiplier(multiplier);
            this.input1.consume(op.getNeededAmountItem(0));
            this.input2.consume(op.getNeededAmountItem(1));
            this.currentOperation = op;
            this.progress = 0;
            this.totaltime = op.getTime();
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    protected boolean canOutput(MachineOperation output) {
        return this.canOutput(output.getItemOutput0(), 2);
    }

    protected boolean canConsume(MachineOperation output) {
        int multi = output.getStackMultiplier();
        ItemStack in1 = output.getInputs().get(0);
        ItemStack in2 = output.getInputs().get(1);
        return this.input1.canConsumeWithMultiplier(in1, multi) && this.input2.canConsumeWithMultiplier(in2, multi);
    }

    @Override
    protected void finishedOperation() {
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            this.inventory.setStackInSlot(2, this.currentOperation.getItemOutput0());
        } else {
            this.inventory.insertItemNoCheck(2, this.currentOperation.getItemOutput0(), false);
        }
    }

    @Override
    protected void playAmbientSound() {
        if (this.field_145850_b.field_72995_K) {
            if (this.progress % 35 == 0) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.75f, 1.0f, true);
            }
            if (this.progress % 20 == 0) {
                float p = this.field_145850_b.field_73012_v.nextFloat() * 0.15f;
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.75f, 0.5f + p, true);
                EnumFacing enumfacing = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d1 = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 6.0 / 16.0 + 0.1875;
                double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
                double d3 = 0.52;
                double d4 = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                switch (enumfacing) {
                    case WEST: {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }
}

