/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.machines.ITGTileEntSecurity;
import techguns.damagesystem.TGDamageSource;
import techguns.damagesystem.TGExplosion;
import techguns.deatheffects.EntityDeathUtils;
import techguns.packets.PacketSpawnParticle;

public class BioBlobTileEnt
extends TileEntity
implements ITGTileEntSecurity,
ITickable {
    protected UUID owner;
    protected static final int NUMTICKS = 60;
    protected int ticks = 60;
    public byte size = 1;

    @Override
    public void setOwner(EntityPlayer ply) {
        UUID id = ply.func_146103_bH().getId();
        if (id != null) {
            this.owner = id;
        }
    }

    @Override
    public boolean isOwnedByPlayer(EntityPlayer ply) {
        if (this.owner == null) {
            return false;
        }
        return this.owner.equals(ply.func_146103_bH().getId());
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public byte getSecurity() {
        return 0;
    }

    public int getBlobSize() {
        return this.size - 1;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            --this.ticks;
            if (this.ticks <= 0) {
                if (this.size > 1) {
                    this.size = (byte)(this.size - 1);
                    this.ticks = 60;
                    this.needUpdate();
                } else if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void needUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            ChunkPos cp = this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l();
            PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
            if (entry != null) {
                entry.func_187267_a((Packet)this.func_189518_D_());
            }
            this.func_70296_d();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.func_189515_b(tags);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tags);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.func_189515_b(tags);
        return tags;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        byte oldSize = this.size;
        this.ticks = tags.func_74762_e("BlobTicks");
        this.size = tags.func_74771_c("size");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.size != oldSize) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tags = super.func_189515_b(compound);
        tags.func_74768_a("BlobTicks", this.ticks);
        tags.func_74774_a("size", this.size);
        return tags;
    }

    public void hitBlob(int power, EntityLivingBase attacker) {
        if (!this.field_145850_b.field_72995_K) {
            this.size = (byte)(this.size + power);
            if (this.size > 3) {
                this.size = (byte)3;
                float radius = 3.0f;
                TGDamageSource dmgSrc = TGDamageSource.causePoisonDamage(null, (Entity)attacker, EntityDeathUtils.DeathType.BIO);
                dmgSrc.goreChance = 1.0f;
                dmgSrc.armorPenetration = 0.35f;
                TGExplosion explosion = new TGExplosion(this.field_145850_b, (Entity)attacker, null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 30.0, 15.0, radius, radius * 1.5f, 0.0);
                explosion.setDmgSrc(dmgSrc);
                this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                explosion.doExplosion(false);
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, TGSounds.DEATH_BIO, SoundCategory.BLOCKS, 4.0f, 1.0f);
                if (!this.field_145850_b.field_72995_K) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("bioblobExplosion", (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 50.0));
                }
            }
            this.ticks = 60;
            this.needUpdate();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

