/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGItems;
import techguns.tileentities.BasicPoweredTileEnt;
import techguns.tileentities.operation.MachineOperation;

public abstract class BasicMachineTileEnt
extends BasicPoweredTileEnt
implements ITickable {
    public MachineOperation currentOperation = null;
    public int totaltime = 0;
    public int progress = 0;

    public BasicMachineTileEnt(int inventorySize, boolean hasRotation, int maximumPower) {
        super(inventorySize, hasRotation, maximumPower);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.totaltime = tags.func_74762_e("totaltime");
        this.progress = tags.func_74762_e("progress");
        this.readOperationFromNBT(tags);
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74768_a("totaltime", this.totaltime);
        tags.func_74768_a("progress", this.progress);
        if (this.currentOperation != null) {
            this.currentOperation.writeToNBT(tags);
        }
    }

    public void readOperationFromNBT(NBTTagCompound tags) {
        if (tags.func_74764_b("operation")) {
            this.currentOperation = new MachineOperation(null, null, null, null, 0);
            this.currentOperation.readFromNBT(tags);
        } else {
            this.currentOperation = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int limit) {
        if (this.totaltime != 0) {
            return this.progress * limit / this.totaltime;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPowerScaled(int limit) {
        if (this.totaltime != 0) {
            return this.energy.getMaxEnergyStored() * limit / this.energy.getMaxEnergyStored();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgress() {
        if (this.totaltime > 0) {
            return (float)this.progress / (float)this.totaltime;
        }
        return 0.0f;
    }

    public boolean isWorking() {
        return this.currentOperation != null;
    }

    public ItemStack onFluidContainerInteract(ItemStack fluidContainer) {
        return fluidContainer;
    }

    protected abstract int getNeededPower();

    public int getMaxMachineUpgradeMultiplier(int slot) {
        ItemStack upg = this.inventory.getStackInSlot(slot);
        if (!upg.func_190926_b() && upg.func_77973_b() == TGItems.SHARED_ITEM && upg.func_77952_i() == TGItems.MACHINE_UPGRADE_STACK.func_77952_i()) {
            return 1 + upg.func_190916_E();
        }
        return 1;
    }

    public void func_73660_a() {
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.consumePower(this.getNeededPower() * this.currentOperation.getStackMultiplier())) {
                    ++this.progress;
                    this.playAmbientSound();
                    if (this.progress >= this.totaltime) {
                        if (!this.field_145850_b.field_72995_K) {
                            this.finishedOperation();
                        }
                        this.progress = 0;
                        this.totaltime = 0;
                        this.currentOperation = null;
                        if (!this.field_145850_b.field_72995_K) {
                            this.checkAndStartOperation();
                            this.needUpdate();
                        }
                    }
                }
            } else if (!this.field_145850_b.field_72995_K && this.contentsChanged) {
                this.checkAndStartOperation();
            }
        }
    }

    protected abstract void checkAndStartOperation();

    protected abstract void finishedOperation();

    protected abstract void playAmbientSound();
}

