/*
 * Decompiled with CFR 0.152.
 */
package techguns.recipes;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import techguns.items.guns.GenericGun;

public class IngredientHasNBTTag
extends Ingredient {
    protected final String key;
    protected final Object value;
    protected final byte id;

    public IngredientHasNBTTag(@Nonnull String key, @Nonnull Object value, ItemStack ... stacks) {
        super(stacks);
        this.key = key;
        this.value = value;
        this.id = IngredientHasNBTTag.getIdforClass(value);
    }

    public ItemStack[] func_193365_a() {
        int size = super.func_193365_a().length;
        ItemStack[] matchingStacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            matchingStacks[i] = super.func_193365_a()[i].func_77946_l();
            if (!(matchingStacks[i].func_77973_b() instanceof GenericGun)) continue;
            GenericGun g = (GenericGun)matchingStacks[i].func_77973_b();
            g.func_77622_d(matchingStacks[i], null, null);
            NBTTagCompound tags = matchingStacks[i].func_77978_p();
            IngredientHasNBTTag.setTagByType(this.id, tags, this.key, this.value);
        }
        return matchingStacks;
    }

    public boolean apply(ItemStack stack) {
        NBTTagCompound tags;
        if (super.apply(stack) && (tags = stack.func_77978_p()) != null && tags.func_150297_b(this.key, (int)this.id)) {
            Object o = IngredientHasNBTTag.getTagByType(this.id, tags, this.key);
            return this.value.equals(o);
        }
        return false;
    }

    protected static byte getIdforClass(Object o) {
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof Short) {
            return 2;
        }
        if (o instanceof Integer) {
            return 3;
        }
        if (o instanceof Long) {
            return 4;
        }
        if (o instanceof Float) {
            return 5;
        }
        if (o instanceof Double) {
            return 6;
        }
        if (o instanceof Byte[]) {
            return 7;
        }
        if (o instanceof String) {
            return 8;
        }
        if (o instanceof NBTTagCompound) {
            return 10;
        }
        if (o instanceof Integer[]) {
            return 11;
        }
        throw new UnsupportedOperationException("Invalid datatype for NBT tag: " + o.getClass().getName());
    }

    protected static Object getTagByType(byte id, NBTTagCompound tags, String key) {
        switch (id) {
            case 1: {
                return tags.func_74771_c(key);
            }
            case 2: {
                return tags.func_74765_d(key);
            }
            case 3: {
                return tags.func_74762_e(key);
            }
            case 4: {
                return tags.func_74763_f(key);
            }
            case 5: {
                return Float.valueOf(tags.func_74760_g(key));
            }
            case 6: {
                return tags.func_74769_h(key);
            }
            case 7: {
                return tags.func_74770_j(key);
            }
            case 8: {
                return tags.func_74779_i(key);
            }
            case 10: {
                return tags.func_74775_l(key);
            }
            case 11: {
                return tags.func_74759_k(key);
            }
        }
        return null;
    }

    protected static void setTagByType(byte id, NBTTagCompound tags, String key, Object value) {
        switch (id) {
            case 1: {
                tags.func_74774_a(key, ((Byte)value).byteValue());
                break;
            }
            case 2: {
                tags.func_74777_a(key, ((Short)value).shortValue());
                break;
            }
            case 3: {
                tags.func_74768_a(key, ((Integer)value).intValue());
                break;
            }
            case 4: {
                tags.func_74772_a(key, ((Long)value).longValue());
                break;
            }
            case 5: {
                tags.func_74776_a(key, ((Float)value).floatValue());
                break;
            }
            case 6: {
                tags.func_74780_a(key, ((Double)value).doubleValue());
                break;
            }
            case 7: {
                tags.func_74773_a(key, (byte[])value);
                break;
            }
            case 8: {
                tags.func_74778_a(key, (String)value);
                break;
            }
            case 10: {
                tags.func_74782_a(key, (NBTBase)value);
                break;
            }
            case 11: {
                tags.func_74783_a(key, (int[])value);
                break;
            }
        }
    }
}

