/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.ITickTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import techguns.gui.ReactionChamberGui;

public class ProgressBarReactionChamberIntensityJump
implements IDrawableAnimated {
    protected ITickTimer timer;
    protected IGuiHelper guiHelper;
    protected int w;
    protected int h;
    protected int intensity;
    protected int margin;

    public ProgressBarReactionChamberIntensityJump(IGuiHelper guiHelper, int w, int h, int intensity, int margin) {
        this.guiHelper = guiHelper;
        int totalTime = 180;
        this.timer = guiHelper.createTickTimer(totalTime, totalTime, false);
        this.intensity = intensity;
        this.margin = margin;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        minecraft.func_110434_K().func_110577_a(ReactionChamberGui.texture);
        int height = 4 * this.intensity;
        int u_offset = 0;
        if (this.margin > 0) {
            float prog = (float)this.timer.getValue() / (float)this.timer.getMaxValue();
            float jump_prog = (float)Math.sin((double)(prog * 2.0f) * Math.PI);
            int val = Math.round(jump_prog * (float)this.margin);
            if (val > this.margin) {
                val = this.margin;
            } else if (val < -this.margin) {
                val = -this.margin;
            }
            height = 4 * (this.intensity + val);
            u_offset = 8;
        }
        this.drawTexturedModalRect(xOffset, yOffset + 40 - height, 190 + u_offset, 40 - height, 5, height);
        this.drawTexturedModalRect(xOffset - 2, yOffset + 40 - 1 - 4 * this.intensity, 178, 22, 5, 3);
    }

    private void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (float)256.0f, (float)256.0f);
    }
}

