/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import techguns.gui.OreDrillGui;
import techguns.plugins.jei.BasicRecipeCategory;
import techguns.plugins.jei.OreDrillJeiRecipe;
import techguns.util.TextUtil;

public class OreDrillJeiRecipeCategory
extends BasicRecipeCategory<OreDrillJeiRecipe> {
    protected IDrawableStatic tank_overlay;
    protected IDrawableStatic progress_static;
    protected IDrawableAnimated progress;

    public OreDrillJeiRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, OreDrillGui.texture, "oredrill", "techguns.oredrill");
        this.tank_overlay = guiHelper.createDrawable(OreDrillGui.texture, 177, 40, 10, 50);
        this.progress_static = guiHelper.createDrawable(OreDrillGui.texture, 177, 1, 25, 36);
        this.progress = guiHelper.createAnimatedDrawable(this.progress_static, 100, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, OreDrillJeiRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 22, 1);
        guiItemStacks.init(1, true, 69, 40);
        guiItemStacks.init(2, true, 22, 35);
        guiItemStacks.init(3, false, 94, 1);
        guiItemStacks.addTooltipCallback((ITooltipCallback)new OreDrillOutputTooltipCallback(recipeWrapper));
        guiFluidStacks.init(0, true, 9, 2, 10, 50, 16000, false, (IDrawable)this.tank_overlay);
        guiFluidStacks.init(1, false, 151, 2, 10, 50, 32000, false, (IDrawable)this.tank_overlay);
        guiFluidStacks.addTooltipCallback((ITooltipCallback)new TankTooltipCallback(recipeWrapper));
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.powerbar.draw(minecraft, 0, 1);
        this.progress.draw(minecraft, 66, 2);
    }

    protected class TankTooltipCallback
    implements ITooltipCallback<FluidStack> {
        OreDrillJeiRecipe jeiRec;

        public TankTooltipCallback(OreDrillJeiRecipe jeiRec) {
            this.jeiRec = jeiRec;
        }

        public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
            if (!input) {
                tooltip.add(tooltip.size() - 1, TextUtil.transTG("oredrill.jei.chance") + ": " + String.format("%.2f", Float.valueOf(this.jeiRec.getChance() * 100.0f)) + "%");
            }
        }
    }

    protected class OreDrillOutputTooltipCallback
    implements ITooltipCallback<ItemStack> {
        OreDrillJeiRecipe jeiRec;

        public OreDrillOutputTooltipCallback(OreDrillJeiRecipe jeiRec) {
            this.jeiRec = jeiRec;
        }

        public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
            if (!input) {
                tooltip.add(tooltip.size() - 1, TextUtil.transTG("oredrill.jei.chance") + ": " + String.format("%.2f", Float.valueOf(this.jeiRec.getChance() * 100.0f)) + "%");
            }
        }
    }
}

