/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.plugins.crafttweaker.TGCraftTweakerHelper;
import techguns.tileentities.operation.MetalPressRecipes;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;

@ZenClass(value="mods.techguns.MetalPress")
public class MetalPressTweaker {
    @ZenMethod
    public static void addRecipe(IItemStack input1, IItemStack input2, IItemStack output, boolean allowSwap) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), allowSwap, output));
    }

    @ZenMethod
    public static void addRecipe(String input1, IItemStack input2, IItemStack output, boolean allowSwap) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), allowSwap, output));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input1, String input2, IItemStack output, boolean allowSwap) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), allowSwap, output));
    }

    @ZenMethod
    public static void addRecipe(String input1, String input2, IItemStack output, boolean allowSwap) {
        CraftTweakerAPI.apply((IAction)new addInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), allowSwap, output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(null, null, output));
    }

    @ZenMethod
    public static void removeRecipe(String input1, String input2, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input1, String input2, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), output));
    }

    @ZenMethod
    public static void removeRecipe(String input1, IItemStack input2, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input1, IItemStack input2, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input1), TGCraftTweakerHelper.toItemStackOreDict(input2), output));
    }

    private static class removeInputAction
    implements IAction {
        ItemStackOreDict input1;
        ItemStackOreDict input2;
        ItemStack output;

        public removeInputAction(ItemStackOreDict input1, ItemStackOreDict input2, IItemStack output) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            Iterator<MetalPressRecipes.MetalPressRecipe> iter = MetalPressRecipes.getRecipes().iterator();
            while (iter.hasNext()) {
                MetalPressRecipes.MetalPressRecipe rec = iter.next();
                if (!ItemUtil.isItemEqual(rec.output, this.output)) continue;
                if (this.input1 != null && !this.input1.isEmpty()) {
                    if (!rec.slot1.matches(this.input1) || !rec.slot2.matches(this.input2)) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        }

        public String describe() {
            if (this.input1 != null && !this.input1.isEmpty()) {
                return "Removed Recipe " + this.input1 + "+" + this.input2 + "-->" + this.output + " from MetalPress";
            }
            return "Removed Recipe(s) for " + this.output + " from MetalPress";
        }
    }

    private static class addInputAction
    implements IAction {
        ItemStackOreDict input1;
        ItemStackOreDict input2;
        boolean swap;
        ItemStack output;

        public addInputAction(ItemStackOreDict input1, ItemStackOreDict input2, boolean swap, IItemStack output) {
            this.input1 = input1;
            this.input2 = input2;
            this.swap = swap;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            MetalPressRecipes.getRecipes().add(new MetalPressRecipes.MetalPressRecipe(this.input1, this.input2, this.swap, this.output));
        }

        public String describe() {
            return "Add " + this.input1 + "+" + this.input2 + "-->" + this.output + " to MetalPress";
        }
    }
}

