/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.tileentities.operation.GrinderRecipes;

@ZenClass(value="mods.techguns.Grinder")
public class GrinderTweaker {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack[] outputs) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input, outputs));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack[] outputs, double[] chances) {
        CraftTweakerAPI.apply((IAction)new addChanceInputAction(input, outputs, chances));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(input));
    }

    private static class addChanceInputAction
    extends addInputAction {
        double[] chances;

        public addChanceInputAction(IItemStack input, IItemStack[] outputs, double[] chances) {
            super(input, outputs);
            this.chances = chances;
        }

        @Override
        public void apply() {
            if (this.outputs.length <= 9 && this.outputs.length == this.chances.length) {
                GrinderRecipes.addRecipeChance(this.input, this.outputs, this.chances);
            }
        }

        @Override
        public String describe() {
            if (this.outputs.length <= 9 && this.outputs.length == this.chances.length) {
                return "Add Recipe for " + this.input + " to Grinder";
            }
            return "Grinder Recipes must not have more than 9 different outputs and chances and input array sizes must match!";
        }
    }

    private static class addInputAction
    implements IAction {
        ItemStack input;
        ItemStack[] outputs;

        public addInputAction(IItemStack input, IItemStack[] outputs) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.outputs = CraftTweakerMC.getItemStacks((IItemStack[])outputs);
        }

        public void apply() {
            if (this.outputs.length <= 9) {
                GrinderRecipes.addRecipe(this.input, this.outputs);
            }
        }

        public String describe() {
            if (this.outputs.length <= 9) {
                return "Add Recipe for " + this.input + " to Grinder";
            }
            return "Can't add grinder Recipes with more than 9 different outputs";
        }
    }

    private static class removeInputAction
    implements IAction {
        ItemStack input;

        public removeInputAction(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            GrinderRecipes.removeRecipeFor(this.input);
        }

        public String describe() {
            return "Remove Recipe for " + this.input + " from Grinder";
        }
    }
}

