/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.api.damagesystem.DamageType;
import techguns.items.armors.EnumArmorStat;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.PoweredArmor;
import techguns.items.armors.TGArmorMaterial;
import techguns.util.MathUtil;

@ZenClass(value="mods.techguns.ArmorStats")
public class ArmorStatTweaker {
    @ZenMethod
    public static void setArmorStat(String armorname, String stat, float value) {
        CraftTweakerAPI.apply((IAction)new setArmorStatAction(armorname, stat, value));
    }

    @ZenMethod
    public static void setArmorStat(String armorname, String stat, float powered, float unpowered) {
        CraftTweakerAPI.apply((IAction)new setArmorStatAction(armorname, stat, powered, unpowered));
    }

    @ZenMethod
    public static void setMaterialArmorValue(String material, String damagetype, float amount) {
        CraftTweakerAPI.apply((IAction)new setArmorMaterialValue(material, damagetype, amount));
    }

    private static class setArmorStatAction
    implements IAction {
        protected String armorname;
        protected String statname;
        protected GenericArmor armor;
        protected EnumArmorStat stat;
        protected float value;
        protected float value_unpowered;
        protected boolean itemOk = false;

        public setArmorStatAction(String armorname, String statname, float value) {
            this(armorname, statname, value, 0.0f);
        }

        public setArmorStatAction(String armorname, String statname, float value, float value_unpowered) {
            this.armorname = armorname;
            this.statname = statname;
            this.value = value;
            this.value_unpowered = value_unpowered;
            Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation("techguns", armorname));
            this.stat = EnumArmorStat.parseFromString(statname);
            boolean bl = this.itemOk = item != null && item instanceof GenericArmor;
            if (this.itemOk) {
                this.armor = (GenericArmor)item;
            }
        }

        public void apply() {
            if (this.itemOk && this.stat != null) {
                if (this.armor instanceof PoweredArmor) {
                    ((PoweredArmor)this.armor).setArmorStat(this.stat, this.value, this.value_unpowered);
                } else {
                    this.armor.setArmorStat(this.stat, this.value);
                }
            }
        }

        public String describe() {
            if (!this.itemOk) {
                return "Failed setting [" + this.statname + "] for Weapon: [" + this.armorname + "]: ITEM IS NOT A TECHGUNS ARMOR";
            }
            if (this.stat == null) {
                return "Failed setting [" + this.statname + "] for Weapon: [" + this.armorname + "]: UNKNOWN STAT";
            }
            return "Set [" + this.statname + "] for Armor: [" + this.armorname + "] to: " + this.value;
        }
    }

    private static class setArmorMaterialValue
    implements IAction {
        String materialname;
        float value;
        String typename;
        DamageType type;
        TGArmorMaterial material;

        public setArmorMaterialValue(String materialname, String typename, float value) {
            this.materialname = materialname;
            this.value = MathUtil.clamp(value, 0.0f, 20.0f);
            this.typename = typename;
            for (DamageType dt : DamageType.values()) {
                if (!dt.name().equalsIgnoreCase(typename)) continue;
                this.type = dt;
                break;
            }
            for (TGArmorMaterial mat : TGArmorMaterial.MATERIALS) {
                if (!mat.name.equalsIgnoreCase(materialname)) continue;
                this.material = mat;
                break;
            }
        }

        public void apply() {
            if (this.material != null && this.type != null) {
                this.material.setArmorValueForType(this.type, this.value);
            }
        }

        public String describe() {
            if (this.material == null) {
                return "Failed setting ArmorValue [" + this.typename + "] for Material: [" + this.materialname + "]: MATERIAL DOES NOT EXIST!";
            }
            if (this.type == null) {
                return "Failed setting ArmorValue [" + this.typename + "] for Material: [" + this.materialname + "]: UNKNOWN DAMAGE TYPE!";
            }
            return "Set ArmorValue [" + this.typename + "] for Material: [" + this.materialname + "] to: " + this.value;
        }
    }
}

