/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.plugins.crafttweaker.TGCraftTweakerHelper;
import techguns.tileentities.operation.AmmoPressBuildPlans;

@ZenClass(value="mods.techguns.AmmoPress")
public class AmmoPressTweaker {
    private AmmoPressTweaker() {
    }

    @ZenMethod
    public static void addMetal1(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input, 0));
    }

    @ZenMethod
    public static void addMetal2(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input, 1));
    }

    @ZenMethod
    public static void addPowder(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input, 2));
    }

    @ZenMethod
    public static void removeMetal1(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(input, 0));
    }

    @ZenMethod
    public static void removeMetal2(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(input, 1));
    }

    @ZenMethod
    public static void removePowder(IIngredient input) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(input, 2));
    }

    private static void addToList(IIngredient item, ArrayList<ItemStack> list) {
        List items = item.getItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack it = CraftTweakerMC.getItemStack((IItemStack)((IItemStack)items.get(i)));
            if (it == null) continue;
            list.add(it);
        }
    }

    private static void removeFromList(IIngredient item, ArrayList<ItemStack> list) {
        List items = item.getItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack it = CraftTweakerMC.getItemStack((IItemStack)((IItemStack)items.get(i)));
            Iterator<ItemStack> iter = list.iterator();
            while (iter.hasNext()) {
                ItemStack input = iter.next();
                if (!OreDictionary.itemMatches((ItemStack)it, (ItemStack)input, (boolean)false)) continue;
                iter.remove();
            }
        }
    }

    private static String getSlotName(byte type) {
        switch (type) {
            case 1: {
                return "Metal2";
            }
            case 2: {
                return "Powder";
            }
        }
        return "Metal1";
    }

    private static class removeInputAction
    implements IAction {
        IIngredient input;
        ArrayList<ItemStack> list;
        byte type;

        public removeInputAction(IIngredient input, byte type) {
            this.input = input;
            this.type = type;
            switch (type) {
                case 1: {
                    this.list = AmmoPressBuildPlans.metal2;
                    break;
                }
                case 2: {
                    this.list = AmmoPressBuildPlans.powder;
                    break;
                }
                default: {
                    this.list = AmmoPressBuildPlans.metal1;
                }
            }
        }

        public void apply() {
            AmmoPressTweaker.removeFromList(this.input, this.list);
        }

        public String describe() {
            return "Remove " + TGCraftTweakerHelper.getItemNames(this.input) + " to AmmoPressSlot: " + AmmoPressTweaker.getSlotName(this.type);
        }
    }

    private static class addInputAction
    implements IAction {
        IIngredient input;
        ArrayList<ItemStack> list;
        byte type;

        public addInputAction(IIngredient input, byte type) {
            this.input = input;
            this.type = type;
            switch (type) {
                case 1: {
                    this.list = AmmoPressBuildPlans.metal2;
                    break;
                }
                case 2: {
                    this.list = AmmoPressBuildPlans.powder;
                    break;
                }
                default: {
                    this.list = AmmoPressBuildPlans.metal1;
                }
            }
        }

        public void apply() {
            AmmoPressTweaker.addToList(this.input, this.list);
        }

        public String describe() {
            return "Add " + TGCraftTweakerHelper.getItemNames(this.input) + " to AmmoPressSlot: " + AmmoPressTweaker.getSlotName(this.type);
        }
    }
}

