/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.client.ClientProxy;

public class PacketSpawnParticle
implements IMessage {
    String name;
    double posX;
    double posY;
    double posZ;
    double motionX = 0.0;
    double motionY = 0.0;
    double motionZ = 0.0;
    float scale = 1.0f;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ) {
        this.name = name;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ, float scale) {
        this(name, posX, posY, posZ);
        this.scale = scale;
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this.name = name;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public PacketSpawnParticle(String name, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, float scale) {
        this(name, posX, posY, posZ, motionX, motionY, motionZ);
        this.scale = scale;
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        this.name = buf.readCharSequence((int)len, StandardCharsets.UTF_8).toString();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
        this.scale = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        String cs = this.name;
        buf.writeShort(cs.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
        buf.writeFloat(this.scale);
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticle, IMessage> {
        public IMessage onMessage(PacketSpawnParticle message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSpawnParticle m, MessageContext ctx) {
            ClientProxy.get().createFX(m.name, TGPackets.getPlayerFromContext((MessageContext)ctx).field_70170_p, m.posX, m.posY, m.posZ, m.motionX, m.motionY, m.motionZ, m.scale);
        }
    }
}

