/*
 * Decompiled with CFR 0.152.
 */
package techguns.items;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import techguns.items.GenericItem;
import techguns.util.BlockUtils;
import techguns.world.structures.MilitaryCamp;
import techguns.world.structures.SurvivorHideout;
import techguns.world.structures.WorldgenStructure;

public class WorldGenTestTool
extends GenericItem {
    static String[] modes = new String[]{"MilitaryBase", "Barracks", "Smooth", "Flatten", "Remove Junk"};

    public WorldGenTestTool(String name) {
        this(name, true);
    }

    public WorldGenTestTool(String name, boolean addItemToList) {
        super(name, addItemToList);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (player.func_70093_af()) {
            int mode = 1;
            if (item.func_77978_p().func_74764_b("mode")) {
                mode = (item.func_77978_p().func_74762_e("mode") + 1) % modes.length;
            }
            item.func_77978_p().func_74768_a("mode", mode);
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("WorldGen tool mode set to \"" + modes[mode] + "\"."), false);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ItemStack item = player.func_184586_b(hand);
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (player.func_70093_af()) {
            int mode = 1;
            if (item.func_77978_p().func_74764_b("mode")) {
                mode = (item.func_77978_p().func_74762_e("mode") + 1) % modes.length;
            }
            item.func_77978_p().func_74768_a("mode", mode);
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("WorldGen tool mode set to \"" + modes[mode] + "\"."), false);
            }
        } else if (item.func_77978_p().func_74764_b("x1") && item.func_77978_p().func_74764_b("y1") && item.func_77978_p().func_74764_b("z1")) {
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("Position2 set (" + x + "/" + y + "/" + z + ")."), false);
            }
            int x1 = item.func_77978_p().func_74762_e("x1");
            int y1 = item.func_77978_p().func_74762_e("y1");
            int z1 = item.func_77978_p().func_74762_e("z1");
            int sizeX = Math.abs(x1 - x) + 1;
            int sizeY = Math.abs(y1 - y) + 1;
            int sizeZ = Math.abs(z1 - z) + 1;
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("Size: (" + sizeX + "/" + sizeY + "/" + sizeZ + ")."), false);
            }
            if (!world.field_72995_K) {
                int mode = 0;
                if (item.func_77978_p().func_74764_b("mode")) {
                    mode = item.func_77978_p().func_74762_e("mode");
                }
                this.doOperation(world, Math.min(x, x1), Math.min(y, y1), Math.min(z, z1), sizeX, sizeY, sizeZ, mode);
            }
            item.func_77978_p().func_82580_o("x1");
            item.func_77978_p().func_82580_o("y1");
            item.func_77978_p().func_82580_o("z1");
        } else {
            item.func_77978_p().func_74768_a("x1", x);
            item.func_77978_p().func_74768_a("y1", y);
            item.func_77978_p().func_74768_a("z1", z);
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("Position1 set (" + x + "/" + y + "/" + z + ")."), false);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void doOperation(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ, int mode) {
        Random rnd = new Random();
        switch (mode) {
            case 0: {
                MilitaryCamp camp = new MilitaryCamp(3, rnd);
                camp.init(x, y, z, sizeX, sizeZ);
                camp.setBlocks(world, rnd);
                break;
            }
            case 1: {
                SurvivorHideout b = new SurvivorHideout();
                b.setBlocks(world, x, y, z, sizeX, 32, sizeZ, rnd.nextInt(4), WorldgenStructure.BiomeColorType.DESERT, rnd);
                break;
            }
            case 2: {
                BlockUtils.apply2DHeightmapFilter(world, x, z, sizeX, sizeZ, BlockUtils.FILTER_GAUSSIAN_5x5);
                break;
            }
            case 3: {
                BlockUtils.flattenArea(world, x, z, sizeX, sizeZ, 2);
                break;
            }
            case 4: {
                BlockUtils.removeJunkInArea(world, x, z, sizeX, sizeZ);
            }
        }
    }
}

