/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui.containers;

import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import techguns.TGConfig;
import techguns.gui.containers.OwnedTileContainer;
import techguns.gui.widgets.SlotArmor;
import techguns.items.armors.GenericArmor;
import techguns.tileentities.UpgradeBenchTileEnt;
import techguns.tileentities.operation.UpgradeBenchRecipes;
import techguns.util.EntityUtil;

public class UpgradeBenchContainer
extends OwnedTileContainer {
    protected final UpgradeBenchTileEnt tile;
    public final IInventory outputSlot;
    protected final IInventory inputSlots;
    protected int xp_needed = 0;
    public static final int SLOT_Y = 47;
    public static final int SLOT_INPUT_X = 17;
    public static final int SLOT_UPGRADE_X = 53;
    public static final int SLOT_OUTPUT_X = 116;
    protected static final int MAXSLOTS = 44;
    protected static final int HIGHEST_SLOT = 2;

    public UpgradeBenchContainer(InventoryPlayer player, UpgradeBenchTileEnt ent) {
        super(player, ent);
        this.tile = ent;
        this.outputSlot = new InventoryCraftResult();
        this.inputSlots = new InventoryBasic("UpgradeBench", true, 2){

            public void func_70296_d() {
                super.func_70296_d();
                UpgradeBenchContainer.this.func_75130_a((IInventory)this);
            }
        };
        this.func_75146_a(new SlotInput(this.inputSlots, 0, 17, 47));
        this.func_75146_a(new SlotInput(this.inputSlots, 1, 53, 47));
        this.func_75146_a(new Slot(this.outputSlot, 2, 116, 47){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                UpgradeBenchContainer.this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
                UpgradeBenchContainer.this.inputSlots.func_70301_a(1).func_190918_g(1);
                UpgradeBenchContainer.this.tile.func_145831_w().func_184148_a(thePlayer, thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v, SoundEvents.field_187716_o, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!thePlayer.field_71075_bZ.field_75098_d) {
                    EntityUtil.playerAddExperiencePoints(thePlayer, -UpgradeBenchContainer.this.xp_needed);
                }
                UpgradeBenchContainer.this.xp_needed = 0;
                return super.func_190901_a(thePlayer, stack);
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                if (!this.field_75224_c.func_70301_a(0).func_190926_b()) {
                    return playerIn.field_71075_bZ.field_75098_d || playerIn.field_71067_cb >= UpgradeBenchContainer.this.xp_needed;
                }
                return false;
            }
        });
        this.addPlayerInventorySlots(player);
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotArmor((IInventory)player, 39 - i, 17 + i * 18, 18, i, player.field_70458_d));
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.tile.func_145831_w().field_72995_K) {
            this.func_193327_a(playerIn, this.tile.func_145831_w(), this.inputSlots);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        if (inventoryIn == this.inputSlots) {
            this.updateOutput();
        }
    }

    public void updateOutput() {
        UpgradeBenchRecipes.UpgradeBenchRecipe r = UpgradeBenchRecipes.getUpgradeRecipeFor(this.inputSlots.func_70301_a(0), this.inputSlots.func_70301_a(1));
        if (r != null) {
            ItemStack output = this.inputSlots.func_70301_a(0).func_77946_l();
            Map map = EnchantmentHelper.func_82781_a((ItemStack)this.inputSlots.func_70301_a(0));
            this.xp_needed = this.calculateXPCost(r);
            if (map.containsKey(r.getEnch())) {
                Integer level = (Integer)map.get(r.getEnch());
                if (r.getLevel() > level) {
                    map.put(r.getEnch(), r.getLevel());
                    EnchantmentHelper.func_82782_a((Map)map, (ItemStack)output);
                    this.outputSlot.func_70299_a(0, output);
                } else {
                    this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
                }
            } else {
                map.put(r.getEnch(), r.getLevel());
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)output);
                this.outputSlot.func_70299_a(0, output);
            }
        } else {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    public int getXp_needed() {
        return this.xp_needed;
    }

    public int calculateXPCost() {
        UpgradeBenchRecipes.UpgradeBenchRecipe r = UpgradeBenchRecipes.getUpgradeRecipeFor(this.inputSlots.func_70301_a(0), this.inputSlots.func_70301_a(1));
        if (r != null) {
            return this.calculateXPCost(r);
        }
        return 0;
    }

    public int calculateXPCost(UpgradeBenchRecipes.UpgradeBenchRecipe r) {
        Map map = EnchantmentHelper.func_82781_a((ItemStack)this.inputSlots.func_70301_a(0));
        if (map.containsKey(r.getEnch())) {
            Integer level = (Integer)map.get(r.getEnch());
            if (r.getLevel() > level) {
                int dif = r.getLevel() - level;
                return TGConfig.upgrade_xp_cost * dif;
            }
            return 0;
        }
        return TGConfig.upgrade_xp_cost * r.getLevel();
    }

    public ItemStack func_82846_b(EntityPlayer ply, int id) {
        ItemStack stack1;
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot.func_75216_d() && !(stack = (stack1 = slot.func_75211_c()).func_77946_l()).func_190926_b()) {
            if (id >= 0 && id <= 2) {
                if (!this.func_75135_a(stack1, 3, 44, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (id > 2 && id < 44) {
                int validslot = this.getValidSlotForItemInInventory(stack1);
                if (validslot >= 0) {
                    if (!this.func_75135_a(stack1, validslot, validslot + 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack1, stack);
                } else {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(ply, stack1);
        }
        return stack;
    }

    protected int getValidSlotForItemInInventory(ItemStack stack1) {
        if (!stack1.func_190926_b() && stack1.func_77973_b() instanceof GenericArmor) {
            return 0;
        }
        if (UpgradeBenchRecipes.getUpgradeRecipeForUpgradeItem(stack1) != null) {
            return 1;
        }
        return -1;
    }

    public class SlotInput
    extends Slot {
        public SlotInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            UpgradeBenchContainer.this.xp_needed = UpgradeBenchContainer.this.calculateXPCost();
            return super.func_190901_a(thePlayer, stack);
        }
    }
}

