/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui.containers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.gui.containers.RedstoneTileContainer;
import techguns.gui.widgets.SlotItemHandlerOutput;
import techguns.gui.widgets.SlotMachineInput;
import techguns.gui.widgets.SlotTG;
import techguns.gui.widgets.SlotTurretArmor;
import techguns.gui.widgets.SlotTurretGun;
import techguns.items.guns.GenericGun;
import techguns.tileentities.TurretTileEnt;
import techguns.tileentities.operation.ItemStackHandlerPlus;

public class TurretContainer
extends RedstoneTileContainer {
    protected int lastRepairTime = 0;
    protected boolean lastTurretDeath = false;
    protected TurretTileEnt tile;
    protected int lastPowerStored = 0;
    protected static final int FIELD_SYNC_ID_TURRETDEATH = 2;
    protected static final int FIELD_SYNC_ID_REPAIRTIME = 3;
    public static final int FIELD_SYNC_ID_POWER_STORED = 4;

    public TurretContainer(InventoryPlayer player, TurretTileEnt ent) {
        super(player, ent);
        this.tile = ent;
        IItemHandler inventory = (IItemHandler)ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.SOUTH);
        if (inventory instanceof ItemStackHandlerPlus) {
            int j;
            int i;
            ItemStackHandlerPlus handler = (ItemStackHandlerPlus)inventory;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a((Slot)new SlotMachineInput(handler, i * 3 + j, 18 + 18 * i, 17 + 18 * j){

                        public String func_178171_c() {
                            return SlotTG.AMMOSLOT_TEX.toString();
                        }
                    });
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a((Slot)new SlotItemHandlerOutput((IItemHandler)handler, 9 + i * 3 + j, 116 + 18 * i, 17 + 18 * j){

                        public String func_178171_c() {
                            return SlotTG.AMMOEMPTYSLOT_TEX.toString();
                        }
                    });
                }
            }
            this.func_75146_a((Slot)new SlotTurretGun(handler, 18, 85, 19));
            this.func_75146_a((Slot)new SlotTurretArmor(handler, 19, 85, 42));
        }
        this.addPlayerInventorySlots(player);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
            if (this.lastTurretDeath != this.tile.turretDeath) {
                listener.func_71112_a((Container)this, 2, this.tile.turretDeath ? 1 : 0);
            }
            if (this.lastRepairTime != this.tile.repairTime) {
                listener.func_71112_a((Container)this, 3, this.tile.repairTime);
            }
            if (this.lastPowerStored == this.tile.getEnergyStorage().getEnergyStored()) continue;
            listener.func_71112_a((Container)this, 4, this.tile.getEnergyStorage().getEnergyStored());
        }
        this.lastRepairTime = this.tile.repairTime;
        this.lastTurretDeath = this.tile.turretDeath;
        this.lastPowerStored = this.tile.getEnergyStorage().getEnergyStored();
    }

    @Override
    public void func_75137_b(int id, int data) {
        if (id == 3) {
            this.tile.repairTime = data;
        } else if (id == 2) {
            this.tile.turretDeath = data != 0;
        } else if (id == 4) {
            this.tile.getEnergyStorage().setEnergyStored(data);
        } else {
            super.func_75137_b(id, data);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotid) {
        ItemStack stack1;
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotid);
        if (slot.func_75216_d() && !(stack = (stack1 = slot.func_75211_c()).func_77946_l()).func_190926_b()) {
            if (slotid <= 19) {
                if (!this.func_75135_a(stack1, 20, 56, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (slotid > 19) {
                if (stack.func_77973_b() instanceof GenericGun) {
                    if (!this.func_75135_a(stack1, 18, 19, false)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack1, stack);
                } else if (stack.func_77973_b() instanceof ITGSpecialSlot && ((ITGSpecialSlot)stack.func_77973_b()).getSlot(stack) == TGSlotType.TURRETARMOR) {
                    if (!this.func_75135_a(stack1, 19, 20, false)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack1, stack);
                } else {
                    if (!this.func_75135_a(stack1, 9, 9, false)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack1, stack);
                }
            }
            if (stack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack1);
        }
        return stack;
    }
}

