/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui;

import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import techguns.gui.PoweredTileEntGui;
import techguns.gui.containers.ReactionChamberContainer;
import techguns.tileentities.ReactionChamberTileEntMaster;
import techguns.util.TextUtil;

public class ReactionChamberGui
extends PoweredTileEntGui {
    ReactionChamberTileEntMaster tile;
    public static final ResourceLocation texture = new ResourceLocation("techguns", "textures/gui/reaction_chamber_gui.png");

    public ReactionChamberGui(InventoryPlayer ply, ReactionChamberTileEntMaster tile) {
        super((Container)new ReactionChamberContainer(ply, tile), tile);
        this.tile = tile;
        this.tex = texture;
        this.hasUpgradeSlot = false;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (this.tile.inputTank.getFluidAmount() > 0) {
            int px = this.tile.inputTank.getFluidAmount() * 50 / this.tile.inputTank.getCapacity();
            TextureAtlasSprite tex = this.field_146297_k.func_147117_R().getTextureExtry(this.tile.inputTank.getFluid().getFluid().getStill().toString());
            this.drawFluidWithTesselator(tex, k + 18 + 1, l + 17, 10, 50, px);
        }
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int px_height = 50 - this.tile.getLiquidLevel() * 5;
        this.func_73729_b(k + 18, l + 17, 176, 32, 12, 52);
        this.func_73729_b(k + 19, l + 17 + px_height, 177, 32, 7, 1);
        if (this.tile.isWorking()) {
            byte compl = this.tile.getCurrentReaction().completion;
            byte req_compl = this.tile.getCurrentReaction().getRecipe().requiredCompletion;
            int compl_px = Math.round((float)compl * 1.0f / ((float)req_compl * 1.0f) * 100.0f);
            int dur = this.tile.progress;
            int maxdur = this.tile.totaltime;
            int dur_px = Math.round((float)dur * 1.0f / ((float)maxdur * 1.0f) * 100.0f);
            this.func_73729_b(k + 67, l + 61, 0, 167, compl_px, 4);
            this.func_73729_b(k + 67, l + 69, 0, 175, dur_px, 4);
            int px = (10 - this.tile.getIntensity()) * 4;
            if (this.tile.getCurrentReaction().required_intensity != this.tile.getIntensity()) {
                this.func_73729_b(k + 114, l + 16 + px, 198, px, 5, 40 - px);
            } else {
                this.func_73729_b(k + 114, l + 16 + px, 190, px, 5, 40 - px);
            }
            int h = 40 - this.tile.getCurrentReaction().required_intensity * 4;
            this.func_73729_b(k + 112, l + 15 + h, 178, 22, 5, 3);
        } else {
            int px = (10 - this.tile.getIntensity()) * 4;
            this.func_73729_b(k + 114, l + 16 + px, 190, px, 5, 40 - px);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int mx = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int my = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        int fluidLevel = this.tile.getLiquidLevel() * 10;
        byte intensity = this.tile.getIntensity();
        this.field_146289_q.func_78276_b(fluidLevel + "%", 34, 50, 0x404040);
        this.field_146289_q.func_78276_b(intensity + "", 121, 18, 0x404040);
        if (ReactionChamberGui.isInRect(mx, my, 18, 16, 11, 51)) {
            FluidTankInfo info = this.tile.inputTank.getInfo();
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans(info.fluid != null ? info.fluid.getFluid().getUnlocalizedName() : "techguns.gui.empty"));
            tooltip.add(this.tile.inputTank.getFluidAmount() + "/" + info.capacity + "mB");
            this.func_146283_a(tooltip, mx, my);
        } else if (ReactionChamberGui.isInRect(mx, my, 20, 7, 8, 8)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.chemlab.dumpinput"));
            tooltip.add(TextUtil.trans("techguns.chemlab.dumpinput.tooltip"));
            this.func_146283_a(tooltip, mx, my);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int left = 33;
        this.field_146292_n.add(new GuiButtonExt(3, this.field_147003_i + left, this.field_147009_r + 58, 10, 10, "+"));
        this.field_146292_n.add(new GuiButtonExt(4, this.field_147003_i + left + 10, this.field_147009_r + 58, 10, 10, "-"));
        left = 91;
        this.field_146292_n.add(new GuiButtonExt(5, this.field_147003_i + left, this.field_147009_r + 36, 10, 10, "+"));
        this.field_146292_n.add(new GuiButtonExt(6, this.field_147003_i + left + 10, this.field_147009_r + 36, 10, 10, "-"));
        this.field_146292_n.add(new GuiButtonExt(7, this.field_147003_i + 20, this.field_147009_r + 7, 8, 8, "x"));
    }
}

