/*
 * Decompiled with CFR 0.152.
 */
package techguns.events;

import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGConfig;
import techguns.TGPackets;
import techguns.TGRadiationSystem;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.guns.IGenericGun;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.radiation.TGRadiation;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.capabilities.TGExtendedPlayer;
import techguns.capabilities.TGExtendedPlayerClient;
import techguns.capabilities.TGShooterValues;
import techguns.client.ClientProxy;
import techguns.client.audio.TGSoundCategory;
import techguns.client.particle.LightPulse;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.gui.player.TGPlayerInventory;
import techguns.items.additionalslots.ItemGasMask;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.PoweredArmor;
import techguns.items.armors.TGArmorBonus;
import techguns.items.guns.GenericGun;
import techguns.items.guns.GenericGunCharge;
import techguns.packets.PacketPlaySound;
import techguns.packets.PacketShootGun;
import techguns.packets.PacketShootGunTarget;
import techguns.packets.PacketSwapWeapon;
import techguns.packets.PacketTGExtendedPlayerSync;
import techguns.radiation.ItemRadiationData;
import techguns.radiation.ItemRadiationRegistry;
import techguns.util.InventoryUtil;

@Mod.EventBusSubscriber(modid="techguns")
public class TGTickHandler {
    private static final UUID UUID_SPEED = UUID.fromString("5D8E53EB-DCFA-4121-B4DB-99BCAFA6B70B");
    private static final UUID UUID_HEALTH = UUID.fromString("4CFA49EB-D215-498B-9CC9-4BD0D1350B1F");
    private static final UUID UUID_KNOCKBACK_RESISTANCE = UUID.fromString("3441FC5D-F0B6-47F4-AFBB-DC5005670254");
    private static Method ITEMFOOD_onFoodEaten = ObfuscationReflectionHelper.findMethod(ItemFood.class, (String)"func_77849_c", Void.TYPE, (Class[])new Class[]{ItemStack.class, World.class, EntityPlayer.class});

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void localClientPlayerTick(TickEvent.PlayerTickEvent event) {
        ClientProxy cp;
        TGExtendedPlayer props = TGExtendedPlayer.get(event.player);
        if (event.phase == TickEvent.Phase.START && event.player == (cp = ClientProxy.get()).getPlayerClient()) {
            if (Minecraft.func_71410_x().field_71415_G && !event.player.func_175149_v()) {
                IGenericGun gun;
                ItemStack stack = event.player.func_184614_ca();
                ItemStack stackOff = event.player.func_184592_cb();
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGenericGun && ((IGenericGun)stack.func_77973_b()).isShootWithLeftClick()) {
                    if (cp.keyFirePressedMainhand) {
                        gun = (IGenericGun)stack.func_77973_b();
                        if (props.getFireDelay(EnumHand.MAIN_HAND) <= 0) {
                            if (gun instanceof GenericGunCharge && ((GenericGunCharge)gun).getLockOnTicks() > 0 && props.lockOnEntity != null && props.lockOnTicks > ((GenericGunCharge)gun).getLockOnTicks()) {
                                TGPackets.network.sendToServer((IMessage)new PacketShootGunTarget(gun.isZooming(), EnumHand.MAIN_HAND, props.lockOnEntity));
                                gun.shootGunPrimary(stack, event.player.field_70170_p, event.player, gun.isZooming(), EnumHand.MAIN_HAND, props.lockOnEntity);
                            } else {
                                TGPackets.network.sendToServer((IMessage)new PacketShootGun(gun.isZooming(), EnumHand.MAIN_HAND));
                                gun.shootGunPrimary(stack, event.player.field_70170_p, event.player, gun.isZooming(), EnumHand.MAIN_HAND, null);
                            }
                        }
                        if (gun.isSemiAuto()) {
                            cp.keyFirePressedMainhand = false;
                        }
                    }
                } else {
                    cp.keyFirePressedMainhand = false;
                }
                if (!stackOff.func_190926_b() && stackOff.func_77973_b() instanceof IGenericGun && ((IGenericGun)stackOff.func_77973_b()).isShootWithLeftClick()) {
                    if (cp.keyFirePressedOffhand) {
                        gun = (IGenericGun)stackOff.func_77973_b();
                        if (props.getFireDelay(EnumHand.OFF_HAND) <= 0) {
                            TGPackets.network.sendToServer((IMessage)new PacketShootGun(gun.isZooming(), EnumHand.OFF_HAND));
                            gun.shootGunPrimary(stackOff, event.player.field_70170_p, event.player, gun.isZooming(), EnumHand.OFF_HAND, null);
                        }
                        if (gun.isSemiAuto()) {
                            cp.keyFirePressedOffhand = false;
                        }
                    }
                } else {
                    cp.keyFirePressedOffhand = false;
                }
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof GenericGunCharge && ((GenericGunCharge)stack.func_77973_b()).getLockOnTicks() > 0 && ((GenericGunCharge)stack.func_77973_b()).getAmmoLeft(stack) <= 0 && props.lockOnEntity != null) {
                    props.lockOnEntity = null;
                    props.lockOnTicks = -1;
                }
            } else {
                cp.keyFirePressedMainhand = false;
                cp.keyFirePressedOffhand = false;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        TGExtendedPlayer props = TGExtendedPlayer.get(event.player);
        if (event.phase == TickEvent.Phase.START) {
            if (props.fireDelayMainhand > 0) {
                --props.fireDelayMainhand;
            }
            if (props.loopSoundDelayMainhand > 0) {
                --props.loopSoundDelayMainhand;
            }
            if (props.fireDelayOffhand > 0) {
                --props.fireDelayOffhand;
            }
            if (props.loopSoundDelayOffhand > 0) {
                --props.loopSoundDelayOffhand;
            }
            if (event.side == Side.SERVER && props.swingSoundDelay > 0) {
                --props.swingSoundDelay;
            }
        } else if (event.phase == TickEvent.Phase.END) {
            AttributeModifier rad_resist_faceslot;
            IAttributeInstance attributeRadresistance;
            float flightbonus;
            float nightvision;
            AttributeModifier mod_knockback_resistance;
            IAttributeInstance attributeKnockbackResist;
            AttributeModifier mod_health;
            IAttributeInstance attributeMaxHealth;
            AttributeModifier mod_speed;
            IAttributeInstance attributeMovespeed;
            if (!event.player.field_70170_p.field_72995_K) {
                event.player.func_184212_Q().func_187227_b(TGExtendedPlayer.DATA_FACE_SLOT, (Object)props.tg_inventory.func_70301_a(0));
                event.player.func_184212_Q().func_187227_b(TGExtendedPlayer.DATA_BACK_SLOT, (Object)props.tg_inventory.func_70301_a(1));
                event.player.func_184212_Q().func_187227_b(TGExtendedPlayer.DATA_HAND_SLOT, (Object)props.tg_inventory.func_70301_a(2));
            } else {
                props.tg_inventory.func_70299_a(0, (ItemStack)event.player.func_184212_Q().func_187225_a(TGExtendedPlayer.DATA_FACE_SLOT));
                props.tg_inventory.func_70299_a(1, (ItemStack)event.player.func_184212_Q().func_187225_a(TGExtendedPlayer.DATA_BACK_SLOT));
                props.tg_inventory.func_70299_a(2, (ItemStack)event.player.func_184212_Q().func_187225_a(TGExtendedPlayer.DATA_HAND_SLOT));
            }
            boolean wearingTechgunsArmor = false;
            for (int i = 0; i < 4; ++i) {
                ItemStack istack = (ItemStack)event.player.field_71071_by.field_70460_b.get(i);
                if (!GenericArmor.isTechgunArmor(istack)) continue;
                wearingTechgunsArmor = true;
                break;
            }
            if ((attributeMovespeed = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d)) != null && (mod_speed = attributeMovespeed.func_111127_a(UUID_SPEED)) != null) {
                attributeMovespeed.func_111124_b(mod_speed);
            }
            if ((attributeMaxHealth = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a)) != null && (mod_health = attributeMaxHealth.func_111127_a(UUID_HEALTH)) != null) {
                attributeMaxHealth.func_111124_b(mod_health);
            }
            if ((attributeKnockbackResist = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c)) != null && (mod_knockback_resistance = attributeKnockbackResist.func_111127_a(UUID_KNOCKBACK_RESISTANCE)) != null) {
                attributeKnockbackResist.func_111124_b(mod_knockback_resistance);
            }
            float speed = 0.0f;
            if (wearingTechgunsArmor) {
                float knockbackresistance;
                float healthBonus;
                float cooling;
                PoweredArmor.calculateConsumptionTick(event.player);
                if (event.player.func_70027_ad() && (cooling = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.COOLING_SYSTEM, false)) >= 1.0f) {
                    event.player.func_70066_B();
                }
                speed = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.SPEED, false);
                if (event.player.func_70055_a(Material.field_151586_h) || event.player.func_70055_a(Material.field_151587_i)) {
                    speed += GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.SPEED_WATER, false);
                }
                if (speed > 0.0f) {
                    if (event.player.func_70051_ag()) {
                        speed *= 2.0f;
                    }
                    attributeMovespeed.func_111121_a(new AttributeModifier(UUID_SPEED, "TechgunsSpeedboost", (double)speed, 2));
                }
                if ((healthBonus = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.EXTRA_HEART, false)) > 0.0f) {
                    attributeMaxHealth.func_111121_a(new AttributeModifier(UUID_HEALTH, "TechgunsHealthbonus", (double)healthBonus, 0));
                }
                if ((knockbackresistance = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.KNOCKBACK_RESISTANCE, false)) > 0.0f) {
                    attributeKnockbackResist.func_111121_a(new AttributeModifier(UUID_KNOCKBACK_RESISTANCE, "TechgunsKnockbackresistbonus", (double)knockbackresistance, 0));
                }
            } else if (speed > 0.0f) {
                attributeMovespeed.func_111121_a(new AttributeModifier(UUID_SPEED, "TechgunsSpeedboost", (double)speed, 2));
            }
            if (event.player.field_70170_p.field_72995_K && event.player == ClientProxy.get().getPlayerClient()) {
                float stepassist = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.STEPASSIST, false);
                Techguns.proxy.setHasStepassist(stepassist > 0.0f);
                if (props.enableStepAssist && stepassist > 0.0f) {
                    if (event.player.field_70138_W < 1.1f) {
                        event.player.field_70138_W = 1.1f;
                    }
                } else if (event.player.field_70138_W > 0.6f) {
                    event.player.field_70138_W = 0.6f;
                }
            }
            boolean enabled = false;
            if (props != null) {
                enabled = props.enableNightVision;
            }
            Techguns.proxy.setHasNightvision((nightvision = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.NIGHTVISION, enabled)) > 0.0f);
            if (nightvision > 0.0f && enabled && !event.player.field_70170_p.field_72995_K) {
                event.player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 220, 0, false, false));
            }
            if ((flightbonus = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.CREATIVE_FLIGHT, false)) > 0.0f) {
                event.player.field_71075_bZ.field_75101_c = true;
                props.gotCreativeFlightLastTick = true;
                if (event.player.field_71075_bZ.field_75100_b) {
                    if (!props.wasFlying) {
                        if (event.player.field_70170_p.field_72995_K) {
                            Techguns.proxy.createFXOnEntity("AntiGravRing", (Entity)event.player);
                        } else {
                            TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.ANTI_GRAV_START, (Entity)event.player, 1.0f, 1.0f, false, true, false, true, TGSoundCategory.PLAYER_EFFECT), TGPackets.targetPointAroundEnt((Entity)event.player, 50.0));
                        }
                    }
                    props.wasFlying = true;
                } else {
                    props.wasFlying = false;
                }
            } else {
                if (props.gotCreativeFlightLastTick && !event.player.field_71075_bZ.field_75098_d) {
                    event.player.field_71075_bZ.field_75101_c = false;
                    event.player.field_71075_bZ.field_75100_b = false;
                }
                props.gotCreativeFlightLastTick = false;
                props.wasFlying = false;
            }
            if (event.player.field_70170_p.field_72995_K) {
                float DEFAULT_FLYSPEED = 0.05f;
                if (event.player == ClientProxy.get().getPlayerClient()) {
                    float flyspeedBonus = GenericArmor.getArmorBonusForPlayer(event.player, TGArmorBonus.FLYSPEED, false);
                    if (flyspeedBonus > 0.0f) {
                        if (props.enableJetpack) {
                            Techguns.proxy.setFlySpeed((1.0f + flyspeedBonus) * 0.05f);
                        } else {
                            Techguns.proxy.setFlySpeed(0.05f);
                        }
                    } else if (props.gotCreativeFlightLastTick) {
                        Techguns.proxy.setFlySpeed(0.05f);
                    }
                }
            }
            if (!TGConfig.disableAutofeeder && event.player.func_71024_bL().func_75116_a() <= 19 && props != null) {
                int needed = 20 - event.player.func_71024_bL().func_75116_a();
                if (props.foodleft > 0) {
                    if (props.foodleft <= needed) {
                        event.player.func_71024_bL().func_75122_a((int)props.foodleft, props.lastSaturation);
                        props.foodleft = 0;
                        props.lastSaturation = 0.0f;
                    } else {
                        event.player.func_71024_bL().func_75122_a(needed, props.lastSaturation);
                        props.foodleft = (short)(props.foodleft - needed);
                    }
                    if (!event.player.field_70170_p.field_72995_K) {
                        TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(event.player, props, true), (EntityPlayerMP)event.player);
                    }
                } else {
                    TGPlayerInventory cfr_ignored_0 = props.tg_inventory;
                    TGPlayerInventory cfr_ignored_1 = props.tg_inventory;
                    ItemStack stack = InventoryUtil.consumeFood(props.tg_inventory.inventory, 3, 5 + 1);
                    if (!stack.func_190926_b()) {
                        short left;
                        ItemFood food = (ItemFood)stack.func_77973_b();
                        try {
                            ITEMFOOD_onFoodEaten.invoke((Object)food, stack, event.player.field_70170_p, event.player);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        if (!event.player.field_70170_p.field_72995_K) {
                            event.player.field_70170_p.func_184148_a(null, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        if ((left = (short)(food.func_150905_g(stack) - needed)) > 0) {
                            event.player.func_71024_bL().func_75122_a(needed, food.func_150906_h(stack));
                            props.foodleft = left;
                            props.lastSaturation = food.func_150906_h(stack);
                        } else {
                            event.player.func_71024_bL().func_75122_a(food.func_150905_g(stack), food.func_150906_h(stack));
                            props.foodleft = 0;
                            props.lastSaturation = 0.0f;
                        }
                        if (!event.player.field_70170_p.field_72995_K) {
                            TGPackets.network.sendTo((IMessage)new PacketTGExtendedPlayerSync(event.player, props, true), (EntityPlayerMP)event.player);
                        }
                    }
                }
            }
            if ((attributeRadresistance = event.player.func_110140_aT().func_111151_a(TGRadiation.RADIATION_RESISTANCE)) != null && (rad_resist_faceslot = attributeRadresistance.func_111127_a(ItemGasMask.UUID_RAD_RESIST_FACE)) != null) {
                attributeRadresistance.func_111124_b(rad_resist_faceslot);
            }
            props.isGliding = false;
            TGTickHandler.tickSlot((ItemStack)props.tg_inventory.inventory.get(0), event);
            TGTickHandler.tickSlot((ItemStack)props.tg_inventory.inventory.get(1), event);
            TGTickHandler.tickSlot((ItemStack)props.tg_inventory.inventory.get(2), event);
            Techguns.proxy.handlePlayerGliding(event.player);
            if (TGRadiationSystem.isEnabled() && event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 60L == 0L) {
                short maxrad = 0;
                for (ItemStack stack : event.player.field_71071_by.field_70462_a) {
                    ItemRadiationData data;
                    if (stack.func_190926_b() || (data = ItemRadiationRegistry.getRadiationDataFor(stack)) == null || data.radamount <= maxrad) continue;
                    maxrad = data.radamount;
                }
                if (maxrad > 0) {
                    event.player.func_70690_d(new PotionEffect((Potion)TGRadiationSystem.radiation_effect, 60, maxrad - 1, false, false));
                }
            }
            if (event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                if (props.radlevel >= TGRadiationSystem.MINOR_POISONING && props.radlevel < TGRadiationSystem.SEVERE_POISONING) {
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 30, 0, false, false));
                } else if (props.radlevel >= TGRadiationSystem.SEVERE_POISONING) {
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 30, 1, false, false));
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 30, 1, false, false));
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 30, 1, false, false));
                }
                if (props.radlevel >= TGRadiationSystem.LETHAL_POISONING) {
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 30, 1, false, false));
                    event.player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 30, 1, false, false));
                    event.player.func_70097_a((DamageSource)TGDamageSource.causeLethalRadPoisoningDamage(null, null, EntityDeathUtils.DeathType.LASER), 2.0f);
                }
            }
            if (event.side == Side.SERVER) {
                ItemStack gunMH = ItemStack.field_190927_a;
                ItemStack gunOH = ItemStack.field_190927_a;
                if (!event.player.func_184614_ca().func_190926_b() && event.player.func_184614_ca().func_77973_b() instanceof GenericGun) {
                    gunMH = event.player.func_184614_ca();
                }
                if (!event.player.func_184592_cb().func_190926_b() && event.player.func_184592_cb().func_77973_b() instanceof GenericGun) {
                    gunOH = event.player.func_184592_cb();
                }
                if (!gunOH.func_190926_b() && props.gunMainHand == gunOH || !gunMH.func_190926_b() && props.gunOffHand == gunMH) {
                    TGPackets.network.sendToAllAround((IMessage)new PacketSwapWeapon(event.player), TGPackets.targetPointAroundEnt((Entity)event.player, 50.0));
                    int i = props.fireDelayMainhand;
                    props.fireDelayMainhand = props.fireDelayOffhand;
                    props.fireDelayOffhand = i;
                }
                props.gunMainHand = gunMH;
                props.gunOffHand = gunOH;
            }
            if (event.side == Side.SERVER && props.isChargingWeapon() && (event.player.func_184605_cv() <= 0 || !(event.player.func_184614_ca().func_77973_b() instanceof GenericGunCharge))) {
                props.setChargingWeapon(false);
            }
        }
    }

    protected static void tickSlot(ItemStack slot, TickEvent.PlayerTickEvent event) {
        if (!slot.func_190926_b() && slot.func_77973_b() instanceof ITGSpecialSlot) {
            ITGSpecialSlot item = (ITGSpecialSlot)slot.func_77973_b();
            item.onPlayerTick(slot, event);
        }
    }

    @Optional.Method(modid="albedo")
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void clientGameTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator iter = ClientProxy.get().activeLightPulses.iterator();
            while (iter.hasNext()) {
                if (((LightPulse)iter.next()).updateGameTick()) continue;
                iter.remove();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void TickParticleSystems(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientProxy.get().particleManager.tickParticles();
        } else {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            if (w != null) {
                w.func_175644_a(EntityLivingBase.class, (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(EntityLivingBase input) {
                        return input instanceof INPCTechgunsShooter;
                    }
                }).forEach(e -> {
                    TGShooterValues shooter_values = TGShooterValues.get(e);
                    shooter_values.tickParticles();
                });
                w.func_175661_b(EntityPlayer.class, (Predicate)new Predicate<EntityPlayer>(){

                    public boolean apply(EntityPlayer input) {
                        return true;
                    }
                }).forEach(p -> {
                    TGExtendedPlayerClient props = TGExtendedPlayerClient.get(p);
                    props.tickParticles();
                });
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientProxy cp = ClientProxy.get();
            cp.PARTIAL_TICK_TIME = event.renderTickTime;
            EntityPlayer player = cp.getPlayerClient();
            if (player != null) {
                ItemStack current_item = player.func_184614_ca();
                if (current_item != null) {
                    if (current_item.func_77973_b() instanceof IGenericGun) {
                        if (((IGenericGun)current_item.func_77973_b()).isHoldZoom()) {
                            cp.player_zoom = player.func_70093_af() ? ((IGenericGun)current_item.func_77973_b()).getZoomMult() : 1.0f;
                        } else if (!((IGenericGun)current_item.func_77973_b()).isZooming()) {
                            cp.player_zoom = 1.0f;
                        }
                    } else {
                        cp.player_zoom = 1.0f;
                    }
                } else {
                    cp.player_zoom = 1.0f;
                }
            }
        }
    }
}

