/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.spawn;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import techguns.TGConfig;
import techguns.entities.npcs.GenericNPC;
import techguns.entities.spawn.TGNpcSpawn;
import techguns.entities.spawn.TGNpcSpawnTable;
import techguns.util.MathUtil;

public class TGSpawnManager {
    public static TGNpcSpawnTable spawnTableOverworld = new TGNpcSpawnTable(5);
    public static TGNpcSpawnTable spawnTableNether = new TGNpcSpawnTable(5);
    protected static Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSpawn(World w, Entity dummyEnt) {
        GenericNPC entNew = null;
        Biome biome = w.func_180494_b(new BlockPos((double)Math.round(dummyEnt.field_70165_t), 64.0, (double)Math.round(dummyEnt.field_70161_v)));
        int dist_danger = TGSpawnManager.getDistanceDanger(w, dummyEnt);
        int biome_danger = TGSpawnManager.getBiomeDanger(w, dummyEnt, biome);
        int danger = dist_danger + biome_danger;
        TGNpcSpawn chosenSpawn = null;
        TGNpcSpawnTable spawntable = TGSpawnManager.getSpawnTableForDimensionId(w.field_73011_w.getDimension());
        int totalweight = 0;
        for (int d = 0; d <= danger; ++d) {
            ArrayList<TGNpcSpawn> list = spawntable.get(d);
            for (int i = 0; i < list.size(); ++i) {
                TGNpcSpawn spawn = list.get(i);
                totalweight += spawn.getWeightForBiome(biome);
            }
        }
        if (totalweight > 0) {
            int roll = rnd.nextInt(totalweight);
            totalweight = 0;
            for (int d = 0; d <= danger; ++d) {
                ArrayList<TGNpcSpawn> list = spawntable.get(d);
                for (int i = 0; i < list.size(); ++i) {
                    TGNpcSpawn spawn = list.get(i);
                    if ((totalweight += spawn.getWeightForBiome(biome)) < roll) continue;
                    chosenSpawn = spawn;
                    break;
                }
                if (chosenSpawn != null) break;
            }
            if (chosenSpawn != null) {
                try {
                    entNew = chosenSpawn.type.getDeclaredConstructor(World.class).newInstance(w);
                    TGSpawnManager.setPositionsAndReplace(w, entNew, dummyEnt, danger);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                finally {
                    dummyEnt.func_70106_y();
                }
            } else {
                dummyEnt.func_70106_y();
            }
        } else if (dummyEnt != null) {
            dummyEnt.func_70106_y();
        }
    }

    private static int getBiomeDanger(World w, Entity ent, Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            return 0;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 1;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE)) {
            return 1;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            return 1;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 1;
        }
        return 0;
    }

    protected static TGNpcSpawnTable getSpawnTableForDimensionId(int id) {
        switch (id) {
            case -1: {
                return spawnTableNether;
            }
        }
        return spawnTableOverworld;
    }

    private static int getDistanceDanger(World w, Entity ent) {
        MathUtil.Vec2 spawn = new MathUtil.Vec2(w.func_175694_M().func_177958_n(), w.func_175694_M().func_177952_p());
        MathUtil.Vec2 pos = new MathUtil.Vec2(ent.field_70165_t, ent.field_70161_v);
        double distance = spawn.getVecTo(pos).len();
        float factor = 1.0f;
        if (w.field_73011_w.getDimension() == -1) {
            factor = 0.5f;
        }
        if (distance < (double)((float)TGConfig.distanceSpawnLevel0 * factor)) {
            return 0;
        }
        if (distance < (double)((float)TGConfig.distanceSpawnLevel1 * factor)) {
            return 1;
        }
        if (distance < (double)((float)TGConfig.distanceSpawnLevel2 * factor)) {
            return 2;
        }
        return 3;
    }

    public static boolean isInArray(Biome biome, Biome[] biomes) {
        for (int i = 0; i < biomes.length; ++i) {
            if (!biome.equals(biomes[i])) continue;
            return true;
        }
        return false;
    }

    private static void setPositionsAndReplace(World w, GenericNPC newNpc, Entity entity, int difficulty) {
        newNpc.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
        newNpc.onSpawnByManager(difficulty);
        w.func_72838_d((Entity)newNpc);
        entity.func_70106_y();
    }
}

