/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.TGExplosion;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IChargedProjectileFactory;
import techguns.packets.PacketPlaySound;
import techguns.packets.PacketSpawnParticle;
import techguns.util.MathUtil;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TFGProjectile
extends GenericProjectile
implements IEntityAdditionalSpawnData,
ILightProvider {
    public float size = 1.0f;

    public TFGProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, float size) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.size = size;
        this.gravity = gravity;
    }

    public TFGProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, float size) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.size = size;
        this.gravity = gravity;
    }

    public TFGProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        this.explode();
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        this.explode();
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            float exp_dmgMax = this.damage * 0.66f * this.size;
            float exp_dmgMin = this.damage * 0.33f * this.size;
            float exp_r1 = this.size * 1.0f;
            float exp_r2 = this.size * 2.0f;
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("TFGExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.size * 0.75f), TGPackets.targetPointAroundEnt(this, 100.0));
            TGExplosion explosion = new TGExplosion(this.field_70170_p, (Entity)this.shooter, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, exp_dmgMax, exp_dmgMin, exp_r1, exp_r2, this.blockdamage ? 0.5 : 0.0);
            explosion.blockDropChance = 0.1f;
            explosion.doExplosion(false);
            TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.TFG_EXPLOSION, this, 5.0f, 1.0f, false, false, false, TGSoundCategory.EXPLOISON), TGPackets.targetPointAroundEnt(this, 200.0));
            if (this.size > 3.0f) {
                TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.TFG_EXPLOSION_ECHO, this, 10.0f, 1.0f, false, false, false, TGSoundCategory.EXPLOISON), TGPackets.targetPointAroundEnt(this, 200.0));
            }
        } else {
            Techguns.proxy.createLightPulse(this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 15, 5.0f + this.size, 1.0f + this.size * 0.5f, 0.5f, 1.0f, 0.5f);
        }
        this.func_70106_y();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeFloat(this.size);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.size = additionalData.readFloat();
        Techguns.proxy.createFXOnEntity("TFGTrail", this, this.size * 0.75f);
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos(MathUtil.getInterpolatedEntityPos(this)).color(0.5f, 1.0f, 0.5f).radius(2.0f + this.size * 0.5f).build();
    }

    public static class Factory
    implements IChargedProjectileFactory<TFGProjectile> {
        @Override
        public TFGProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return this.createChargedProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, radius, gravity, 0.0f, 1);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.ENERGY;
        }

        @Override
        public TFGProjectile createChargedProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity, float charge, int ammoConsumed) {
            TFGProjectile proj = new TFGProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, gravity, ammoConsumed);
            proj.size = 1.0f + charge * 3.0f;
            if (charge >= 1.0f) {
                proj.size += 1.0f;
            }
            return proj;
        }
    }
}

