/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.TGRadiationSystem;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.damagesystem.TGExplosion;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.RocketProjectile;
import techguns.entities.special.EntityRadiation;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.items.guns.ammo.DamageModifier;
import techguns.packets.PacketSpawnParticle;

public class RocketProjectileNuke
extends RocketProjectile {
    public RocketProjectileNuke(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun, radius, gravity);
    }

    public RocketProjectileNuke(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun, radius, gravity);
    }

    public RocketProjectileNuke(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void explodeRocket() {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("NukeExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), TGPackets.targetPointAroundEnt(this, 150.0));
            TGExplosion explosion = new TGExplosion(this.field_70170_p, (Entity)this.shooter, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.damage, this.damageMin, this.damageDropStart, this.damageDropEnd, this.blockdamage ? 0.5 : 0.0);
            explosion.blockDropChance = 0.05f;
            explosion.setDmgSrc(this.getProjectileDamageSource());
            explosion.doExplosion(false);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, TGSounds.NUKE_EXPLOSION, SoundCategory.BLOCKS, 4.0f, 1.0f);
            if (TGRadiationSystem.isEnabled()) {
                EntityRadiation rad = new EntityRadiation(this, 1200, this.damageDropStart, 9, this.damageDropEnd, 2);
                this.field_70170_p.func_72838_d((Entity)rad);
            }
        } else {
            Techguns.proxy.createLightPulse(this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 80, 80.0f, 1.0f, 1.0f, 0.9f, 0.5f);
        }
        this.func_70106_y();
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource dmgsrc = TGDamageSource.causeExplosionDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        dmgsrc.goreChance = 1.0f;
        dmgsrc.knockbackMultiplier = 3.0f;
        return dmgsrc;
    }

    public static class Factory
    implements IProjectileFactory<RocketProjectileNuke> {
        protected DamageModifier mod = new DamageModifier().setDmg(5.0f, 0.0f).setRadius(5.0f, 0.0f).setRange(5.0f, 0.0f);

        @Override
        public DamageModifier getDamageModifier() {
            return this.mod;
        }

        @Override
        public RocketProjectileNuke createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new RocketProjectileNuke(world, p, this.mod.getDamage(damage), speed, TTL, spread, this.mod.getRange(dmgDropStart), this.mod.getRange(dmgDropEnd), this.mod.getDamage(dmgMin), penetration, blockdamage, firePos, this.mod.getRadius(radius), gravity);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.EXPLOSION;
        }
    }
}

