/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGExplosion;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.IGrenadeProjectileFactory;
import techguns.packets.PacketSpawnParticle;

public class GrenadeProjectile
extends GenericProjectile {
    int bounces = 3;
    protected boolean bounced = false;

    public GrenadeProjectile(World worldIn) {
        super(worldIn);
    }

    public GrenadeProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float damageDropStart, float damageDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, float radius, int bounces) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, damageDropStart, damageDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.bounces = bounces;
        this.gravity = gravity;
        this.radius = radius;
    }

    public GrenadeProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, float radius, int bounces) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.bounces = bounces;
        this.gravity = gravity;
        this.radius = radius;
    }

    public GrenadeProjectile(GrenadeProjectile other, double x, double y, double z) {
        super(other.field_70170_p, x, y, z, other.field_70177_z, other.field_70125_A, other.damage, other.speed, other.ticksToLive, 1.0f, other.damageDropStart, other.damageDropEnd, other.damageMin, other.penetration, other.blockdamage, EnumBulletFirePos.CENTER);
        this.shooter = other.shooter;
        this.bounces = other.bounces - 1;
        this.gravity = other.gravity;
        this.radius = other.radius;
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        if (this.bounces > 0 && !this.bounced) {
            Vec3d refl;
            EnumFacing sideHit = raytraceResultIn.field_178784_b;
            Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            float len = this.getBounceSpeedFactor();
            switch (sideHit) {
                case EAST: 
                case WEST: {
                    refl = new Vec3d(-this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    refl = new Vec3d(this.field_70159_w, this.field_70181_x, -this.field_70179_y);
                    break;
                }
                default: {
                    refl = new Vec3d(this.field_70159_w, -this.field_70181_x, this.field_70179_y);
                }
            }
            this.playBounceSound();
            if (!this.field_70170_p.field_72995_K) {
                GrenadeProjectile gren = this.createBounceProjectile(raytraceResultIn.field_72307_f);
                gren.field_70159_w = refl.field_72450_a * (double)len;
                gren.field_70181_x = refl.field_72448_b * (double)len;
                gren.field_70179_y = refl.field_72449_c * (double)len;
                gren.func_70107_b(gren.field_70165_t + gren.field_70159_w, gren.field_70163_u + gren.field_70181_x, gren.field_70161_v + gren.field_70179_y);
                this.field_70170_p.func_72838_d((Entity)gren);
                this.createProjectileTrail(gren);
            }
            this.bounced = true;
        } else if (this.bounced) {
            this.func_70106_y();
        } else {
            this.explode();
        }
    }

    protected GrenadeProjectile createBounceProjectile(Vec3d hitvec) {
        return new Factory().createBounceProjectile(this, hitvec.field_72450_a, hitvec.field_72448_b, hitvec.field_72449_c);
    }

    protected void playBounceSound() {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187602_cF, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
    }

    protected void createProjectileTrail(GrenadeProjectile gren) {
    }

    protected float getBounceSpeedFactor() {
        return 0.5f;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        this.explode();
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("RocketExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), TGPackets.targetPointAroundEnt(this, 50.0));
            TGExplosion exp = new TGExplosion(this.field_70170_p, (Entity)this.shooter, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.damage, this.damageMin, this.damageDropStart, this.damageDropEnd, 0.0);
            exp.doExplosion(true);
        }
        this.func_70106_y();
    }

    @Override
    protected void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.bounces = tags.func_74771_c("bounces");
        this.bounced = tags.func_74767_n("bounced");
    }

    @Override
    protected void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74774_a("bounces", (byte)this.bounces);
        tags.func_74757_a("bounced", this.bounced);
    }

    public static class Factory
    implements IGrenadeProjectileFactory<GrenadeProjectile> {
        @Override
        public GrenadeProjectile createProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity, float charge, int bounces) {
            return new GrenadeProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun, gravity, radius, bounces);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.EXPLOSION;
        }

        @Override
        public GrenadeProjectile createBounceProjectile(GrenadeProjectile proj, double bounceX, double bounceY, double bounceZ) {
            return new GrenadeProjectile(proj, bounceX, bounceY, bounceZ);
        }
    }
}

