/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.items.guns.ammo.DamageModifier;
import techguns.packets.PacketSpawnParticle;

public class GenericProjectileExplosive
extends GenericProjectile {
    public GenericProjectileExplosive(World worldIn) {
        super(worldIn);
    }

    public GenericProjectileExplosive(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public GenericProjectileExplosive(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeExplosionDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.GORE);
        src.armorPenetration = this.penetration;
        src.goreChance = 1.0f;
        src.knockbackMultiplier = 3.0f;
        return src;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult raytraceResultIn) {
        this.explode(raytraceResultIn.field_72307_f.field_72450_a, raytraceResultIn.field_72307_f.field_72448_b, raytraceResultIn.field_72307_f.field_72449_c);
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        this.explode(raytraceResultIn.field_72307_f.field_72450_a, raytraceResultIn.field_72307_f.field_72448_b, raytraceResultIn.field_72307_f.field_72449_c);
    }

    protected void explode(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("MiningChargeBlockExplosion", x, y, z), TGPackets.targetPointAroundEnt(this, 100.0));
            Explosion exp = new Explosion(this.field_70170_p, (Entity)this, x, y, z, 1.5f, false, this.blockdamage);
            exp.func_77278_a();
            exp.func_77279_a(false);
        } else {
            Techguns.proxy.createLightPulse(x, y, z, 5, 15, 3.0f, 0.5f, 1.0f, 0.9f, 0.5f);
        }
        this.func_70106_y();
    }

    public static class Factory
    implements IProjectileFactory<GenericProjectileExplosive> {
        protected DamageModifier mod = new DamageModifier().setDmg(1.15f, 0.0f);

        @Override
        public DamageModifier getDamageModifier() {
            return this.mod;
        }

        @Override
        public GenericProjectileExplosive createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new GenericProjectileExplosive(world, p, this.mod.getDamage(damage), speed, TTL, spread, dmgDropStart, dmgDropEnd, this.mod.getDamage(dmgMin), penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.EXPLOSION;
        }
    }
}

