/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.client.ClientProxy;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticleOnEntity;
import techguns.util.MathUtil;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class FlamethrowerProjectile
extends GenericProjectile
implements ILightProvider {
    boolean piercing = false;
    float chanceToIgnite = 0.5f;
    int entityIgniteTime = 3;

    public FlamethrowerProjectile(World worldIn) {
        super(worldIn);
        ClientProxy.get().createFXOnEntity("FlamethrowerTrail", this);
    }

    public FlamethrowerProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.gravity = gravity;
    }

    public FlamethrowerProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.gravity = gravity;
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeFireDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.DEFAULT);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        ent.func_70015_d(this.entityIgniteTime);
    }

    @Override
    protected void hitBlock(RayTraceResult mop) {
        if (this.blockdamage) {
            FlamethrowerProjectile.burnBlocks(this.field_70170_p, mop, this.chanceToIgnite);
        }
        Vec3d hitVec = mop.field_72307_f;
        Techguns.proxy.createFX("FlamethrowerImpact", this.field_70170_p, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 0.0, 0.0, 0.0);
    }

    @Override
    protected float inWaterUpdateBehaviour(float f1) {
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.85f;
        }
        if (this.func_70026_G()) {
            this.func_70106_y();
        }
        return f1;
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos(MathUtil.getInterpolatedEntityPos(this)).color(1.0f, 0.8f, 0.0f).radius(2.5f).build();
    }

    public static class Factory
    implements IProjectileFactory<FlamethrowerProjectile> {
        @Override
        public FlamethrowerProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            float offsetX = 0.0f;
            if (firePos == EnumBulletFirePos.RIGHT) {
                offsetX = -0.15f;
            } else if (firePos == EnumBulletFirePos.LEFT) {
                offsetX = 0.15f;
            }
            float offsetY = -0.05f;
            float offsetZ = 0.5f;
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticleOnEntity("FlamethrowerFireFX", (Entity)p, offsetX, offsetY, offsetZ, true), TGPackets.targetPointAroundEnt((Entity)p, 25.0));
            return new FlamethrowerProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, gravity);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.FIRE;
        }
    }
}

