/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGArmors;
import techguns.TGItems;
import techguns.TGuns;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.npc.INpcTGDamageSystem;
import techguns.api.npc.factions.ITGNpcTeam;
import techguns.api.npc.factions.TGNpcFaction;
import techguns.capabilities.TGSpawnerNPCData;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.ai.EntityAIHurtByTargetTGFactions;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.npcs.ITGSpawnerNPC;
import techguns.items.guns.GenericGun;

public class GenericNPC
extends EntityMob
implements IRangedAttackMob,
INPCTechgunsShooter,
INpcTGDamageSystem,
ITGNpcTeam,
ITGSpawnerNPC {
    protected boolean hasAimedBowAnim;
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(GenericNPC.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIRangedAttack aiRangedAttack = null;
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.2, false);
    boolean tryLink = true;
    protected float armor = 0.0f;
    protected float penetrationResistance = 0.0f;

    public GenericNPC(World world) {
        super(world);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTargetTGFactions((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
        this.hasAimedBowAnim = true;
    }

    public boolean getHasAimedBowAnim() {
        return this.hasAimedBowAnim;
    }

    protected GenericGun pickRandomGun(int difficulty) {
        GenericGun gun;
        Random r = new Random();
        switch (r.nextInt(4)) {
            case 0: {
                gun = TGuns.revolver;
                break;
            }
            case 1: {
                gun = TGuns.thompson;
                break;
            }
            case 2: {
                gun = TGuns.as50;
                break;
            }
            case 3: {
                gun = TGuns.grimreaper;
                break;
            }
            default: {
                gun = TGuns.handcannon;
            }
        }
        return gun;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected void func_70628_a(boolean hitByPlayer, int level) {
        int j = this.field_70146_Z.nextInt(3 + level);
        for (int k = 0; k < j; ++k) {
            ItemStack it = this.getRandomItemFromLoottable();
            if (it == null) continue;
            this.func_70099_a(TGItems.newStack(it, it.func_190916_E()), 0.0f);
        }
    }

    protected ItemStack getRandomItemFromLoottable() {
        return null;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.setCombatTask();
        this.func_98053_h(false);
        return livingdata;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int d = Math.round(difficulty.func_180170_c() * 3.0f);
        this.addRandomArmor(d);
    }

    protected void addRandomArmor(int difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)this.pickRandomGun(difficulty)));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)TGArmors.t1_combat_Helmet));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)TGArmors.t1_combat_Chestplate));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)TGArmors.t1_combat_Leggings));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)TGArmors.t1_combat_Boots));
    }

    public void onSpawnByManager(int difficulty) {
        this.func_98053_h(false);
        this.addRandomArmor(difficulty);
        this.setCombatTask();
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiRangedAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() instanceof GenericGun) {
            GenericGun gun = (GenericGun)itemstack.func_77973_b();
            this.aiRangedAttack = gun.getAIAttack(this);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiRangedAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        if (this.func_184614_ca() == null) {
            return;
        }
        Item gun = this.func_184614_ca().func_77973_b();
        if (gun instanceof GenericGun) {
            EnumDifficulty difficulty = this.field_70170_p.func_175659_aa();
            float acc = 1.0f;
            float dmg = 1.0f;
            switch (difficulty) {
                case EASY: {
                    acc = 1.3f;
                    dmg = 0.6f;
                    break;
                }
                case NORMAL: {
                    acc = 1.15f;
                    dmg = 0.8f;
                    break;
                }
                case HARD: {
                    acc = 1.0f;
                    dmg = 1.0f;
                    break;
                }
            }
            ((GenericGun)gun).fireWeaponFromNPC((EntityLivingBase)this, dmg, acc);
        }
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setCombatTask();
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }

    @Override
    public float getWeaponPosX() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosY() {
        return 0.0f;
    }

    @Override
    public float getWeaponPosZ() {
        return 0.0f;
    }

    protected void setTGArmorStats(float armor, float penetrationResistance) {
        this.armor = armor;
        this.penetrationResistance = penetrationResistance;
    }

    @Override
    public float getTotalArmorAgainstType(TGDamageSource dmgsrc) {
        return DamageSystem.getArmorAgainstDamageTypeDefault((EntityLivingBase)this, this.armor, dmgsrc.field_76373_n);
    }

    @Override
    public float getPenetrationResistance(TGDamageSource dmgsrc) {
        return this.penetrationResistance;
    }

    @Override
    public TGNpcFaction getTGFaction() {
        return TGNpcFaction.HOSTILE;
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        this.despawnEntitySpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.onDeathSpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onUpdateSpawner(this.field_70170_p);
    }

    @Override
    public boolean getTryLink() {
        return this.tryLink;
    }

    @Override
    public void setTryLink(boolean value) {
        this.tryLink = value;
    }

    @Override
    public TGSpawnerNPCData getCapability(Capability<TGSpawnerNPCData> tgGenericnpcData) {
        return (TGSpawnerNPCData)this.getCapability(tgGenericnpcData, null);
    }
}

