/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.npcs;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.npc.INpcTGDamageSystem;
import techguns.capabilities.TGSpawnerNPCData;
import techguns.entities.npcs.ITGSpawnerNPC;
import techguns.util.MathUtil;

public abstract class GenericFlyingMob
extends EntityFlying
implements IMob,
INpcTGDamageSystem,
INPCTechgunsShooter,
ITGSpawnerNPC {
    protected boolean tryLink = true;

    public GenericFlyingMob(World worldIn) {
        super(worldIn);
    }

    @Override
    public boolean getTryLink() {
        return this.tryLink;
    }

    @Override
    public void setTryLink(boolean value) {
        this.tryLink = value;
    }

    @Override
    public TGSpawnerNPCData getCapability(Capability<TGSpawnerNPCData> tgGenericnpcData) {
        return (TGSpawnerNPCData)this.getCapability(tgGenericnpcData, null);
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
        this.despawnEntitySpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.onDeathSpawner(this.field_70170_p, this.field_70729_aU);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.onUpdateSpawner(this.field_70170_p);
    }

    protected abstract int getTargetFlyHeight();

    protected static class FlyingMobMoveHelper
    extends EntityMoveHelper {
        private final GenericFlyingMob parentEntity;
        private int courseChangeCooldown = 0;

        public FlyingMobMoveHelper(GenericFlyingMob mob) {
            super((EntityLiving)mob);
            this.parentEntity = mob;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    protected static class AIRandomFly
    extends EntityAIBase {
        private final GenericFlyingMob parentEntity;

        public AIRandomFly(GenericFlyingMob mob) {
            this.parentEntity = mob;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, (double)(this.getGroundLevel(this.parentEntity) + this.parentEntity.getTargetFlyHeight()), d2, 1.0);
        }

        private int getGroundLevel(GenericFlyingMob entity) {
            return entity.field_70170_p.func_189649_b((int)entity.field_70165_t, (int)entity.field_70161_v);
        }
    }

    protected static class AILookAround
    extends EntityAIBase {
        private final GenericFlyingMob parentEntity;

        public AILookAround(GenericFlyingMob mob) {
            this.parentEntity = mob;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
                this.parentEntity.field_70125_A = 0.0f;
            } else {
                EntityLivingBase target = this.parentEntity.func_70638_az();
                double d0 = 96.0;
                if (target.func_70068_e((Entity)this.parentEntity) < 9216.0) {
                    double d1 = target.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = target.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                    Vec3d pos = new Vec3d(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v);
                    Vec3d target_pos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                    Vec3d groundPoint = new Vec3d(pos.field_72450_a, target_pos.field_72448_b, pos.field_72449_c);
                    if (pos.field_72448_b > groundPoint.field_72448_b) {
                        Vec3d toTarget = target_pos.func_178788_d(pos).func_72432_b();
                        Vec3d toGround = groundPoint.func_178788_d(pos).func_72432_b();
                        float acos = (float)(Math.acos(toTarget.func_72430_b(toGround)) * 57.29577951308232);
                        float angle = -MathUtil.clamp(90.0f - acos, 0.0f, 90.0f);
                        this.parentEntity.func_70671_ap().func_75651_a((Entity)target, 45.0f, angle);
                    }
                }
            }
        }
    }
}

