/*
 * Decompiled with CFR 0.152.
 */
package techguns.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import techguns.core.CustomClassWriter;

public class TechgunsASMTransformer
implements IClassTransformer {
    protected static List classesToPatch = Arrays.asList("net.minecraft.client.renderer.RenderItem", "net.minecraft.client.renderer.entity.RenderEntityItem", "net.minecraft.client.renderer.ItemRenderer");
    protected static HashMap<String, String> mappings_obf = new HashMap();
    protected static HashMap<String, String> mappings_deobf = new HashMap();
    protected static final String ITEMRENDERHACK = "techguns/client/render/ItemRenderHack";

    private static void addMapping(String key, String obf, String deobf) {
        mappings_obf.put(key, obf);
        mappings_deobf.put(key, deobf);
    }

    private static String getMapping(String key, boolean deobf) {
        return mappings_deobf.get(key);
    }

    private static String getHookSignature(boolean deobf) {
        return "(L" + TechgunsASMTransformer.getMapping("ItemStack", deobf) + ";L" + TechgunsASMTransformer.getMapping("ELB", deobf) + ";L" + TechgunsASMTransformer.getMapping("TransformType", deobf) + ";Z)Z";
    }

    private static String getHookSignature2(boolean deobf) {
        return "()F";
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        int index = classesToPatch.indexOf(transformedName);
        if (index != -1) {
            boolean deobf = name.equals(transformedName);
            try {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                switch (index) {
                    case 0: {
                        this.patchRenderItem(classNode, deobf);
                        break;
                    }
                    case 1: {
                        this.patchRenderEntityItem(classNode, deobf);
                        break;
                    }
                    case 2: {
                        this.patchItemRenderer(classNode, deobf);
                    }
                }
                CustomClassWriter classWriter = new CustomClassWriter(3);
                classNode.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return basicClass;
    }

    protected void patchRenderEntityItem(ClassNode classNode, boolean deobf) {
        String targetMethodName = deobf ? "doRender" : "func_76986_a";
        String signature = "(L" + TechgunsASMTransformer.getMapping("EntityItem", deobf) + ";DDDFF)V";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(targetMethodName) || !m.desc.equals(signature)) continue;
            AbstractInsnNode targetNode = null;
            AbstractInsnNode targetNode2 = null;
            for (AbstractInsnNode instruction : m.instructions.toArray()) {
                if (instruction.getOpcode() != 182) continue;
                targetNode = instruction;
                if (instruction.getPrevious() == null || instruction.getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious()).var != 17 || instruction.getPrevious().getPrevious() == null || instruction.getPrevious().getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious().getPrevious()).var != 10) continue;
                targetNode2 = instruction.getPrevious().getPrevious().getPrevious().getPrevious();
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 10));
                toInsert.add((AbstractInsnNode)new InsnNode(1));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(178, TechgunsASMTransformer.getMapping("TransformType", deobf), TechgunsASMTransformer.getMapping("GROUND", deobf), "L" + TechgunsASMTransformer.getMapping("TransformType", deobf) + ";"));
                toInsert.add((AbstractInsnNode)new InsnNode(3));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "renderItem", TechgunsASMTransformer.getHookSignature(deobf), false));
                LabelNode labelNode1 = new LabelNode();
                toInsert.add((AbstractInsnNode)new JumpInsnNode(154, labelNode1));
                m.instructions.insertBefore(targetNode2, toInsert);
                m.instructions.insert(targetNode, (AbstractInsnNode)labelNode1);
                System.out.println("Successfully patched RenderEntityItem with ASM");
            }
        }
    }

    protected void patchRenderItem(ClassNode classNode, boolean deobf) {
        String targetMethodName = deobf ? "renderItem" : "func_184392_a";
        String targetMethodName2 = deobf ? "renderModel" : "func_191961_a";
        String targetMethodNameGui = deobf ? "renderItemModelIntoGUI" : "func_191962_a";
        String itemStackName = "L" + TechgunsASMTransformer.getMapping("ItemStack", deobf);
        String camTransformTypeName = "L" + TechgunsASMTransformer.getMapping("TransformType", deobf);
        String signature = "(" + itemStackName + ";L" + TechgunsASMTransformer.getMapping("ELB", deobf) + ";" + camTransformTypeName + ";Z)V";
        String signature2 = "(" + itemStackName + ";" + camTransformTypeName + ";)V";
        String signature_renderModel = "(L" + TechgunsASMTransformer.getMapping("IBakedModel", deobf) + ";" + itemStackName + ";)V";
        String signature3 = "(" + itemStackName + ";IIL" + TechgunsASMTransformer.getMapping("IBakedModel", deobf) + ";)V";
        for (MethodNode m : classNode.methods) {
            if (m.name.equals(targetMethodName) && m.desc.equals(signature)) {
                TechgunsASMTransformer.patchRenderItem_patchMethodRenderItem(m, deobf);
            }
            if (m.name.equals(targetMethodName) && m.desc.equals(signature2)) {
                TechgunsASMTransformer.patchRenderItem_patchMethodRenderItem2(m, deobf);
            }
            if (m.name.equals(targetMethodNameGui) && m.desc.equals(signature3)) {
                TechgunsASMTransformer.patchRenderItem_patchMethodRenderItemGUI(m, deobf);
            }
            if (!m.name.equals(targetMethodName2) || !m.desc.equals(signature_renderModel)) continue;
            TechgunsASMTransformer.patchRenderItem_patchMethodRenderModel(m, deobf);
        }
    }

    protected void patchItemRenderer(ClassNode classNode, boolean deobf) {
        String targetMethodName1 = deobf ? "updateEquippedItem" : "func_78441_a";
        String signature1 = "()V";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(targetMethodName1) || !m.desc.equals(signature1)) continue;
            TechgunsASMTransformer.patchItemRenderer_updateEquippedItem(m, deobf);
        }
    }

    protected static void patchRenderItem_patchMethodRenderItem(MethodNode method, boolean deobf) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 1 || instruction.getNext().getOpcode() != 182) continue;
            targetNode = instruction;
            break;
        }
        AbstractInsnNode targetNode2 = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 21 || ((VarInsnNode)instruction).var != 4 || instruction.getNext().getOpcode() != 182) continue;
            targetNode2 = instruction.getNext();
            break;
        }
        if (targetNode != null && targetNode2 != null) {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new VarInsnNode(21, 4));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "renderItem", TechgunsASMTransformer.getHookSignature(deobf), false));
            LabelNode labelNode1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(154, labelNode1));
            method.instructions.insertBefore(targetNode, toInsert);
            method.instructions.insert(targetNode2, (AbstractInsnNode)labelNode1);
            System.out.println("Successfully patched 4 arg RenderItem.RenderItem with ASM");
        } else {
            System.out.println("Error Patching RenderItem.RenderItem (4args) with ASM");
        }
    }

    protected static void patchRenderItem_patchMethodRenderItem2(MethodNode method, boolean deobf) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 1 || instruction.getNext().getOpcode() != 182) continue;
            targetNode = instruction;
            break;
        }
        AbstractInsnNode targetNode2 = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 3 || instruction.getNext().getOpcode() != 182) continue;
            targetNode2 = instruction.getNext();
            break;
        }
        if (targetNode != null && targetNode2 != null) {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new InsnNode(1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new InsnNode(3));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "renderItem", TechgunsASMTransformer.getHookSignature(deobf), false));
            LabelNode labelNode1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(154, labelNode1));
            method.instructions.insertBefore(targetNode, toInsert);
            method.instructions.insert(targetNode2, (AbstractInsnNode)labelNode1);
            System.out.println("Successfully patched 2 arg RenderItem.RenderItem with ASM");
        } else {
            System.out.println("Error Patching RenderItem.RenderItem (2 args) with ASM");
        }
    }

    protected static void patchRenderItem_patchMethodRenderItemGUI(MethodNode method, boolean deobf) {
        AbstractInsnNode targetNode = null;
        AbstractInsnNode targetNode2 = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 182) continue;
            targetNode = instruction;
            if (instruction.getPrevious() == null || instruction.getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious()).var != 4 || instruction.getPrevious().getPrevious() == null || instruction.getPrevious().getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious().getPrevious()).var != 1 || instruction.getPrevious().getPrevious().getPrevious() == null || instruction.getPrevious().getPrevious().getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious().getPrevious().getPrevious()).var != 0) continue;
            targetNode2 = instruction.getPrevious().getPrevious().getPrevious();
            break;
        }
        if (targetNode != null && targetNode2 != null) {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new InsnNode(1));
            toInsert.add((AbstractInsnNode)new FieldInsnNode(178, TechgunsASMTransformer.getMapping("TransformType", deobf), TechgunsASMTransformer.getMapping("GUI", deobf), "L" + TechgunsASMTransformer.getMapping("TransformType", deobf) + ";"));
            toInsert.add((AbstractInsnNode)new InsnNode(3));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "renderItem", TechgunsASMTransformer.getHookSignature(deobf), false));
            LabelNode labelNode1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(154, labelNode1));
            method.instructions.insertBefore(targetNode2, toInsert);
            method.instructions.insert(targetNode, (AbstractInsnNode)labelNode1);
            System.out.println("Successfully patched RenderItem.renderItemModelIntoGUI with ASM");
        } else {
            System.out.println("Error Patching RenderItem.renderItemModelIntoGUI with ASM");
        }
    }

    protected static void patchRenderItem_patchMethodRenderModel(MethodNode method, boolean deobf) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 0 || instruction.getNext().getOpcode() != 25 || ((VarInsnNode)instruction.getNext()).var != 1) continue;
            targetNode = instruction;
            break;
        }
        AbstractInsnNode targetNode2 = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 25 || ((VarInsnNode)instruction).var != 2 || instruction.getNext().getOpcode() != 183) continue;
            targetNode2 = instruction.getNext();
            break;
        }
        if (targetNode != null && targetNode2 != null) {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new InsnNode(1));
            toInsert.add((AbstractInsnNode)new FieldInsnNode(178, TechgunsASMTransformer.getMapping("TransformType", deobf), TechgunsASMTransformer.getMapping("GUI", deobf), "L" + TechgunsASMTransformer.getMapping("TransformType", deobf) + ";"));
            toInsert.add((AbstractInsnNode)new InsnNode(4));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "renderItem", TechgunsASMTransformer.getHookSignature(deobf), false));
            LabelNode labelNode1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(154, labelNode1));
            method.instructions.insertBefore(targetNode, toInsert);
            method.instructions.insert(targetNode2, (AbstractInsnNode)labelNode1);
            System.out.println("Successfully patched 2 arg RenderItem.RenderModel with ASM");
        } else {
            System.out.println("Error Patching RenderItem.RenderModel (2 args) with ASM");
        }
    }

    protected static void patchItemRenderer_updateEquippedItem(MethodNode method, boolean deobf) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 56 || ((VarInsnNode)instruction).var != 4 || instruction.getPrevious() == null || instruction.getPrevious().getOpcode() != 182 || instruction.getPrevious().getPrevious() == null || instruction.getPrevious().getPrevious().getOpcode() != 12 || instruction.getPrevious().getPrevious().getPrevious() == null || instruction.getPrevious().getPrevious().getPrevious().getOpcode() != 25 || ((VarInsnNode)instruction.getPrevious().getPrevious().getPrevious()).var != 1) continue;
            targetNode = instruction;
            break;
        }
        if (targetNode != null) {
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, ITEMRENDERHACK, "getAttackStrengthForRendering", TechgunsASMTransformer.getHookSignature2(deobf), false));
            toInsert.add((AbstractInsnNode)new VarInsnNode(56, 4));
            method.instructions.insert(targetNode, toInsert);
            System.out.println("Successfully patched ItemRenderer.updateEquippedItem with ASM");
        } else {
            System.out.println("Error Patching ItemRenderer.updateEquippedItem with ASM");
        }
    }

    static {
        TechgunsASMTransformer.addMapping("TransformType", "bwa$b", "net/minecraft/client/renderer/block/model/ItemCameraTransforms$TransformType");
        TechgunsASMTransformer.addMapping("EntityItem", "acj", "net/minecraft/entity/item/EntityItem");
        TechgunsASMTransformer.addMapping("ItemStack", "ain", "net/minecraft/item/ItemStack");
        TechgunsASMTransformer.addMapping("ELB", "vn", "net/minecraft/entity/EntityLivingBase");
        TechgunsASMTransformer.addMapping("IBakedModel", "cfw", "net/minecraft/client/renderer/block/model/IBakedModel");
        TechgunsASMTransformer.addMapping("GUI", "g", "GUI");
        TechgunsASMTransformer.addMapping("GROUND", "h", "GROUND");
        TechgunsASMTransformer.addMapping("EntityPlayer", "aeb", "net/minecraft/entity/player/EntityPlayer");
    }
}

