/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.tileentities;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import techguns.api.render.IItemTGRenderer;
import techguns.items.guns.GenericGun;
import techguns.tileentities.GrinderTileEnt;

public class RenderGrinder
extends TileEntitySpecialRenderer<GrinderTileEnt> {
    protected ResourceLocation texture = new ResourceLocation("techguns", "textures/blocks/grinder_roll.png");
    protected static final double UNIT = 0.0625;
    protected static final float TEX_X = 0.125f;
    protected static final float TEX_Z = 0.125f;
    protected static double len = 0.75;

    public void render(GrinderTileEnt te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float rot = 45.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (te.isWorking()) {
            rot = (45.0f + 1080.0f * te.getProgress()) % 360.0f;
        }
        GlStateManager.func_179094_E();
        IBlockState bs = te.func_145831_w().func_180495_p(te.func_174877_v());
        EnumFacing f = (EnumFacing)bs.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        GlStateManager.func_179114_b((float)f.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
        switch (f) {
            case NORTH: {
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.46875, (double)0.40625);
        buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        GlStateManager.func_179114_b((float)rot, (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawGrinderRoll(buf, 1.5f, 2.0f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.46875, (double)0.59375);
        buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        GlStateManager.func_179114_b((float)(-rot), (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawGrinderRoll(buf, 1.5f, 2.0f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
        ItemStack item = ItemStack.field_190927_a;
        if (te.isWorking() && !(item = te.currentOperation.getItemInputI(0)).func_190926_b()) {
            boolean is3d = false;
            boolean rot90 = false;
            if (item.func_77973_b() instanceof IItemTGRenderer) {
                is3d = ((IItemTGRenderer)item.func_77973_b()).shouldUseRenderHack(item);
                if (item.func_77973_b() instanceof GenericGun) {
                    rot90 = true;
                }
            }
            double px = 0.5;
            double py = 0.6 - (double)te.getProgress() * 0.4 + (is3d ? 0.15 : 0.0);
            double pz = 0.5;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)px, (double)py, (double)pz);
            if (is3d) {
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            }
            if (rot90) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            Minecraft.func_71410_x().func_175599_af().func_181564_a(item, ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    protected void drawGrinderRoll(BufferBuilder buf, float r, float dx) {
        double d = 2.0f * r;
        r = (float)(0.0625 * (double)r);
        buf.func_181662_b((double)dx * 0.0625, (double)r, (double)(-r)).func_187315_a(0.125, 0.125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)r, (double)r).func_187315_a(0.125, 0.125 + d * 0.0625).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)r, (double)r).func_187315_a(0.125 + len, 0.125 + d * 0.0625).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)r, (double)(-r)).func_187315_a(0.125 + len, 0.125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)r, (double)r).func_187315_a(0.125, 0.125).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)(-r), (double)r).func_187315_a(0.125, 0.125 + d * 0.0625).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)(-r), (double)r).func_187315_a(0.125 + len, 0.125 + d * 0.0625).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)r, (double)r).func_187315_a(0.125 + len, 0.125).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)(-r), (double)(-r)).func_187315_a(0.125, 0.125 + d * 0.0625).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)(-r), (double)(-r)).func_187315_a(0.125 + len, 0.125 + d * 0.0625).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)(-r), (double)r).func_187315_a(0.125 + len, 0.125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)(-r), (double)r).func_187315_a(0.125, 0.125).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)r, (double)(-r)).func_187315_a(0.125, 0.125 + d * 0.0625).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)r, (double)(-r)).func_187315_a(0.125 + len, 0.125 + d * 0.0625).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625 + len, (double)(-r), (double)(-r)).func_187315_a(0.125 + len, 0.125).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        buf.func_181662_b((double)dx * 0.0625, (double)(-r), (double)(-r)).func_187315_a(0.125, 0.125).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

