/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.tileentities;

import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import techguns.TGBlocks;
import techguns.blocks.BlockTGDoor3x3;
import techguns.blocks.EnumDoorState;
import techguns.tileentities.Door3x3TileEntity;

public class RenderDoor3x3Fast
extends FastTESR<Door3x3TileEntity> {
    protected static BlockRendererDispatcher blockRenderer;
    protected static final ResourceLocation door_left_loc;
    protected static final ResourceLocation door_right_loc;
    protected static final ResourceLocation hangar_up_mid_loc;
    protected static final ResourceLocation hangar_up_mid2_loc;
    protected static final ResourceLocation hangar_up_mid3_loc;
    protected static final ResourceLocation hangar_up_lower_loc;
    protected static final ResourceLocation hangar_down_upper_loc;
    protected static final TRSRTransformation rot90;
    protected static IBakedModel doorsegment_l;
    protected static IBakedModel doorsegment_l_90;
    protected static IBakedModel doorsegment_r;
    protected static IBakedModel doorsegment_r_90;
    protected static IBakedModel hangar_up_mid;
    protected static IBakedModel hangar_up_mid_90;
    protected static IBakedModel hangar_up_mid2;
    protected static IBakedModel hangar_up_mid2_90;
    protected static IBakedModel hangar_up_mid3;
    protected static IBakedModel hangar_up_mid3_90;
    protected static IBakedModel hangar_up_lower;
    protected static IBakedModel hangar_up_lower_90;
    protected static IBakedModel hangar_down_upper;
    protected static IBakedModel hangar_down_upper_90;

    public static IBakedModel loadBakedModel(ResourceLocation model_loc, IModelState transform) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)model_loc, (String)("Could not load model:" + model_loc.toString()));
        return model.bake(transform, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
    }

    public static void stitchTextures(TextureMap map) {
        map.func_174942_a(new ResourceLocation("techguns", "blocks/techdoor3x3"));
        map.func_174942_a(new ResourceLocation("techguns", "blocks/hangar_door"));
    }

    public static void initModels() {
        doorsegment_l = RenderDoor3x3Fast.loadBakedModel(door_left_loc, (IModelState)TRSRTransformation.identity());
        doorsegment_l_90 = RenderDoor3x3Fast.loadBakedModel(door_left_loc, (IModelState)rot90);
        doorsegment_r = RenderDoor3x3Fast.loadBakedModel(door_right_loc, (IModelState)TRSRTransformation.identity());
        doorsegment_r_90 = RenderDoor3x3Fast.loadBakedModel(door_right_loc, (IModelState)rot90);
        hangar_up_mid = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid_loc, (IModelState)TRSRTransformation.identity());
        hangar_up_mid_90 = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid_loc, (IModelState)rot90);
        hangar_up_mid2 = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid2_loc, (IModelState)TRSRTransformation.identity());
        hangar_up_mid2_90 = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid2_loc, (IModelState)rot90);
        hangar_up_mid3 = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid3_loc, (IModelState)TRSRTransformation.identity());
        hangar_up_mid3_90 = RenderDoor3x3Fast.loadBakedModel(hangar_up_mid3_loc, (IModelState)rot90);
        hangar_up_lower = RenderDoor3x3Fast.loadBakedModel(hangar_up_lower_loc, (IModelState)TRSRTransformation.identity());
        hangar_up_lower_90 = RenderDoor3x3Fast.loadBakedModel(hangar_up_lower_loc, (IModelState)rot90);
        hangar_down_upper = RenderDoor3x3Fast.loadBakedModel(hangar_down_upper_loc, (IModelState)TRSRTransformation.identity());
        hangar_down_upper_90 = RenderDoor3x3Fast.loadBakedModel(hangar_down_upper_loc, (IModelState)rot90);
    }

    public void renderTileEntityFast(Door3x3TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        if (te == null) {
            return;
        }
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != TGBlocks.DOOR3x3) {
            return;
        }
        if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.OPENED || state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.CLOSED) {
            return;
        }
        double px = x - (double)pos.func_177958_n();
        double py = y - (double)pos.func_177956_o();
        double pz = z - (double)pos.func_177952_p();
        long timestamp = te.getLastStateChangeTime();
        long diff = System.currentTimeMillis() - timestamp;
        float prog = 0.0f;
        if (diff < 1000L) {
            prog = (float)diff / 1000.0f;
        }
        boolean zplane = (Boolean)state.func_177229_b((IProperty)BlockTGDoor3x3.ZPLANE);
        switch (te.getDoorType()) {
            case 0: {
                this.renderDoor0((IBlockAccess)world, state, buffer, pos, zplane, px, py, pz, prog);
                break;
            }
            case 1: {
                this.renderDoor1((IBlockAccess)world, state, buffer, pos, zplane, px, py, pz, prog);
                break;
            }
            case 2: {
                this.renderDoor2((IBlockAccess)world, state, buffer, pos, zplane, px, py, pz, prog);
            }
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    protected void renderDoor0(IBlockAccess world, IBlockState state, BufferBuilder buffer, BlockPos pos, boolean zplane, double px, double py, double pz, float prog) {
        IBakedModel model_seg1 = doorsegment_l;
        IBakedModel model_seg2 = doorsegment_r;
        boolean dx = true;
        boolean dz = false;
        if (zplane) {
            model_seg1 = doorsegment_l_90;
            model_seg2 = doorsegment_r_90;
            pz += 1.0;
            dx = false;
            dz = true;
        }
        buffer.func_178969_c(px, py, pz);
        double distance = 1.125;
        if (prog == 0.0f) {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.OPENING) {
                buffer.func_178969_c(px - (double)dx * distance, py, pz + (double)dz * distance);
                blockRenderer.func_175019_b().func_178267_a(world, model_seg1, state, pos, buffer, true);
                buffer.func_178969_c(px + (double)dx * distance, py, pz - (double)dz * distance);
                blockRenderer.func_175019_b().func_178267_a(world, model_seg2, state, pos, buffer, true);
            } else {
                blockRenderer.func_175019_b().func_178267_a(world, model_seg1, state, pos, buffer, true);
                blockRenderer.func_175019_b().func_178267_a(world, model_seg2, state, pos, buffer, true);
            }
        } else {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.CLOSING) {
                prog = 1.0f - prog;
            }
            buffer.func_178969_c(px - (double)dx * distance * (double)prog, py, pz + (double)dz * distance * (double)prog);
            blockRenderer.func_175019_b().func_178267_a(world, model_seg1, state, pos, buffer, true);
            buffer.func_178969_c(px + (double)dx * distance * (double)prog, py, pz - (double)dz * distance * (double)prog);
            blockRenderer.func_175019_b().func_178267_a(world, model_seg2, state, pos, buffer, true);
        }
    }

    protected void renderDoor1(IBlockAccess world, IBlockState state, BufferBuilder buffer, BlockPos pos, boolean zplane, double px, double py, double pz, float prog) {
        IBakedModel model_segment = hangar_up_mid;
        IBakedModel model_segment2 = hangar_up_mid2;
        IBakedModel model_segment3 = hangar_up_mid3;
        IBakedModel model_lower = hangar_up_lower;
        boolean dx = true;
        boolean dz = false;
        if (zplane) {
            model_segment = hangar_up_mid_90;
            model_segment2 = hangar_up_mid2_90;
            model_segment3 = hangar_up_mid3_90;
            model_lower = hangar_up_lower_90;
            pz += 1.0;
            dx = false;
            dz = true;
        }
        buffer.func_178969_c(px, py, pz);
        if (prog == 0.0f) {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.OPENING) {
                buffer.func_178969_c(px, py + 3.0, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_lower, state, pos, buffer, false);
            } else {
                blockRenderer.func_175019_b().func_178267_a(world, model_lower, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment2, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment3, state, pos, buffer, false);
            }
        } else {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.CLOSING) {
                prog = 1.0f - prog;
            }
            double dist = (double)prog * 3.0;
            buffer.func_178969_c(px, py + dist, pz);
            blockRenderer.func_175019_b().func_178267_a(world, model_lower, state, pos, buffer, false);
            blockRenderer.func_175019_b().func_178267_a(world, model_segment, state, pos, buffer, false);
            if (dist <= 2.0) {
                buffer.func_178969_c(px, py + dist, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment2, state, pos, buffer, false);
            }
            if (dist <= 1.0) {
                buffer.func_178969_c(px, py + dist, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment3, state, pos, buffer, false);
            }
        }
    }

    protected void renderDoor2(IBlockAccess world, IBlockState state, BufferBuilder buffer, BlockPos pos, boolean zplane, double px, double py, double pz, float prog) {
        IBakedModel model_segment = hangar_up_mid;
        IBakedModel model_segment2 = hangar_up_mid2;
        IBakedModel model_segment3 = hangar_up_mid3;
        IBakedModel model_upper = hangar_down_upper;
        boolean dx = true;
        boolean dz = false;
        if (zplane) {
            model_segment = hangar_up_mid_90;
            model_segment2 = hangar_up_mid2_90;
            model_segment3 = hangar_up_mid3_90;
            model_upper = hangar_down_upper_90;
            pz += 1.0;
            dx = false;
            dz = true;
        }
        buffer.func_178969_c(px, py, pz);
        if (prog == 0.0f) {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.OPENING) {
                buffer.func_178969_c(px, py - 3.0, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_upper, state, pos, buffer, false);
            } else {
                blockRenderer.func_175019_b().func_178267_a(world, model_upper, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment2, state, pos, buffer, false);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment3, state, pos, buffer, false);
            }
        } else {
            if (state.func_177229_b(BlockTGDoor3x3.STATE) == EnumDoorState.CLOSING) {
                prog = 1.0f - prog;
            }
            double dist = (double)prog * 3.0;
            buffer.func_178969_c(px, py - dist, pz);
            blockRenderer.func_175019_b().func_178267_a(world, model_upper, state, pos, buffer, false);
            blockRenderer.func_175019_b().func_178267_a(world, model_segment3, state, pos, buffer, false);
            if (dist <= 2.0) {
                buffer.func_178969_c(px, py - dist, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment2, state, pos, buffer, false);
            }
            if (dist <= 1.0) {
                buffer.func_178969_c(px, py - dist, pz);
                blockRenderer.func_175019_b().func_178267_a(world, model_segment, state, pos, buffer, false);
            }
        }
    }

    static {
        door_left_loc = new ResourceLocation("techguns", "block/techdoor3x3_left");
        door_right_loc = new ResourceLocation("techguns", "block/techdoor3x3_right");
        hangar_up_mid_loc = new ResourceLocation("techguns", "block/hangar_door_mid1j");
        hangar_up_mid2_loc = new ResourceLocation("techguns", "block/hangar_door_mid2j");
        hangar_up_mid3_loc = new ResourceLocation("techguns", "block/hangar_door_mid3j");
        hangar_up_lower_loc = new ResourceLocation("techguns", "block/hangar_door_lower.obj");
        hangar_down_upper_loc = new ResourceLocation("techguns", "block/hangar_door_down_upper.obj");
        Matrix4f rot = new Matrix4f();
        rot.rotY(1.5707964f);
        rot90 = new TRSRTransformation(rot);
    }
}

