/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import techguns.api.npc.INPCTechgunsShooter;
import techguns.api.render.IItemRenderer;
import techguns.capabilities.TGExtendedPlayerClient;
import techguns.capabilities.TGShooterValues;
import techguns.client.ClientProxy;
import techguns.client.ShooterValues;
import techguns.client.models.ModelMultipart;
import techguns.client.particle.ITGParticle;
import techguns.items.guns.GenericGun;
import techguns.util.MathUtil;

public class RenderItemBase
implements IItemRenderer {
    public static final float SCALE = 0.0625f;
    protected ModelMultipart model;
    protected ResourceLocation texture;
    protected float baseScale = 1.0f;
    protected float scale_thirdp = 0.35f;
    protected float scale_ground = 0.5f;
    protected float scale_ego = 0.5f;
    protected float scale_gui = 0.4f;
    protected float scale_itemframe = 0.5f;
    protected float[] translateBase = new float[]{0.0f, 0.0f, 0.0f};
    protected float[][] translateType = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -0.05f}};
    protected int parts = 1;
    protected String ambientParticleFX = null;

    public RenderItemBase(ModelMultipart model, ResourceLocation texture) {
        this.model = model;
        this.texture = texture;
    }

    public RenderItemBase setGUIScale(float guiscale) {
        this.scale_gui = guiscale;
        return this;
    }

    public RenderItemBase setFirstPersonScale(float scale) {
        this.scale_ego = scale;
        return this;
    }

    public RenderItemBase setGroundAndFrameScale(float scale) {
        this.scale_ground = scale;
        this.scale_itemframe = scale;
        return this;
    }

    public RenderItemBase setBaseTranslation(float x, float y, float z) {
        this.translateBase[0] = x;
        this.translateBase[1] = y;
        this.translateBase[2] = z;
        return this;
    }

    public RenderItemBase setTransformTranslations(float[][] translations) {
        this.translateType = translations;
        return this;
    }

    public RenderItemBase setBaseScale(float baseScale) {
        this.baseScale = baseScale;
        return this;
    }

    protected float getScaleFactorFromTransform(ItemCameraTransforms.TransformType transform) {
        switch (transform) {
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                return this.baseScale * this.scale_ego;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return this.baseScale * this.scale_thirdp;
            }
            case GUI: {
                return this.baseScale * this.scale_gui;
            }
            case GROUND: {
                return this.baseScale * this.scale_ground;
            }
            case FIXED: {
                return this.baseScale * this.scale_itemframe;
            }
        }
        return this.baseScale;
    }

    protected void applyTranslation(ItemCameraTransforms.TransformType transform) {
        int index = -1;
        boolean flip = false;
        switch (transform) {
            case FIRST_PERSON_LEFT_HAND: {
                flip = true;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                index = 0;
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                flip = true;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                index = 1;
                break;
            }
            case GUI: {
                index = 2;
                break;
            }
            case GROUND: {
                index = 3;
                break;
            }
            case FIXED: {
                index = 4;
                break;
            }
        }
        if (index >= 0) {
            float mirror = flip ? -1.0f : 1.0f;
            GlStateManager.func_179109_b((float)(this.translateType[index][0] * mirror), (float)this.translateType[index][1], (float)this.translateType[index][2]);
        }
    }

    protected void applyBaseTranslation() {
        GlStateManager.func_179109_b((float)this.translateBase[0], (float)this.translateBase[1], (float)this.translateBase[2]);
    }

    @Override
    public void renderItem(ItemCameraTransforms.TransformType transform, ItemStack stack, EntityLivingBase elb, boolean leftHanded) {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.applyTranslation(transform);
        if (ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND != transform && ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND != transform && ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND != transform && ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND != transform) {
            if (ItemCameraTransforms.TransformType.GUI == transform) {
                GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (ItemCameraTransforms.TransformType.GROUND != transform && ItemCameraTransforms.TransformType.FIXED == transform) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.setBaseScale(elb, transform);
        this.setBaseRotation(transform);
        this.applyBaseTranslation();
        for (int i = 0; i < this.parts; ++i) {
            this.model.render((Entity)elb, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, 0, 0.0f, transform, i, 0.0f, 0.0f);
        }
        this.renderItemParticles(elb, transform, ClientProxy.get().PARTIAL_TICK_TIME);
        GlStateManager.func_179121_F();
    }

    protected void setBaseScale(EntityLivingBase entity, ItemCameraTransforms.TransformType transform) {
        float scale = this.getScaleFactorFromTransform(transform);
        if (entity != null && entity instanceof INPCTechgunsShooter) {
            INPCTechgunsShooter shooter = (INPCTechgunsShooter)entity;
            scale *= shooter.getGunScale();
        }
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    protected void setBaseRotation(ItemCameraTransforms.TransformType transform) {
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void renderItemParticles(EntityLivingBase ent, ItemCameraTransforms.TransformType transform, float ptt) {
        EnumHand hand = EnumHand.MAIN_HAND;
        if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            if (ent.func_184591_cq() == EnumHandSide.RIGHT) {
                hand = EnumHand.OFF_HAND;
            }
            EnumHandSide handSide = EnumHandSide.LEFT;
        } else if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            if (ent.func_184591_cq() == EnumHandSide.LEFT) {
                hand = EnumHand.OFF_HAND;
            }
            EnumHandSide handSide = EnumHandSide.RIGHT;
        } else {
            return;
        }
        List<ITGParticle> particles = null;
        if (ent instanceof EntityPlayer) {
            particles = hand == EnumHand.MAIN_HAND ? TGExtendedPlayerClient.get((EntityPlayer)ent).getEntityParticlesMH() : TGExtendedPlayerClient.get((EntityPlayer)ent).getEntityParticlesOH();
        } else if (ent instanceof INPCTechgunsShooter) {
            particles = hand == EnumHand.MAIN_HAND ? TGShooterValues.get(ent).getEntityParticlesMH() : TGShooterValues.get(ent).getEntityParticlesOH();
        }
        if (particles != null && !particles.isEmpty()) {
            GlStateManager.func_179129_p();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            particles.forEach(p -> p.doRender(buffer, (Entity)ent, ptt, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179089_o();
        }
    }

    public String getAmbientParticleFX() {
        return this.ambientParticleFX;
    }

    public RenderItemBase setAmbientParticleFX(String ambientParticleFX) {
        this.ambientParticleFX = ambientParticleFX;
        return this;
    }

    public static Vec3d getTransformAngles(EntityLivingBase entity, EnumHandSide hand, float ptt) {
        float limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - ptt);
        float limbSwingAmount = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * ptt;
        if (entity.func_70631_g_()) {
            limbSwing *= 3.0f;
        }
        if (limbSwingAmount > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        float f = 1.0f;
        float rAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        float lAngleX = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        float rAngleY = 0.0f;
        float lAngleY = 0.0f;
        float rAngleZ = 0.0f;
        float lAngleZ = 0.0f;
        if (entity.func_184218_aH()) {
            rAngleX += -0.62831855f;
            lAngleX += -0.62831855f;
        }
        ModelBiped.ArmPose leftArmPose = ModelBiped.ArmPose.EMPTY;
        ModelBiped.ArmPose rightArmPose = ModelBiped.ArmPose.ITEM;
        ItemStack stack = entity.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof GenericGun && ((GenericGun)stack.func_77973_b()).hasBowAnim()) {
            if (entity.func_184591_cq() == EnumHandSide.RIGHT) {
                rightArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            } else {
                leftArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        } else {
            ItemStack stack2 = entity.func_184592_cb();
            if (!stack2.func_190926_b() && stack2.func_77973_b() instanceof GenericGun && ((GenericGun)stack2.func_77973_b()).hasBowAnim() && ShooterValues.getIsCurrentlyUsingGun(entity, true)) {
                if (entity.func_184591_cq() == EnumHandSide.RIGHT) {
                    leftArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
                } else {
                    rightArmPose = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        switch (leftArmPose) {
            case EMPTY: {
                lAngleY = 0.0f;
                break;
            }
            case BLOCK: {
                lAngleX = lAngleX * 0.5f - 0.9424779f;
                lAngleY = 0.5235988f;
                break;
            }
            case ITEM: {
                lAngleX = lAngleX * 0.5f - 0.31415927f;
                lAngleY = 0.0f;
            }
        }
        switch (rightArmPose) {
            case EMPTY: {
                rAngleY = 0.0f;
                break;
            }
            case BLOCK: {
                rAngleX = rAngleX * 0.5f - 0.9424779f;
                rAngleY = -0.5235988f;
                break;
            }
            case ITEM: {
                rAngleX = rAngleX * 0.5f - 0.31415927f;
                rAngleY = 0.0f;
            }
        }
        float headPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * ptt;
        float bhrx = headPitch * ((float)Math.PI / 180);
        if (entity.field_70733_aJ > 0.0f) {
            float bbry = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)entity.field_70733_aJ) * ((float)Math.PI * 2))) * 0.2f;
            lAngleY += bbry;
            lAngleX += bbry;
            rAngleY += bbry;
            float f1 = 1.0f - entity.field_70733_aJ;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(entity.field_70733_aJ * (float)Math.PI)) * -(bhrx - 0.7f) * 0.75f;
            if (hand == EnumHandSide.LEFT) {
                lAngleX = (float)((double)lAngleX - ((double)f2 * 1.2 + (double)f3));
                lAngleY += bbry * 2.0f;
                lAngleZ += MathHelper.func_76126_a((float)(entity.field_70733_aJ * (float)Math.PI)) * -0.4f;
            } else {
                rAngleX = (float)((double)rAngleX - ((double)f2 * 1.2 + (double)f3));
                rAngleY += bbry * 2.0f;
                rAngleZ += MathHelper.func_76126_a((float)(entity.field_70733_aJ * (float)Math.PI)) * -0.4f;
            }
        }
        if (entity.func_70093_af()) {
            rAngleX += 0.4f;
            lAngleX += 0.4f;
        }
        float ageInTicks = (float)entity.field_70173_aa + ptt;
        rAngleZ += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        lAngleZ -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        rAngleX += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        lAngleX -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        float f_ = MathUtil.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, ptt);
        float f1_ = MathUtil.interpolateRotation(entity.field_70758_at, entity.field_70759_as, ptt);
        float netHeadYaw = f1_ - f_;
        float bhry = netHeadYaw * ((float)Math.PI / 180);
        if (rightArmPose == ModelBiped.ArmPose.BOW_AND_ARROW) {
            rAngleY = -0.1f + bhry;
            lAngleY = 0.1f + bhry + 0.4f;
            rAngleX = -1.5707964f + bhrx;
            lAngleX = -1.5707964f + bhrx;
        } else if (leftArmPose == ModelBiped.ArmPose.BOW_AND_ARROW) {
            rAngleY = -0.1f + bhry - 0.4f;
            lAngleY = 0.1f + bhry;
            rAngleX = -1.5707964f + bhrx;
            lAngleX = -1.5707964f + bhrx;
        }
        float entityYaw = (float)Math.PI / 180 * (entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * ptt);
        lAngleY += entityYaw;
        rAngleY += entityYaw;
        if (hand == EnumHandSide.LEFT) {
            return new Vec3d((double)lAngleX, (double)lAngleY, (double)lAngleZ);
        }
        return new Vec3d((double)rAngleX, (double)rAngleY, (double)rAngleZ);
    }
}

