/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class GunAnimation {
    static ICurveType C_ZERO = new ICurveType(){

        @Override
        public float f(float x) {
            return 0.0f;
        }
    };
    static ICurveType C_LINEAR = new ICurveType(){

        @Override
        public float f(float x) {
            return x;
        }
    };
    static ICurveType C_FAST = new ICurveType(){

        @Override
        public float f(float x) {
            return 1.0f - (1.0f - x) * (1.0f - x);
        }
    };
    static ICurveType C_SLOW = new ICurveType(){

        @Override
        public float f(float x) {
            return x * x;
        }
    };
    static ICurveType C_SMOOTH = new ICurveType(){

        @Override
        public float f(float x) {
            double d = Math.sin(Math.PI * (double)x * 0.5);
            return (float)(d * d);
        }
    };
    static ICurveType C_SINUS = new ICurveType(){

        @Override
        public float f(float x) {
            return (float)Math.sin(Math.PI * (double)x * 2.0);
        }
    };
    public static GunAnimation genericRecoil = new GunAnimation().addTranslate(0.0f, 0.0f, 1.0f).addRotate(1.0f, 1.0f, 0.0f, 0.0f).addSegment(0.0f, 0.25f, C_FAST, 0.0f, 1.0f).addSegment(0.25f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    public static GunAnimation swayRecoil = new GunAnimation().addTranslate(1.0f, 0.75f, 0.5f).addRotate(1.0f, 1.0f, -0.75f, 0.25f).addSegment(0.0f, 1.0f, C_SINUS, 0.0f, 1.0f);
    public static GunAnimation genericReload = new GunAnimation().addTranslate(-0.15f, -0.05f, 0.15f).addRotate(1.0f, -0.5f, 1.0f, -0.25f).addSegment(0.0f, 0.2f, C_SMOOTH, 0.0f, 1.0f).addSegment(0.2f, 0.8f, C_LINEAR, 1.0f, 1.0f).addSegment(0.8f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    public static GunAnimation breechReload = new GunAnimation().addTranslate(0.0f, 1.0f, -1.0f).addRotate(1.0f, -1.0f, 0.0f, 0.0f).addSegment(0.0f, 0.25f, C_SMOOTH, 0.0f, 1.0f).addSegment(0.25f, 0.5f, C_LINEAR, 1.0f, 1.0f).addSegment(0.5f, 0.85f, C_SMOOTH, 1.0f, -0.25f).addSegment(0.85f, 1.0f, C_SMOOTH, -0.25f, 0.0f);
    public static GunAnimation scopeRecoil = new GunAnimation().addTranslate(0.25f, 1.0f, 0.75f).addRotate(1.0f, 1.0f, 0.0f, 0.0f).addSegment(0.0f, 0.25f, C_FAST, 0.0f, 1.0f).addSegment(0.25f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    public static GunAnimation scopeRecoilAdv = new GunAnimation().addTranslate(1.0f, 0.0f, 0.0f).addTranslate(0.0f, 1.0f, 0.0f).addTranslate(0.0f, 0.0f, 1.0f).addRotate(1.0f, 1.0f, 0.0f, 0.0f).addSegment(0.0f, 0.25f, C_FAST, 0.0f, 1.0f).addSegment(0.25f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    public static GunAnimation pulseRifleRecoil = new GunAnimation().addTranslate(0.0f, 0.0f, 1.0f).addRotate(1.0f, 1.0f, 0.0f, 0.0f).addSegment(0.0f, 0.1f, C_FAST, 0.0f, 0.4f).addSegment(0.1f, 0.2f, C_SMOOTH, 0.4f, 0.3f).addSegment(0.2f, 0.4f, C_FAST, 0.3f, 1.0f).addSegment(0.4f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    public static GunAnimation swordSweepRecoil = new GunAnimation().addRotate(1.0f, 0.0f, 0.0f, 1.0f).addSegment(0.0f, 0.25f, C_FAST, 0.0f, 1.0f).addSegment(0.25f, 1.0f, C_SMOOTH, 1.0f, 0.0f);
    private List<AnimationSegment> segments = new ArrayList<AnimationSegment>();
    private List<Transformation> transformations = new ArrayList<Transformation>();

    public GunAnimation addSegment(float start, float end, ICurveType curve, float val1, float val2) {
        this.segments.add(new AnimationSegment(start, end, curve, val1, val2));
        return this;
    }

    public GunAnimation addTranslate(float x, float y, float z) {
        this.transformations.add(new Translate(x, y, z));
        return this;
    }

    public GunAnimation addRotate(float angle, float x, float y, float z) {
        this.transformations.add(new Rotate(angle, x, y, z));
        return this;
    }

    public void play(float progress, boolean mirror, float ... magnitudes) {
        float prev = 0.0f;
        float value = 0.0f;
        for (AnimationSegment segment : this.segments) {
            if (progress > segment.start && progress <= segment.end) {
                float p = (progress - prev) / (segment.end - segment.start);
                value += segment.getValue(p);
            }
            prev = segment.end;
        }
        int i = 0;
        for (Transformation trans : this.transformations) {
            float v = value;
            if (magnitudes.length > i) {
                v *= magnitudes[i++];
            }
            trans.apply(v, mirror);
        }
    }

    class Rotate
    extends Transformation {
        float angle;
        float x;
        float y;
        float z;

        public Rotate(float angle, float x, float y, float z) {
            this.angle = angle;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void apply(float f, boolean mirror) {
            GlStateManager.func_179114_b((float)(f * this.angle), (float)this.x, (float)(mirror ? -this.y : this.y), (float)(mirror ? -this.z : this.z));
        }
    }

    class Translate
    extends Transformation {
        float x;
        float y;
        float z;

        public Translate(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void apply(float f, boolean mirror) {
            GlStateManager.func_179109_b((float)(mirror ? this.x * -f : this.x * f), (float)(this.y * f), (float)(this.z * f));
        }
    }

    abstract class Transformation {
        Transformation() {
        }

        public abstract void apply(float var1, boolean var2);
    }

    static interface ICurveType {
        public float f(float var1);
    }

    class AnimationSegment {
        float start;
        float end;
        float val1;
        float val2;
        ICurveType curve;

        public AnimationSegment(float start, float end, ICurveType curve, float val1, float val2) {
            this.start = start;
            this.end = end;
            this.curve = curve;
            this.val1 = val1;
            this.val2 = val2;
        }

        public float getValue(float progress) {
            float v = this.curve.f(progress);
            return this.val1 + v * (this.val2 - this.val1);
        }
    }
}

