/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.projectiles;

import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import techguns.client.render.TGRenderHelper;
import techguns.entities.projectiles.TeslaProjectile;

public class RenderTeslaProjectile
extends Render<TeslaProjectile> {
    static final int SIN_COUNT = 5;
    static final double WIDTH = 0.5;
    static final double SIN_DISTANCE = 10.0;
    double offset = 0.2;
    private ResourceLocation texture = new ResourceLocation("techguns:textures/fx/laser_blue.png");
    private ResourceLocation textureStart;
    private double laserWidth = 3.0;
    private TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.ADDITIVE;

    public RenderTeslaProjectile(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(TeslaProjectile laser, double posX, double posY, double posZ, float entityYaw, float partialTicks) {
        double distance = laser.distance;
        short maxTicks = laser.maxTicks;
        float progress = (float)laser.field_70173_aa / (float)maxTicks;
        Random rand = new Random(laser.seed);
        double[] dY = new double[5];
        double[] dZ = new double[5];
        for (int i = 0; i < 5; ++i) {
            dY[i] = 0.5 - rand.nextDouble();
            dZ[i] = 0.5 - rand.nextDouble();
        }
        int count = (int)Math.round(distance / this.offset);
        this.offset = distance / (double)count;
        float xOffset = 0.0f;
        int xreps = Math.max(1, (int)Math.round(distance / 10.0));
        double xprev = 0.0;
        double yprev = 0.0;
        double zprev = 0.0;
        double widthprev = 1.0;
        double alphaprev = 1.0;
        double u = distance / this.laserWidth * 2.0;
        this.func_180548_c(laser);
        GlStateManager.func_179094_E();
        TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179129_p();
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
        GlStateManager.func_179114_b((float)(laser.laserYaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)laser.laserPitch, (float)0.0f, (float)0.0f, (float)1.0f);
        for (int i = 0; i <= count; ++i) {
            double d = (double)i / (double)count;
            double x = (double)xOffset + (double)i * this.offset;
            double y = 0.0;
            double z = 0.0;
            double randomness = 0.0;
            if (i > 1) {
                for (int j = 1; j <= 5; ++j) {
                    double yfactor = (rand.nextDouble() - 0.5 + (double)progress * dY[j - 1] * 1.0) * (2.0 / (double)j);
                    double zfactor = (rand.nextDouble() - 0.5 + (double)progress * dZ[j - 1] * 1.0) * (2.0 / (double)j);
                    y += Math.sin(d * Math.PI * (double)(j * xreps)) * yfactor;
                    z += Math.sin(d * Math.PI * (double)(j * xreps)) * zfactor;
                }
            }
            double pulse = 1.0 - Math.sqrt(Math.abs((double)progress - d) * 2.0);
            double width = Math.max(0.0, 0.5 * pulse);
            if (i >= 1) {
                this.drawSegment(xprev, yprev, zprev, x, y, z, widthprev, width, alphaprev, pulse);
            }
            widthprev = width;
            alphaprev = pulse;
            xprev = x;
            yprev = y;
            zprev = z;
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179121_F();
    }

    void drawSegment(double x1, double y1, double z1, double x2, double y2, double z2, double width1, double width2, double a1, double a2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double scale = 0.5;
        y1 *= scale;
        y2 *= scale;
        z1 *= scale;
        z2 *= scale;
        width2 *= scale;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x1, y1 - (width1 *= scale), z1).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x1, y1 + width1, z1).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x2, y2 + width2, z2).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x2, y2 - width2, z2).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x1, y1, z1 - width1).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x1, y1, z1 + width1).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x2, y2, z2 + width2).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        bufferbuilder.func_181662_b(x2, y2, z2 - width2).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)a1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(TeslaProjectile entity) {
        return this.texture;
    }
}

