/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.projectiles;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import techguns.client.render.TGRenderHelper;
import techguns.entities.projectiles.NDRProjectile;
import techguns.util.MathUtil;

public class RenderNDRProjectile
extends Render<NDRProjectile> {
    private static final ResourceLocation LaserTextures = new ResourceLocation("techguns:textures/fx/nukebeam.png");
    private double laserWidth = 3.0;

    public RenderNDRProjectile(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(NDRProjectile entity, double p_x, double p_y, double p_z, float entityYaw, float ptt) {
        Random rand = new Random(entity.func_145782_y());
        double distance = entity.distance;
        float prog = ((float)entity.field_70173_aa + ptt) / (float)entity.maxTicks;
        double width = this.laserWidth * Math.sin(Math.sqrt(prog) * Math.PI) * 2.0;
        Entity e = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(entity.shooterID);
        EntityLivingBase shooter = null;
        if (e instanceof EntityLivingBase) {
            shooter = (EntityLivingBase)e;
        }
        if (shooter == null) {
            return;
        }
        this.func_180548_c(entity);
        double x = shooter.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70165_t;
        double y = shooter.field_70163_u + (double)shooter.func_70047_e() - Minecraft.func_71410_x().field_71439_g.field_70163_u;
        double z = shooter.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70161_v;
        float pitch = MathUtil.interpolateRotation(shooter.field_70127_C, shooter.field_70125_A, ptt);
        float yaw = MathUtil.interpolateRotation(shooter.field_70758_at, shooter.field_70759_as, ptt);
        if (shooter != Minecraft.func_71410_x().field_71439_g || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            x -= (double)(MathHelper.func_76134_b((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            y -= (double)-0.1f - (double)entity.get3PYOffset();
            z -= (double)(MathHelper.func_76126_a((float)(shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-(yaw - 90.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.08, (double)-0.12);
        if (shooter == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && Minecraft.func_71410_x().field_71474_y.field_74336_f) {
            this.setupViewBobbing(ptt);
        }
        GlStateManager.func_179137_b((double)-0.25, (double)0.0, (double)0.0);
        distance += 0.25;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f10 = 0.0125f;
        distance *= 80.0;
        float rot_x = 45.0f + prog * 360.0f;
        GlStateManager.func_179114_b((float)(rot_x + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)f10, (float)f10, (float)f10);
        float brightness = (float)Math.sin(Math.sqrt(prog) * Math.PI);
        double UVscale = 2.0;
        int numFrames = 17;
        float frametime = 0.5f;
        double u = distance / (this.laserWidth * 8.0 * UVscale);
        int frame = (int)(((float)entity.field_70173_aa + ptt) * frametime % (float)numFrames);
        double v1 = 1.0 / (double)numFrames * (double)frame;
        double v2 = 1.0 / (double)numFrames * (double)(frame + 1);
        TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)f10);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(-distance, -width, 0.0).func_187315_a((double)(0 + i), v1).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(0.0, -width, 0.0).func_187315_a(u + (double)i, v1).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(0.0, width, 0.0).func_187315_a(u + (double)i, v2).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(-distance, width, 0.0).func_187315_a((double)(0 + i), v2).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            tessellator.func_78381_a();
        }
        distance = Math.min(distance, 400.0);
        int segments = (int)(distance / 8.0);
        double w = 4.0;
        double radius = 0.0;
        double angle = 0.39269908169872414;
        double prevX = 0.0;
        double prevY = 0.0;
        double prevZ = 0.0;
        double prevu = 0.0;
        double cos2 = Math.cos((Math.PI - angle) * 0.5) * 2.0;
        double angleOffset = rand.nextDouble() * Math.PI * 2.0;
        UVscale = 8.0;
        double d = distance / (double)segments;
        for (int i = 0; i < segments; ++i) {
            x = -d * (double)i;
            float iprog = (float)i / (float)segments;
            radius = 0.5 * (1.0 - Math.cos(2.0 * Math.sqrt(iprog) * Math.PI)) * 8.0;
            Vec2f yz = MathUtil.polarOffsetXZ(0.0f, 0.0f, (float)radius, (float)(angleOffset - angle * (double)i));
            y = yz.field_189982_i;
            z = yz.field_189983_j;
            u = prevu + cos2 * radius / UVscale;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(prevX - w, prevY, prevZ).func_187315_a(prevu, v2).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(x - w, y, z).func_187315_a(u, v2).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(x + w, y, z).func_187315_a(u, v1).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            bufferbuilder.func_181662_b(prevX + w, prevY, prevZ).func_187315_a(prevu, v1).func_181666_a(1.0f, 1.0f, 1.0f, brightness).func_181675_d();
            tessellator.func_78381_a();
            prevX = x;
            prevY = y;
            prevZ = z;
            prevu = u;
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179089_o();
        TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
        GlStateManager.func_179121_F();
    }

    private void setupViewBobbing(float p_78475_1_) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * p_78475_1_);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * p_78475_1_;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * p_78475_1_;
            float F1 = -1.0f;
            float F2 = -1.0f;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f * F1), (float)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3) * F2), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(NDRProjectile entity) {
        return LaserTextures;
    }
}

