/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.npcs;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.opengl.GL11;
import techguns.entities.npcs.AttackHelicopter;

public class RenderAttackHelicopter
extends RenderLiving<AttackHelicopter> {
    public static ResourceLocation texture = new ResourceLocation("techguns", "textures/entity/apache.png");
    private static final ModelResourceLocation modelLoc0 = new ModelResourceLocation(new ResourceLocation("techguns", "helicopter0"), "inventory");
    private static final ModelResourceLocation modelLoc1 = new ModelResourceLocation(new ResourceLocation("techguns", "helicopter1"), "inventory");
    private static final ModelResourceLocation modelLoc2 = new ModelResourceLocation(new ResourceLocation("techguns", "helicopter2"), "inventory");
    private static IBakedModel helicopter_main;
    private static IBakedModel helicopter_rotor;
    private static IBakedModel helicopter_gun;
    private final VertexLighterFlat lighter = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al());

    public static void initModels() {
        helicopter_main = RenderAttackHelicopter.loadAndBakedModel(modelLoc0, texture);
        helicopter_rotor = RenderAttackHelicopter.loadAndBakedModel(modelLoc1, texture);
        helicopter_gun = RenderAttackHelicopter.loadAndBakedModel(modelLoc2, texture);
    }

    public static IBakedModel loadAndBakedModel(ModelResourceLocation model_loc, ResourceLocation tex) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)model_loc, (String)("Could not load model:" + model_loc.toString()));
        IBakedModel bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, r -> {
            TextureAtlasSprite sprite = new TextureAtlasSprite(texture.func_110623_a()){};
            try {
                PngSizeInfo png = PngSizeInfo.func_188532_a((IResource)Minecraft.func_71410_x().func_110442_L().func_110536_a(tex));
                sprite.func_188538_a(png, false);
                sprite.func_110971_a(png.field_188533_a, png.field_188534_b, 0, 0, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return sprite;
        });
        return bakedModel;
    }

    public RenderAttackHelicopter(RenderManager rendermanagerIn) {
        super(rendermanagerIn, new ModelBase(){}, 5.0f);
    }

    protected ResourceLocation getEntityTexture(AttackHelicopter entity) {
        return texture;
    }

    public void doRender(AttackHelicopter entity, double x, double y, double z, float entityYaw, float partialTicks) {
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v);
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179114_b((float)(-this.interp(entity.field_70177_z, entity.field_70126_B, partialTicks) - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float scale = 2.5f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.func_180548_c((Entity)entity);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        this.lighter.setWorld((IBlockAccess)entity.field_70170_p);
        this.lighter.setState(Blocks.field_150350_a.func_176223_P());
        this.lighter.setBlockPos(pos);
        if (entity.field_70725_aQ == 0) {
            this.renderBakedModel(tessellator, builder, helicopter_main);
            GlStateManager.func_179094_E();
            float angle = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) + partialTicks) * 24.0f;
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBakedModel(tessellator, builder, helicopter_rotor);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            float offsetX = 1.2f;
            GlStateManager.func_179109_b((float)offsetX, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.interp(entity.field_70125_A, entity.field_70127_C, partialTicks)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-offsetX), (float)0.0f, (float)0.0f);
            this.renderBakedModel(tessellator, builder, helicopter_gun);
            GlStateManager.func_179121_F();
        } else {
            float deathProgress = ((float)entity.field_70725_aQ + partialTicks) / 100.0f;
            float p = (float)Math.pow(deathProgress, 2.0);
            GlStateManager.func_179109_b((float)0.0f, (float)(p * -4.0f), (float)0.0f);
            float angle = p * 720.0f;
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBakedModel(tessellator, builder, helicopter_main);
            this.renderBakedModel(tessellator, builder, helicopter_gun);
            angle = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) + partialTicks) * 12.0f;
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBakedModel(tessellator, builder, helicopter_rotor);
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    protected void renderBakedModel(Tessellator tessellator, BufferBuilder builder, IBakedModel bakedModel) {
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.lighter.setParent((IVertexConsumer)new VertexBufferConsumer(builder));
        boolean empty = true;
        List quads = bakedModel.func_188616_a(null, null, 0L);
        if (!quads.isEmpty()) {
            this.lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)this.lighter);
            }
        }
        for (EnumFacing side : EnumFacing.values()) {
            quads = bakedModel.func_188616_a(null, side, 0L);
            if (quads.isEmpty()) continue;
            if (empty) {
                this.lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)this.lighter);
            }
        }
        builder.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public float interp(float val, float prev_value, float ptt) {
        return prev_value + (val - prev_value) * ptt;
    }
}

