/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import techguns.items.armors.ICamoChangeable;

public class RenderAdditionalSlotItem {
    protected ModelBiped model;
    protected ModelBiped model_slim = null;
    protected ResourceLocation[] textures;
    protected ResourceLocation[] textures_slim;

    public RenderAdditionalSlotItem(ModelBiped model, ResourceLocation ... textures) {
        this.model = model;
        this.textures = textures;
    }

    public RenderAdditionalSlotItem(ModelBiped model, String modid, String texture_name, int count) {
        this.model = model;
        this.textures = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            this.textures[i] = new ResourceLocation(modid, texture_name + (i == 0 ? "" : "_" + i) + ".png");
        }
    }

    public RenderAdditionalSlotItem(ModelBiped model, ResourceLocation texture) {
        this(model, (ModelBiped)null, texture, (ResourceLocation)null);
    }

    public RenderAdditionalSlotItem(ModelBiped model, ModelBiped modelslim, ResourceLocation texture, ResourceLocation texture_slim) {
        this.model = model;
        this.model_slim = modelslim;
        this.textures = new ResourceLocation[]{texture};
        this.textures_slim = new ResourceLocation[]{texture_slim};
    }

    public void render(ItemStack slot, EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, RenderPlayer renderplayer) {
        AbstractClientPlayer acp;
        boolean slim = false;
        if (this.model_slim != null && player instanceof AbstractClientPlayer && (acp = (AbstractClientPlayer)player).func_175154_l().equals("slim")) {
            slim = true;
        }
        ModelBiped m = slim ? this.model_slim : this.model;
        int tex_index = 0;
        if (slot.func_77973_b() instanceof ICamoChangeable) {
            tex_index = ((ICamoChangeable)slot.func_77973_b()).getCurrentCamoIndex(slot);
        }
        m.func_178686_a((ModelBase)renderplayer.func_177087_b());
        m.func_78086_a((EntityLivingBase)player, limbSwing, limbSwingAmount, partialTicks);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(slim ? this.textures_slim[tex_index] : this.textures[tex_index]);
        m.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }
}

