/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.client.ClientProxy;
import techguns.client.particle.ITGParticle;
import techguns.client.particle.TGFX;
import techguns.client.particle.TGParticle;
import techguns.client.particle.TGParticleStreak;
import techguns.client.particle.TGParticleSystemType;
import techguns.util.EntityCondition;
import techguns.util.MathUtil;

@SideOnly(value=Side.CLIENT)
public class TGParticleSystem
extends Particle
implements ITGParticle {
    public TGParticleSystemType type;
    public EntityCondition condition = EntityCondition.NONE;
    int systemLifetime;
    int spawnDelay = 0;
    public float scale = 1.0f;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public int initialDelay;
    public int ticksExisted = 0;
    public float startSizeRate;
    public float startSizeRateDamping;
    public float startSize = 0.0f;
    protected TGParticleStreak prevParticle = null;
    Entity entity;
    public boolean attachToHead = false;
    public Vec3d entityOffset = null;
    TGParticle parent;
    protected boolean itemAttached = false;

    public TGParticleSystem(World worldIn, TGParticleSystemType type, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn + type.offset.field_72450_a, yCoordIn + type.offset.field_72448_b, zCoordIn + type.offset.field_72449_c);
        this.field_187129_i = xSpeedIn;
        this.field_187130_j = ySpeedIn;
        this.field_187131_k = zSpeedIn;
        this.type = type;
        this.init();
    }

    public TGParticleSystem(Entity entity, TGParticleSystemType type) {
        this(entity.field_70170_p, type, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
        this.entity = entity;
    }

    public TGParticleSystem(World worldIn, TGParticle part, TGParticleSystemType type) {
        this(worldIn, type, part.posX(), part.posY(), part.posZ(), 0.0, 0.0, 0.0);
        this.parent = part;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
    }

    protected void init() {
        this.systemLifetime = MathUtil.randomInt(this.field_187136_p, this.type.systemLifetimeMin, this.type.systemLifetimeMax);
        this.initialDelay = MathUtil.randomInt(this.field_187136_p, this.type.initialDelayMin, this.type.initialDelayMax);
        this.startSizeRate = MathUtil.randomFloat(this.field_187136_p, this.type.startSizeRateMin, this.type.startSizeRateMax) * this.scale;
        this.startSizeRateDamping = MathUtil.randomFloat(this.field_187136_p, this.type.startSizeRateDampingMin, this.type.startSizeRateDampingMax);
    }

    public void func_189213_a() {
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.type == null) {
            this.func_187112_i();
            return;
        }
        if (this.entity != null && !this.itemAttached) {
            if (!this.condition.evaluate(this.entity)) {
                this.func_187112_i();
                return;
            }
            if (this.attachToHead && this.entity instanceof EntityLivingBase) {
                EntityLivingBase elb = (EntityLivingBase)this.entity;
                this.rotationPitch = elb.field_70125_A;
                this.rotationYaw = elb.field_70759_as;
                Vec3d offset = this.type.offset;
                if (this.entityOffset != null) {
                    offset = offset.func_178787_e(this.entityOffset);
                }
                offset = offset.func_178789_a((float)((double)(-elb.field_70125_A) * (Math.PI / 180)));
                offset = offset.func_178785_b((float)((double)(-elb.field_70759_as) * (Math.PI / 180)));
                this.field_187126_f = elb.field_70169_q + offset.field_72450_a;
                this.field_187127_g = elb.field_70167_r + (double)elb.func_70047_e() + offset.field_72448_b;
                this.field_187128_h = elb.field_70166_s + offset.field_72449_c;
            } else {
                this.rotationPitch = this.entity.field_70125_A;
                this.rotationYaw = this.entity.field_70177_z;
                Vec3d offset = this.type.offset;
                if (this.entityOffset != null) {
                    offset = offset.func_178787_e(this.entityOffset);
                }
                offset = offset.func_178789_a((float)((double)(-this.entity.field_70125_A) * (Math.PI / 180)));
                offset = offset.func_178785_b((float)((double)(-this.entity.field_70177_z) * (Math.PI / 180)));
                this.field_187126_f = this.entity.field_70169_q + offset.field_72450_a;
                this.field_187127_g = this.entity.field_70167_r + offset.field_72448_b;
                this.field_187128_h = this.entity.field_70166_s + offset.field_72449_c;
            }
            this.field_187129_i = this.entity.field_70159_w;
            this.field_187130_j = this.entity.field_70181_x;
            this.field_187131_k = this.entity.field_70179_y;
        } else if (this.parent != null) {
            this.field_187126_f = this.parent.posX() + this.type.offset.field_72450_a;
            this.field_187127_g = this.parent.posY() + this.type.offset.field_72448_b;
            this.field_187128_h = this.parent.posZ() + this.type.offset.field_72449_c;
        } else {
            this.field_187126_f += this.field_187129_i;
            this.field_187127_g += this.field_187130_j;
            this.field_187128_h += this.field_187131_k;
        }
        if (this.initialDelay-- > 0) {
            return;
        }
        this.startSize += this.startSizeRate;
        this.startSizeRate *= this.startSizeRateDamping;
        if (this.spawnDelay-- <= 0) {
            int count = MathUtil.randomInt(this.field_187136_p, this.type.particleCountMin, this.type.particleCountMax);
            for (int i = 0; i < count; ++i) {
                List<TGParticleSystem> systems;
                TGParticle particle;
                TGParticleSystemType tGParticleSystemType = this.type;
                tGParticleSystemType.getClass();
                TGParticleSystemType.DirResult dir = new TGParticleSystemType.DirResult(tGParticleSystemType, new float[0]);
                Vec3d position = this.type.volumeType.getPosition(this, dir, i, count);
                Vec3d motion = this.type.velocityType.getVelocity(this, dir.values);
                motion = motion.func_186678_a((double)this.scale);
                position = position.func_186678_a((double)this.scale);
                motion = motion.func_178789_a((float)((double)(-this.rotationPitch) * (Math.PI / 180)));
                motion = motion.func_178785_b((float)((double)(-this.rotationYaw) * (Math.PI / 180)));
                if (this.type.volumeType != TGParticleSystemType.VOL_TRAIL) {
                    position = position.func_178789_a((float)((double)(-this.rotationPitch) * (Math.PI / 180)));
                    position = position.func_178785_b((float)((double)(-this.rotationYaw) * (Math.PI / 180)));
                }
                double mf = 0.05;
                if (this.type.streak) {
                    TGParticleStreak particleStreak = new TGParticleStreak(this.field_187122_b, this.field_187126_f + position.field_72450_a, this.field_187127_g + position.field_72448_b, this.field_187128_h + position.field_72449_c, motion.field_72450_a * mf, motion.field_72448_b * mf, motion.field_72449_c * mf, this);
                    if (this.prevParticle != null) {
                        particleStreak.setPrev(this.prevParticle);
                        this.prevParticle.setNext(particleStreak);
                    }
                    this.addEffect(particleStreak);
                    this.prevParticle = particleStreak;
                    particle = particleStreak;
                } else {
                    particle = new TGParticle(this.field_187122_b, this.field_187126_f + position.field_72450_a, this.field_187127_g + position.field_72448_b, this.field_187128_h + position.field_72449_c, motion.field_72450_a * mf, motion.field_72448_b * mf, motion.field_72449_c * mf, this);
                    this.addEffect(particle);
                }
                if (this.type.attachedSystem == null || this.type.attachedSystem.equals("") || (systems = TGFX.createFXOnParticle(this.field_187122_b, particle, this.type.attachedSystem)) == null) continue;
                for (TGParticleSystem s : systems) {
                    s.scale = this.scale;
                    this.addEffect(s);
                }
            }
            this.spawnDelay = MathUtil.randomInt(this.field_187136_p, this.type.spawnDelayMin, this.type.spawnDelayMax);
        }
        if (this.entity != null) {
            if (this.entity.field_70128_L) {
                this.func_187112_i();
            } else if (this.systemLifetime > 0 && this.ticksExisted >= this.systemLifetime) {
                this.func_187112_i();
            }
        } else if (this.parent != null) {
            if (!this.parent.func_187113_k()) {
                this.func_187112_i();
            }
        } else if (this.ticksExisted >= this.systemLifetime) {
            this.func_187112_i();
        }
        ++this.ticksExisted;
    }

    protected void addEffect(ITGParticle s) {
        ClientProxy.get().particleManager.addEffect(s);
    }

    public int func_70537_b() {
        return 1;
    }

    public double posX() {
        return this.field_187126_f;
    }

    public double posY() {
        return this.field_187127_g;
    }

    public double posZ() {
        return this.field_187128_h;
    }

    public double motionX() {
        return this.field_187129_i;
    }

    public double motionY() {
        return this.field_187130_j;
    }

    public double motionZ() {
        return this.field_187131_k;
    }

    @Override
    public Vec3d getPos() {
        return new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    @Override
    public boolean shouldRemove() {
        return !this.func_187113_k();
    }

    @Override
    public void updateTick() {
        this.func_189213_a();
    }

    @Override
    public void doRender(BufferBuilder buffer, Entity entityIn, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        this.func_180434_a(buffer, entityIn, partialTickTime, rotX, rotZ, rotYZ, rotXY, rotXZ);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(float partialTickTime, Entity viewEntity) {
        float s = 0.5f;
        return new AxisAlignedBB(this.field_187126_f - (double)s, this.field_187127_g - (double)s, this.field_187128_h - (double)s, this.field_187126_f + (double)s, this.field_187127_g + (double)s, this.field_187128_h + (double)s);
    }

    @Override
    public double getDepth() {
        return 0.0;
    }

    @Override
    public void setDepth(double depth) {
    }

    @Override
    public void setItemAttached() {
    }

    public void func_187112_i() {
        super.func_187112_i();
        this.entity = null;
    }
}

