/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import techguns.client.particle.TGFX;
import techguns.client.particle.TGFXType;
import techguns.client.particle.TGParticle;
import techguns.client.particle.TGParticleSystem;

public class TGParticleListType
extends TGFXType {
    ArrayList<ParticleSystemEntry> particleSystems = new ArrayList();

    public TGParticleListType() {
        this.isList = true;
    }

    public void addParticleSystem(String particleSystem) {
        this.particleSystems.add(new ParticleSystemEntry(particleSystem));
    }

    @Override
    public List<TGParticleSystem> createParticleSystems(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!TGFX.FXList.containsKey(system.particleSystem)) continue;
            TGFXType fxtype = TGFX.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystems(world, posX, posY, posZ, motionX, motionY, motionZ));
        }
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnEntity(Entity ent) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!TGFX.FXList.containsKey(system.particleSystem)) continue;
            TGFXType fxtype = TGFX.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystemsOnEntity(ent));
        }
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnEntityItemAttached(Entity ent, EnumHand hand) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!TGFX.FXList.containsKey(system.particleSystem)) continue;
            TGFXType fxtype = TGFX.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystemsOnEntityItemAttached(ent, hand));
        }
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnParticle(World worldIn, TGParticle ent) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        for (ParticleSystemEntry system : this.particleSystems) {
            if (!TGFX.FXList.containsKey(system.particleSystem)) continue;
            TGFXType fxtype = TGFX.FXList.get(system.particleSystem);
            list.addAll(fxtype.createParticleSystemsOnParticle(worldIn, ent));
        }
        return list;
    }

    class ParticleSystemEntry {
        String particleSystem;

        public ParticleSystemEntry(String particleSystem) {
            this.particleSystem = particleSystem;
        }
    }
}

