/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.blocks.GenericBlock;
import techguns.blocks.GenericItemBlockMeta;
import techguns.util.BlockUtils;

public class BlockTGStairs
extends GenericBlock {
    protected GenericItemBlockMeta itemblock;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<BlockStairs.EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockStairs.EnumHalf.class);
    public static final PropertyEnum<BlockStairs.EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", BlockStairs.EnumShape.class);
    public static final PropertyBool TYPE2 = PropertyBool.func_177716_a((String)"type2");
    protected static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);

    public BlockTGStairs(String name, Material mat, SoundType sound) {
        super(name, mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a(HALF, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.STRAIGHT).func_177226_a((IProperty)TYPE2, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(sound);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)TYPE2, state.func_177229_b((IProperty)TYPE2)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockTGStairs.getCollisionBoxList(state)) {
            BlockTGStairs.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        boolean flag = bstate.func_177229_b(HALF) == BlockStairs.EnumHalf.TOP;
        list.add(flag ? AABB_SLAB_TOP : AABB_SLAB_BOTTOM);
        BlockStairs.EnumShape blockstairs$enumshape = (BlockStairs.EnumShape)bstate.func_177229_b(SHAPE);
        if (blockstairs$enumshape == BlockStairs.EnumShape.STRAIGHT || blockstairs$enumshape == BlockStairs.EnumShape.INNER_LEFT || blockstairs$enumshape == BlockStairs.EnumShape.INNER_RIGHT) {
            list.add(BlockTGStairs.getCollQuarterBlock(bstate));
        }
        if (blockstairs$enumshape != BlockStairs.EnumShape.STRAIGHT) {
            list.add(BlockTGStairs.getCollEighthBlock(bstate));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        boolean flag = bstate.func_177229_b(HALF) == BlockStairs.EnumHalf.TOP;
        switch ((EnumFacing)bstate.func_177229_b((IProperty)FACING)) {
            default: {
                return flag ? AABB_QTR_BOT_NORTH : AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return flag ? AABB_QTR_BOT_SOUTH : AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return flag ? AABB_QTR_BOT_WEST : AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return flag ? AABB_QTR_BOT_EAST : AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)bstate.func_177229_b((IProperty)FACING);
        switch ((BlockStairs.EnumShape)bstate.func_177229_b(SHAPE)) {
            default: {
                enumfacing1 = enumfacing;
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.func_176735_f();
            }
        }
        boolean flag = bstate.func_177229_b(HALF) == BlockStairs.EnumHalf.TOP;
        switch (enumfacing1) {
            default: {
                return flag ? AABB_OCT_BOT_NW : AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return flag ? AABB_OCT_BOT_SE : AABB_OCT_TOP_SE;
            }
            case WEST: {
                return flag ? AABB_OCT_BOT_SW : AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return flag ? AABB_OCT_BOT_NE : AABB_OCT_TOP_NE;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        p_193383_2_ = this.func_176221_a(p_193383_2_, p_193383_1_, p_193383_3_);
        if (p_193383_4_.func_176740_k() == EnumFacing.Axis.Y) {
            return p_193383_4_ == EnumFacing.UP == (p_193383_2_.func_177229_b(HALF) == BlockStairs.EnumHalf.TOP) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        BlockStairs.EnumShape blockstairs$enumshape = (BlockStairs.EnumShape)p_193383_2_.func_177229_b(SHAPE);
        if (blockstairs$enumshape != BlockStairs.EnumShape.OUTER_LEFT && blockstairs$enumshape != BlockStairs.EnumShape.OUTER_RIGHT) {
            EnumFacing enumfacing = (EnumFacing)p_193383_2_.func_177229_b((IProperty)FACING);
            switch (blockstairs$enumshape) {
                case INNER_RIGHT: {
                    return enumfacing != p_193383_4_ && enumfacing != p_193383_4_.func_176735_f() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case INNER_LEFT: {
                    return enumfacing != p_193383_4_ && enumfacing != p_193383_4_.func_176746_e() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case STRAIGHT: {
                    return enumfacing == p_193383_4_ ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(HALF) == BlockStairs.EnumHalf.TOP;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P())));
        items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)TYPE2, (Comparable)Boolean.valueOf(true)))));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate.func_177226_a(HALF, (Comparable)BlockStairs.EnumHalf.BOTTOM) : iblockstate.func_177226_a(HALF, (Comparable)BlockStairs.EnumHalf.TOP);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockTGStairs.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE2, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a(HALF, (Comparable)BlockStairs.EnumHalf.values()[(meta & 4) >> 2]).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return (((Boolean)state.func_177229_b((IProperty)TYPE2) != false ? 1 : 0) << 3) + (((BlockStairs.EnumHalf)state.func_177229_b(HALF)).ordinal() << 2) + ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)BlockTGStairs.getStairsShape(state, worldIn, pos));
    }

    private static BlockStairs.EnumShape getStairsShape(IBlockState p_185706_0_, IBlockAccess p_185706_1_, BlockPos p_185706_2_) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING);
        IBlockState iblockstate = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing));
        if (BlockTGStairs.isBlockStairs(iblockstate) && p_185706_0_.func_177229_b(HALF) == iblockstate.func_177229_b(HALF) && (enumfacing1 = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING)).func_176740_k() && BlockTGStairs.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing1.func_176734_d())) {
            if (enumfacing1 == enumfacing.func_176735_f()) {
                return BlockStairs.EnumShape.OUTER_LEFT;
            }
            return BlockStairs.EnumShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing.func_176734_d()));
        if (BlockTGStairs.isBlockStairs(iblockstate1) && p_185706_0_.func_177229_b(HALF) == iblockstate1.func_177229_b(HALF) && (enumfacing2 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING)).func_176740_k() && BlockTGStairs.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing2)) {
            if (enumfacing2 == enumfacing.func_176735_f()) {
                return BlockStairs.EnumShape.INNER_LEFT;
            }
            return BlockStairs.EnumShape.INNER_RIGHT;
        }
        return BlockStairs.EnumShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState p_185704_0_, IBlockAccess p_185704_1_, BlockPos p_185704_2_, EnumFacing p_185704_3_) {
        IBlockState iblockstate = p_185704_1_.func_180495_p(p_185704_2_.func_177972_a(p_185704_3_));
        return !BlockTGStairs.isBlockStairs(iblockstate) || iblockstate.func_177229_b((IProperty)FACING) != p_185704_0_.func_177229_b((IProperty)FACING) || iblockstate.func_177229_b(HALF) != p_185704_0_.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockStairs || state.func_177230_c() instanceof BlockTGStairs;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockStairs.EnumShape blockstairs$enumshape = (BlockStairs.EnumShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF, SHAPE, TYPE2});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        state = this.func_176221_a(state, world, pos);
        BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)state.func_177229_b(HALF);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)state.func_177229_b(SHAPE);
        if (face == EnumFacing.UP) {
            return half == BlockStairs.EnumHalf.TOP;
        }
        if (face == EnumFacing.DOWN) {
            return half == BlockStairs.EnumHalf.BOTTOM;
        }
        if (shape == BlockStairs.EnumShape.OUTER_LEFT || shape == BlockStairs.EnumShape.OUTER_RIGHT) {
            return false;
        }
        if (face == side) {
            return true;
        }
        if (shape == BlockStairs.EnumShape.INNER_LEFT && face.func_176746_e() == side) {
            return true;
        }
        return shape == BlockStairs.EnumShape.INNER_RIGHT && face.func_176735_f() == side;
    }

    @Override
    public ItemBlock createItemBlock() {
        this.itemblock = new GenericItemBlockMeta(this);
        return this.itemblock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        IBlockState state = this.func_176223_P();
        IBlockState state2 = this.func_176223_P().func_177226_a((IProperty)TYPE2, (Comparable)Boolean.valueOf(true));
        ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state)));
        ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state2), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state2)));
    }
}

