/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.blocks.GenericBlock;
import techguns.blocks.GenericItemBlockMeta;
import techguns.blocks.ItemBlockLamp;
import techguns.items.armors.ICamoChangeable;

public class BlockTGLamp<T extends Enum<T>>
extends GenericBlock
implements ICamoChangeable {
    public PropertyEnum<T> LAMP_TYPE;
    protected Class<T> clazz;
    protected BlockStateContainer blockStateOverride;
    protected GenericItemBlockMeta itemblock;
    public static final PropertyBool CONNECT_DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool CONNECT_UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool CONNECT_N = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool CONNECT_S = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool CONNECT_W = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool CONNECT_E = PropertyBool.func_177716_a((String)"east");
    protected static final double lamp_side = 0.25;
    protected static final double lamp_side_max = 0.75;
    protected static final double lamp_h = 0.1875;
    public static final AxisAlignedBB LAMP_DOWN_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.1875, 0.75);
    public static final AxisAlignedBB LAMP_UP_AABB = new AxisAlignedBB(0.25, 0.8125, 0.25, 0.75, 1.0, 0.75);
    public static final AxisAlignedBB LAMP_NORTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.1875);
    public static final AxisAlignedBB LAMP_SOUTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.8125, 0.75, 0.75, 1.0);
    public static final AxisAlignedBB LAMP_WEST_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.1875, 0.75, 0.75);
    public static final AxisAlignedBB LAMP_EAST_AABB = new AxisAlignedBB(0.8125, 0.25, 0.25, 1.0, 0.75, 0.75);
    protected static final double lantern_side = 0.25;
    protected static final double lantern_side_max = 0.75;
    protected static final double lantern_h = 0.125;
    public static final AxisAlignedBB LANTERN_AABB = new AxisAlignedBB(0.25, 0.125, 0.25, 0.75, 0.875, 0.75);

    public BlockTGLamp(String name, Class<T> clazz) {
        super(name, Material.field_151573_f, MapColor.field_151673_t);
        this.func_149672_a(SoundType.field_185853_f);
        this.clazz = clazz;
        this.LAMP_TYPE = PropertyEnum.func_177709_a((String)"lamp_type", clazz);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.LAMP_TYPE}).add(new IProperty[]{FACING_ALL}).add(new IProperty[]{CONNECT_DOWN}).add(new IProperty[]{CONNECT_UP}).add(new IProperty[]{CONNECT_N}).add(new IProperty[]{CONNECT_S}).add(new IProperty[]{CONNECT_W}).add(new IProperty[]{CONNECT_E}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.func_149711_c(0.25f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(1.0f);
        this.func_149713_g(0);
    }

    public BlockStateContainer func_176194_O() {
        return this.blockStateOverride;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, state.func_177229_b(this.LAMP_TYPE)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((state = this.func_176221_a(state, source, pos)).func_177229_b(this.LAMP_TYPE) == ((Enum[])this.clazz.getEnumConstants())[0] || state.func_177229_b(this.LAMP_TYPE) == ((Enum[])this.clazz.getEnumConstants())[1]) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING_ALL)) {
                case UP: {
                    return LAMP_UP_AABB;
                }
                case EAST: {
                    return LAMP_EAST_AABB;
                }
                case NORTH: {
                    return LAMP_NORTH_AABB;
                }
                case SOUTH: {
                    return LAMP_SOUTH_AABB;
                }
                case WEST: {
                    return LAMP_WEST_AABB;
                }
            }
            return LAMP_DOWN_AABB;
        }
        return LANTERN_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public ItemBlock createItemBlock() {
        this.itemblock = new ItemBlockLamp(this);
        return this.itemblock;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState s = this.func_176223_P();
        if (meta < 6) {
            s = s.func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[0])).func_177226_a((IProperty)FACING_ALL, (Comparable)EnumFacing.func_82600_a((int)meta));
        } else if (meta < 12) {
            s = s.func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[1])).func_177226_a((IProperty)FACING_ALL, (Comparable)EnumFacing.func_82600_a((int)(meta - 6)));
        } else if (meta == 12) {
            s = s.func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[2]));
        } else if (meta == 13) {
            s = s.func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[3]));
        }
        return s;
    }

    public int func_176201_c(IBlockState state) {
        Enum t = (Enum)((Object)state.func_177229_b(this.LAMP_TYPE));
        if (t.ordinal() == 0) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING_ALL)).func_176745_a();
        }
        if (t.ordinal() == 1) {
            return 6 + ((EnumFacing)state.func_177229_b((IProperty)FACING_ALL)).func_176745_a();
        }
        if (t.ordinal() == 2) {
            return 12;
        }
        if (t.ordinal() == 3) {
            return 13;
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int type = ((Enum)((Object)state.func_177229_b(this.LAMP_TYPE))).ordinal();
        if (type == 0 || type == 1) {
            return state.func_177226_a((IProperty)CONNECT_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECT_DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECT_E, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECT_W, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECT_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECT_S, (Comparable)Boolean.valueOf(false));
        }
        boolean u = this.canPlaceAt(worldIn, pos, EnumFacing.UP);
        boolean d = this.canPlaceAt(worldIn, pos, EnumFacing.DOWN);
        boolean n = this.canPlaceAt(worldIn, pos, EnumFacing.NORTH);
        boolean s = this.canPlaceAt(worldIn, pos, EnumFacing.SOUTH);
        boolean w = this.canPlaceAt(worldIn, pos, EnumFacing.WEST);
        boolean e = this.canPlaceAt(worldIn, pos, EnumFacing.EAST);
        return state.func_177226_a((IProperty)CONNECT_UP, (Comparable)Boolean.valueOf(u)).func_177226_a((IProperty)CONNECT_DOWN, (Comparable)Boolean.valueOf(d)).func_177226_a((IProperty)CONNECT_E, (Comparable)Boolean.valueOf(e)).func_177226_a((IProperty)CONNECT_W, (Comparable)Boolean.valueOf(w)).func_177226_a((IProperty)CONNECT_N, (Comparable)Boolean.valueOf(n)).func_177226_a((IProperty)CONNECT_S, (Comparable)Boolean.valueOf(s));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176203_a(meta);
        return state.func_177226_a((IProperty)FACING_ALL, (Comparable)facing.func_176734_d());
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (Enum t : (Enum[])this.clazz.getEnumConstants()) {
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)t)))));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING_ALL.func_177700_c()) {
            if (!this.canPlaceAt((IBlockAccess)worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, blockpos, facing);
        if ((facing.equals((Object)EnumFacing.UP) || facing.equals((Object)EnumFacing.DOWN)) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockTGLamp.func_193382_c((Block)block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return false;
    }

    private boolean canPlaceOn(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING_ALL);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn((IBlockAccess)worldIn, blockpos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt((IBlockAccess)worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING_ALL))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        for (int i = 0; i < ((Enum[])this.clazz.getEnumConstants()).length; ++i) {
            IBlockState state = this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[i]));
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("techguns", "lamp_inventory_" + ((IStringSerializable)((Enum[])this.clazz.getEnumConstants())[i]).func_176610_l()), "inventory"));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState state, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public int getCamoCount() {
        return 1;
    }

    @Override
    public int switchCamo(ItemStack item, boolean back) {
        IBlockState state = this.func_176203_a(item.func_77960_j());
        int type = ((Enum)((Object)state.func_177229_b(this.LAMP_TYPE))).ordinal();
        int newmeta = 0;
        if (type == 0) {
            newmeta = this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[1])));
        } else if (type == 1) {
            newmeta = this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[0])));
        } else if (type == 2) {
            newmeta = this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[3])));
        } else if (type == 3) {
            newmeta = this.func_176201_c(this.func_176223_P().func_177226_a(this.LAMP_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[2])));
        }
        item.func_77964_b(newmeta);
        return newmeta;
    }

    @Override
    public int getCurrentCamoIndex(ItemStack item) {
        IBlockState state = this.func_176203_a(item.func_77960_j());
        int type = ((Enum)((Object)state.func_177229_b(this.LAMP_TYPE))).ordinal();
        if (type == 0 || type == 2) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        return "techguns." + this.getRegistryName().func_110623_a() + ".camoname." + this.getCurrentCamoIndex(item);
    }

    @Override
    public boolean addBlockCamoChangeRecipes() {
        return false;
    }
}

